/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class DisbandCommand
extends AbstractCommand {
    public DisbandCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        Optional optionalFactionName = context.getOne("faction name");
        if (optionalFactionName.isPresent()) {
            if (!EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_NEED_TO_TOGGLE_FACTION_ADMIN_MODE_TO_DO_THIS}));
            }
            Faction faction = super.getPlugin().getFactionLogic().getFactionByName((String)optionalFactionName.get());
            if (faction == null) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.THERE_IS_NO_FACTION_CALLED + " ", TextColors.GOLD, (String)optionalFactionName.get() + "!"}));
            }
            boolean didSecceed = super.getPlugin().getFactionLogic().disbandFaction(faction.getName());
            if (didSecceed) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.FACTION_HAS_BEEN_DISBANDED}));
            } else {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, PluginMessages.SOMETHING_WENT_WRONG}));
            }
            return CommandResult.success();
        }
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (playerFaction.getName().equalsIgnoreCase("SafeZone") || playerFaction.getName().equalsIgnoreCase("WarZone")) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "This faction cannot be disbanded!"}));
        }
        if (EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
            boolean didSucceed = super.getPlugin().getFactionLogic().disbandFaction(playerFaction.getName());
            if (didSucceed) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.FACTION_HAS_BEEN_DISBANDED}));
                EagleFactionsPlugin.AUTO_CLAIM_LIST.remove(player.getUniqueId());
                EagleFactionsPlugin.CHAT_LIST.remove(player.getUniqueId());
            } else {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, PluginMessages.SOMETHING_WENT_WRONG}));
            }
            return CommandResult.success();
        }
        if (!playerFaction.getLeader().equals(player.getUniqueId())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, PluginMessages.YOU_MUST_BE_THE_FACTIONS_LEADER_TO_DO_THIS}));
        }
        boolean didSucceed = super.getPlugin().getFactionLogic().disbandFaction(playerFaction.getName());
        if (didSucceed) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.FACTION_HAS_BEEN_DISBANDED}));
            EagleFactionsPlugin.AUTO_CLAIM_LIST.remove(player.getUniqueId());
            EagleFactionsPlugin.CHAT_LIST.remove(player.getUniqueId());
        } else {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, PluginMessages.SOMETHING_WENT_WRONG}));
        }
        return CommandResult.success();
    }
}

