/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionFlagTypes;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class FlagsCommand
extends AbstractCommand {
    public FlagsCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        if (source instanceof Player) {
            Player player = (Player)source;
            Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
            if (optionalPlayerFaction.isPresent()) {
                Faction faction = optionalPlayerFaction.get();
                if (faction.getLeader().equals(player.getUniqueId()) || EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
                    this.showFlags(player, faction);
                } else {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_THE_FACTIONS_LEADER_TO_DO_THIS}));
                }
            } else {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
            }
        } else {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        return CommandResult.success();
    }

    private void showFlags(Player player, Faction faction) {
        Text.Builder textBuilder = Text.builder();
        for (Map.Entry<FactionMemberType, Map<FactionFlagTypes, Boolean>> memberEntry : faction.getFlags().entrySet()) {
            Map<FactionFlagTypes, Boolean> memberFlags = memberEntry.getValue();
            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, memberEntry.getKey().toString() + ": "})});
            for (Map.Entry<FactionFlagTypes, Boolean> flagEntry : memberFlags.entrySet()) {
                Text.Builder flagTextBuilder = Text.builder();
                if (flagEntry.getValue().booleanValue()) {
                    flagTextBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, flagEntry.getKey().toString()})});
                } else {
                    flagTextBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.RED, flagEntry.getKey().toString()})});
                }
                flagTextBuilder.onClick((ClickAction)TextActions.executeCallback(this.toggleFlag(faction, memberEntry.getKey(), flagEntry.getKey(), flagEntry.getValue() == false)));
                flagTextBuilder.onHover((HoverAction)TextActions.showText((Text)Text.of((String)(PluginMessages.SET_TO + " " + String.valueOf(flagEntry.getValue() == false).toUpperCase()))));
                textBuilder.append(new Text[]{flagTextBuilder.build()});
                textBuilder.append(new Text[]{Text.of((String)" | ")});
            }
            textBuilder.append(new Text[]{Text.of((String)"\n")});
        }
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.CLICK_ON_THE_PERMISSION_YOU_WANT_TO_CHANGE}));
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "RED", TextColors.RESET, " = " + PluginMessages.HAS_NOT_PERMISSIONS_FOR}));
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, "GREEN", TextColors.RESET, " = " + PluginMessages.HAS_PERMISSIONS_FOR}));
        player.sendMessage((Text)Text.of((String)"=============================="));
        player.sendMessage(textBuilder.build());
    }

    private Consumer<CommandSource> toggleFlag(Faction faction, FactionMemberType factionMemberType, FactionFlagTypes factionFlagTypes, Boolean flagValue) {
        return commandSource -> {
            this.getPlugin().getFactionLogic().toggleFlag(faction, factionMemberType, factionFlagTypes, flagValue);
            this.showFlags((Player)commandSource, faction);
        };
    }
}

