/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class InfoCommand
extends AbstractCommand {
    public InfoCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalFactionName = context.getOne("faction name");
        if (optionalFactionName.isPresent()) {
            String rawFactionName = (String)optionalFactionName.get();
            Faction faction = this.getPlugin().getFactionLogic().getFactionByName(rawFactionName);
            if (faction == null) {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.THERE_IS_NO_FACTION_CALLED + " ", TextColors.GOLD, rawFactionName + "!"}));
            } else if (source.hasPermission("eaglefactions.player.info") || source.hasPermission("eaglefactions.player.info.self") || source.hasPermission("eaglefactions.player.info.others")) {
                if (!source.hasPermission("eaglefactions.player.info") && !source.hasPermission("eaglefactions.player.info.self") && source instanceof Player && this.getPlugin().getFactionLogic().getFactionByPlayerUUID(((Player)source).getUniqueId()).isPresent() && this.getPlugin().getFactionLogic().getFactionByPlayerUUID(((Player)source).getUniqueId()).get().getName().equals(faction.getName())) {
                    source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_DONT_HAVE_PERMISSIONS_FOR_VEWING_INFO_ABOUT_YOUR_FACTION}));
                } else if (!source.hasPermission("eaglefactions.player.info") && !source.hasPermission("eaglefactions.player.info.others") && source instanceof Player && this.getPlugin().getFactionLogic().getFactionByPlayerUUID(((Player)source).getUniqueId()).isPresent() && !this.getPlugin().getFactionLogic().getFactionByPlayerUUID(((Player)source).getUniqueId()).get().getName().equals(faction.getName())) {
                    source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_DONT_HAVE_PERMISSIONS_FOR_VEWING_INFO_ABOUT_OTHER_FACTIONS}));
                } else {
                    this.showFactionInfo(source, faction);
                }
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_DONT_HAVE_PERMISSIONS_TO_USE_THIS_COMMAND}));
            }
        } else if (source instanceof Player && super.getPlugin().getFactionLogic().getFactionByPlayerUUID(((Player)source).getUniqueId()).isPresent()) {
            if (source.hasPermission("eaglefactions.player.info") || source.hasPermission("eaglefactions.player.info.self")) {
                this.showFactionInfo(source, super.getPlugin().getFactionLogic().getFactionByPlayerUUID(((Player)source).getUniqueId()).get());
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_DONT_HAVE_PERMISSIONS_FOR_VEWING_INFO_ABOUT_YOUR_FACTION}));
            }
        } else {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.WRONG_COMMAND_ARGUMENTS}));
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, PluginMessages.USAGE + " /f info <faction name>"}));
        }
        return CommandResult.success();
    }

    private void showFactionInfo(CommandSource source, Faction faction) {
        Optional<String> optionalName2;
        ArrayList<Text> factionInfo = new ArrayList<Text>();
        String leaderName = "";
        if (faction.getLeader() != null && !faction.getLeader().equals(new UUID(0L, 0L)) && (optionalName2 = this.getPlugin().getPlayerManager().getPlayerName(faction.getLeader())).isPresent()) {
            leaderName = optionalName2.get();
        }
        String recruitList = "";
        if (!faction.getRecruits().isEmpty()) {
            recruitList = faction.getRecruits().stream().map(recruit -> this.getPlugin().getPlayerManager().getPlayerName((UUID)recruit)).filter(optionalName -> optionalName.isPresent()).map(optionalName -> (String)optionalName.get()).collect(Collectors.joining(", "));
        }
        String membersList = "";
        if (!faction.getMembers().isEmpty()) {
            membersList = faction.getMembers().stream().map(member -> this.getPlugin().getPlayerManager().getPlayerName((UUID)member)).filter(optionalName -> optionalName.isPresent()).map(optionalName -> (String)optionalName.get()).collect(Collectors.joining(", "));
        }
        String officersList = "";
        if (!faction.getOfficers().isEmpty()) {
            officersList = faction.getOfficers().stream().map(officer -> this.getPlugin().getPlayerManager().getPlayerName((UUID)officer)).filter(optionalName -> optionalName.isPresent()).map(optionalName -> (String)optionalName.get()).collect(Collectors.joining(", "));
        }
        String alliancesList = "";
        if (!faction.getAlliances().isEmpty()) {
            alliancesList = faction.getAlliances().stream().collect(Collectors.joining(", "));
        }
        String enemiesList = "";
        if (!faction.getEnemies().isEmpty()) {
            enemiesList = faction.getEnemies().stream().collect(Collectors.joining(", "));
        }
        Text info = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.NAME + ": ", TextColors.GOLD, faction.getName() + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.TAG + ": "}), faction.getTag().toBuilder().color(TextColors.GOLD).build(), Text.of((String)"\n")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.LAST_ONLINE + ": "}), this.lastOnline(faction), Text.of((String)"\n")}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.DESCRIPTION + ": ", TextColors.GOLD, faction.getDescription() + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.MOTD + ": ", TextColors.GOLD, faction.getMessageOfTheDay() + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.PUBLIC + ": ", TextColors.GOLD, faction.isPublic() + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.LEADER + ": ", TextColors.GOLD, leaderName + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.OFFICERS + ": ", TextColors.GOLD, officersList + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.ALLIANCES + ": ", TextColors.BLUE, alliancesList + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.ENEMIES + ": ", TextColors.RED, enemiesList + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.MEMBERS + ": ", TextColors.GREEN, membersList + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.RECRUITS + ": ", TextColors.GREEN, recruitList + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.POWER + ": ", TextColors.GOLD, super.getPlugin().getPowerManager().getFactionPower(faction) + "/" + super.getPlugin().getPowerManager().getFactionMaxPower(faction) + "\n"})}).append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.CLAIMS + ": ", TextColors.GOLD, faction.getClaims().size() + "/" + super.getPlugin().getPowerManager().getFactionMaxClaims(faction)})}).build();
        factionInfo.add(info);
        PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get();
        PaginationList.Builder paginationBuilder = paginationService.builder().title(Text.of((Object[])new Object[]{TextColors.GREEN, PluginMessages.FACTION_INFO})).contents(factionInfo);
        paginationBuilder.sendTo((MessageReceiver)source);
    }

    private Text lastOnline(Faction faction) {
        if (this.getPlugin().getFactionLogic().hasOnlinePlayers(faction)) {
            return Text.of((Object[])new Object[]{TextColors.GREEN, PluginMessages.NOW});
        }
        Date date = Date.from(faction.getLastOnline());
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String formattedDate = formatter.format(date);
        return Text.of((Object[])new Object[]{TextColors.RED, formattedDate});
    }
}

