/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.Invite;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class InviteCommand
extends AbstractCommand {
    private final FactionsConfig factionsConfig;

    public InviteCommand(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Player invitedPlayer = (Player)context.requireOne("player");
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player senderPlayer = (Player)source;
        Optional<Faction> optionalSenderFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(senderPlayer.getUniqueId());
        if (!optionalSenderFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction senderFaction = optionalSenderFaction.get();
        if (!super.getPlugin().getFlagManager().canInvite(senderPlayer.getUniqueId(), senderFaction)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PLAYERS_WITH_YOUR_RANK_CANT_INVITE_PLAYERS_TO_FACTION}));
        }
        if (this.factionsConfig.isPlayerLimit()) {
            int playerCount = 0;
            playerCount += senderFaction.getLeader().toString().equals("") ? 0 : 1;
            playerCount += senderFaction.getOfficers().isEmpty() ? 0 : senderFaction.getOfficers().size();
            playerCount += senderFaction.getMembers().isEmpty() ? 0 : senderFaction.getMembers().size();
            if ((playerCount += senderFaction.getRecruits().isEmpty() ? 0 : senderFaction.getRecruits().size()) >= this.factionsConfig.getPlayerLimit()) {
                senderPlayer.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_CANT_INVITE_MORE_PLAYERS_TO_YOUR_FACTION + " " + PluginMessages.FACTIONS_PLAYER_LIMIT_HAS_BEEN_REACHED}));
                return CommandResult.success();
            }
        }
        if (super.getPlugin().getFactionLogic().getFactionByPlayerUUID(invitedPlayer.getUniqueId()).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PLAYER_IS_ALREADY_IN_A_FACTION}));
        }
        Invite invite = new Invite(senderFaction.getName(), invitedPlayer.getUniqueId());
        EagleFactionsPlugin.INVITE_LIST.add(invite);
        invitedPlayer.sendMessage(this.getInviteGetMessage(senderFaction));
        senderPlayer.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.YOU_INVITED + " ", TextColors.GOLD, invitedPlayer.getName(), TextColors.GREEN, " " + PluginMessages.TO_YOUR_FACTION}));
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.execute(() -> EagleFactionsPlugin.INVITE_LIST.remove(invite)).delay(2L, TimeUnit.MINUTES).name("EagleFaction - Remove Invite").submit((Object)EagleFactionsPlugin.getPlugin());
        return CommandResult.success();
    }

    private Text getInviteGetMessage(Faction senderFaction) {
        Text clickHereText = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "[", TextColors.GOLD, PluginMessages.CLICK_HERE, TextColors.AQUA, "]"})}).onClick((ClickAction)TextActions.runCommand((String)("/f join " + senderFaction.getName()))).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.GOLD, "/f join " + senderFaction.getName()}))).build();
        return Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.FACTION + " ", TextColors.GOLD, senderFaction.getName(), TextColors.GREEN, " " + PluginMessages.HAS_SENT_YOU_AN_INVITE + "\n", PluginMessages.YOU_HAVE_TWO_MINUTES_TO_ACCEPT_IT + "\n", clickHereText, TextColors.GREEN, " " + PluginMessages.TO_ACCEPT_INVITATION_OR_TYPE + " ", TextColors.GOLD, "/f join " + senderFaction.getName()});
    }
}

