/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.Invite;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class JoinCommand
extends AbstractCommand {
    private final FactionsConfig factionsConfig;

    public JoinCommand(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalFactionName = context.getOne("faction name");
        if (!optionalFactionName.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.WRONG_COMMAND_ARGUMENTS + "\n" + PluginMessages.USAGE + " /f join <faction name>"}));
        }
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        String rawFactionName = (String)optionalFactionName.get();
        if (super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId()).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_ARE_ALREADY_IN_A_FACTION}));
        }
        Faction faction = this.getPlugin().getFactionLogic().getFactionByName(rawFactionName);
        if (faction == null) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.THERE_IS_NO_FACTION_CALLED + " ", TextColors.GOLD, rawFactionName + "!"}));
            return CommandResult.success();
        }
        if (EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
            return this.joinFactionAndNotify(player, faction);
        }
        if (!faction.isPublic()) {
            boolean hasInvite = false;
            for (Invite invite : EagleFactionsPlugin.INVITE_LIST) {
                if (!invite.getPlayerUUID().equals(player.getUniqueId()) || !invite.getFactionName().equals(faction.getName())) continue;
                hasInvite = true;
            }
            if (!hasInvite) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_HAVENT_BEEN_INVITED_TO_THIS_FACTION}));
            }
        }
        if (this.factionsConfig.isPlayerLimit()) {
            int playerCount = 0;
            playerCount += faction.getLeader().toString().equals("") ? 0 : 1;
            playerCount += faction.getOfficers().isEmpty() ? 0 : faction.getOfficers().size();
            playerCount += faction.getMembers().isEmpty() ? 0 : faction.getMembers().size();
            if ((playerCount += faction.getRecruits().isEmpty() ? 0 : faction.getRecruits().size()) >= this.factionsConfig.getPlayerLimit()) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_CANT_JOIN_THIS_FACTION_BECAUSE_IT_REACHED_ITS_PLAYER_LIMIT}));
            }
        }
        return this.joinFactionAndNotify(player, faction);
    }

    private CommandResult joinFactionAndNotify(Player player, Faction faction) {
        boolean isCancelled = EventRunner.runFactionJoinEvent(player, faction);
        if (isCancelled) {
            return CommandResult.success();
        }
        super.getPlugin().getFactionLogic().joinFaction(player.getUniqueId(), faction.getName());
        EagleFactionsPlugin.INVITE_LIST.remove(new Invite(faction.getName(), player.getUniqueId()));
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.SUCCESSFULLY_JOINED_FACTION + " ", TextColors.GOLD, faction.getName()}));
        return CommandResult.success();
    }
}

