/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class MapCommand
extends AbstractCommand {
    private final ProtectionConfig protectionConfig;
    private final FactionsConfig factionsConfig;

    public MapCommand(EagleFactions plugin) {
        super(plugin);
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        if (source instanceof Player) {
            Player player = (Player)source;
            if (this.protectionConfig.getClaimableWorldNames().contains(player.getWorld().getName())) {
                this.generateMap(player);
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_CANT_VIEW_MAP_IN_THIS_WORLD}));
            }
        } else {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        return CommandResult.success();
    }

    private void generateMap(Player player) {
        Set<Claim> claimsList = super.getPlugin().getFactionLogic().getAllClaims();
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        boolean showPlayerFactionClaimsOnly = this.factionsConfig.shouldShowOnlyPlayerFactionsClaimsInMap();
        World world = player.getWorld();
        Text notCapturedMark = Text.of((Object[])new Object[]{TextColors.GRAY, "/"});
        Text factionMark = Text.of((Object[])new Object[]{TextColors.GREEN, "+"});
        Text allianceMark = Text.of((Object[])new Object[]{TextColors.AQUA, "+"});
        Text enemyMark = Text.of((Object[])new Object[]{TextColors.RED, "#"});
        Text normalFactionMark = Text.of((Object[])new Object[]{TextColors.WHITE, "+"});
        Text playerLocationMark = Text.of((Object[])new Object[]{TextColors.GOLD, "+"});
        Vector3i playerPosition = player.getLocation().getChunkPosition();
        ArrayList<Text> map = new ArrayList<Text>();
        ArrayList<String> normalFactions = new ArrayList<String>();
        ArrayList<String> allianceFactions = new ArrayList<String>();
        ArrayList<String> enemyFactions = new ArrayList<String>();
        int mapWidth = 18;
        int mapHeight = 7;
        int halfMapWidth = mapWidth / 2;
        int halfMapHeight = mapHeight / 2;
        for (int row = -halfMapHeight; row <= halfMapHeight; ++row) {
            Text.Builder textBuilder = Text.builder();
            for (int column = -halfMapWidth; column <= halfMapWidth; ++column) {
                if (row == 0 && column == 0) {
                    textBuilder.append(new Text[]{playerLocationMark});
                    continue;
                }
                Vector3i chunk = playerPosition.add(column, 0, row);
                Claim claim = new Claim(world.getUniqueId(), chunk);
                if (claimsList.contains(claim)) {
                    Optional<Faction> optionalChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), chunk);
                    if (optionalChunkFaction.isPresent()) {
                        if (optionalPlayerFaction.isPresent()) {
                            Faction playerFaction = optionalPlayerFaction.get();
                            if (optionalChunkFaction.get().getName().equals(playerFaction.getName())) {
                                textBuilder.append(new Text[]{factionMark.toBuilder().onClick((ClickAction)TextActions.executeCallback(this.claimByMap(player, chunk))).build()});
                                continue;
                            }
                            if (!showPlayerFactionClaimsOnly && playerFaction.getAlliances().contains(optionalChunkFaction.get().getName())) {
                                textBuilder.append(new Text[]{allianceMark});
                                if (allianceFactions.contains(optionalChunkFaction.get().getName())) continue;
                                allianceFactions.add(optionalChunkFaction.get().getName());
                                continue;
                            }
                            if (!showPlayerFactionClaimsOnly && playerFaction.getEnemies().contains(optionalChunkFaction.get().getName())) {
                                textBuilder.append(new Text[]{enemyMark});
                                if (enemyFactions.contains(optionalChunkFaction.get().getName())) continue;
                                enemyFactions.add(optionalChunkFaction.get().getName());
                                continue;
                            }
                            if (optionalChunkFaction.get().getName().equals("SafeZone")) {
                                textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "+"})});
                            } else if (optionalChunkFaction.get().getName().equals("WarZone")) {
                                textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_RED, "#"})});
                            } else if (!showPlayerFactionClaimsOnly) {
                                textBuilder.append(new Text[]{normalFactionMark});
                            } else {
                                textBuilder.append(new Text[]{notCapturedMark});
                            }
                            if (showPlayerFactionClaimsOnly || normalFactions.contains(optionalChunkFaction.get().getName())) continue;
                            normalFactions.add(optionalChunkFaction.get().getName());
                            continue;
                        }
                        if (optionalChunkFaction.get().getName().equals("SafeZone")) {
                            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "+"})});
                        } else if (optionalChunkFaction.get().getName().equals("WarZone")) {
                            textBuilder.append(new Text[]{Text.of((Object[])new Object[]{TextColors.DARK_RED, "#"})});
                        } else if (!showPlayerFactionClaimsOnly) {
                            textBuilder.append(new Text[]{normalFactionMark});
                        } else {
                            textBuilder.append(new Text[]{notCapturedMark});
                        }
                        if (showPlayerFactionClaimsOnly || normalFactions.contains(optionalChunkFaction.get().getName())) continue;
                        normalFactions.add(optionalChunkFaction.get().getName());
                        continue;
                    }
                    Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Something went really wrong..."}));
                    Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Chunk exists in claim list but not in the factions' list."}));
                    Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Chunk: ", TextColors.GOLD, claim.toString()}));
                    Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Player that used map: ", TextColors.GOLD, player.toString()}));
                    Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Check if this claim exists in the ", TextColors.GOLD, "factions.conf."}));
                    Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "And report this bug to the plugin owner."}));
                    continue;
                }
                if (!this.factionsConfig.shouldDelayClaim() && (EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId()) || optionalPlayerFaction.isPresent() && (optionalPlayerFaction.get().getLeader().equals(player.getUniqueId()) || optionalPlayerFaction.get().getOfficers().contains(player.getUniqueId())))) {
                    textBuilder.append(new Text[]{notCapturedMark.toBuilder().onClick((ClickAction)TextActions.executeCallback(this.claimByMap(player, chunk))).build()});
                    continue;
                }
                textBuilder.append(new Text[]{notCapturedMark});
            }
            map.add(textBuilder.build());
        }
        String playerPositionClaim = "none";
        Optional<Faction> optionalPlayerPositionFaction = this.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), playerPosition);
        if (optionalPlayerPositionFaction.isPresent()) {
            playerPositionClaim = optionalPlayerPositionFaction.get().getName();
        }
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, PluginMessages.FACTIONS_MAP_HEADER}));
        for (Text text : map) {
            player.sendMessage(Text.of((Object[])new Object[]{text}));
        }
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, PluginMessages.FACTIONS_MAP_FOOTER}));
        if (optionalPlayerFaction.isPresent()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, PluginMessages.YOUR_FACTION + ": ", TextColors.GREEN, optionalPlayerFaction.get().getName()}));
        }
        if (!normalFactions.isEmpty()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.WHITE, PluginMessages.FACTIONS + ": ", TextColors.RESET, String.join((CharSequence)",", normalFactions)}));
        }
        if (!allianceFactions.isEmpty()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.AQUA, PluginMessages.ALLIANCES + ": " + String.join((CharSequence)",", allianceFactions)}));
        }
        if (!enemyFactions.isEmpty()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, PluginMessages.ENEMIES + ": " + String.join((CharSequence)",", enemyFactions)}));
        }
        player.sendMessage(Text.of((Object[])new Object[]{PluginMessages.CURRENTLY_STANDING_AT + ": ", TextColors.GOLD, playerPosition.toString(), TextColors.WHITE, " " + PluginMessages.WHICH_IS_CLAIMED_BY + " ", TextColors.GOLD, playerPositionClaim}));
    }

    private Consumer<CommandSource> claimByMap(Player player, Vector3i chunk) {
        return consumer -> {
            Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
            World world = player.getWorld();
            Claim claim = new Claim(player.getWorld().getUniqueId(), chunk);
            boolean hasFactionsAdminMode = EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId());
            if (!optionalPlayerFaction.isPresent()) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
                return;
            }
            Faction playerFaction = optionalPlayerFaction.get();
            boolean hasClaimPermission = super.getPlugin().getFlagManager().canClaim(player.getUniqueId(), playerFaction);
            boolean isFactionAttacked = EagleFactionsPlugin.ATTACKED_FACTIONS.containsKey(playerFaction.getName());
            if (!hasFactionsAdminMode && !hasClaimPermission) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PLAYERS_WITH_YOUR_RANK_CANT_CLAIM_LANDS}));
                return;
            }
            if (super.getPlugin().getFactionLogic().isClaimed(world.getUniqueId(), chunk)) {
                Location homeLocation;
                if (playerFaction.getHome() != null && world.getUniqueId().equals(playerFaction.getHome().getWorldUUID()) && (homeLocation = world.getLocation(playerFaction.getHome().getBlockPosition())).getChunkPosition().toString().equals(player.getLocation().getChunkPosition().toString())) {
                    super.getPlugin().getFactionLogic().setHome(world.getUniqueId(), playerFaction, null);
                }
                super.getPlugin().getFactionLogic().removeClaim(playerFaction, new Claim(world.getUniqueId(), chunk));
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.LAND_HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, PluginMessages.UNCLAIMED, TextColors.WHITE, "!"}));
            } else {
                if (isFactionAttacked) {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOUR_FACTION_IS_UNDER_ATTACK + " " + PluginMessages.YOU_NEED_TO_WAIT + " ", TextColors.GOLD, PluginMessages.TWO_MINUTES, TextColors.RED, " " + PluginMessages.TO_BE_ABLE_TO_CLAIM_AGAIN}));
                    return;
                }
                if (super.getPlugin().getPowerManager().getFactionMaxClaims(playerFaction) <= playerFaction.getClaims().size()) {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOUR_FACTION_DOES_NOT_HAVE_POWER_TO_CLAIM_MORE_LANDS}));
                    return;
                }
                if (playerFaction.getName().equalsIgnoreCase("SafeZone") || playerFaction.getName().equalsIgnoreCase("WarZone")) {
                    super.getPlugin().getFactionLogic().addClaim(playerFaction, claim);
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.LAND + " ", TextColors.GOLD, chunk.toString(), TextColors.WHITE, " " + PluginMessages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, PluginMessages.CLAIMED, TextColors.WHITE, "!"}));
                } else if (this.factionsConfig.requireConnectedClaims()) {
                    if (super.getPlugin().getFactionLogic().isClaimConnected(playerFaction, claim)) {
                        super.getPlugin().getFactionLogic().startClaiming(player, playerFaction, world.getUniqueId(), chunk);
                    } else {
                        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.CLAIMS_NEED_TO_BE_CONNECTED}));
                    }
                } else {
                    super.getPlugin().getFactionLogic().startClaiming(player, playerFaction, world.getUniqueId(), chunk);
                }
            }
            this.generateMap(player);
        };
    }
}

