/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class MaxPowerCommand
extends AbstractCommand {
    public MaxPowerCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalSelectedPlayer = context.getOne((Text)Text.of((String)"player"));
        Optional optionalPower = context.getOne((Text)Text.of((String)"power"));
        if (optionalSelectedPlayer.isPresent() && optionalPower.isPresent()) {
            if (source instanceof Player) {
                Player player = (Player)source;
                if (EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
                    this.setMaxPower(source, (Player)optionalSelectedPlayer.get(), (String)optionalPower.get());
                } else {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_NEED_TO_TOGGLE_FACTION_ADMIN_MODE_TO_DO_THIS}));
                }
            } else {
                this.setMaxPower(source, (Player)optionalSelectedPlayer.get(), (String)optionalPower.get());
            }
        } else {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.WRONG_COMMAND_ARGUMENTS}));
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, PluginMessages.USAGE + " /f maxpower <player> <power>"}));
        }
        return CommandResult.success();
    }

    private void setMaxPower(CommandSource source, Player player, String power) {
        float newPower = Float.valueOf(power).floatValue();
        super.getPlugin().getPowerManager().setMaxPower(player.getUniqueId(), newPower);
        source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.PLAYERS_MAXPOWER_HAS_BEEN_CHANGED}));
    }
}

