/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class PromoteCommand
extends AbstractCommand {
    public PromoteCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        FactionPlayer promotedPlayer = (FactionPlayer)context.requireOne("player");
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        Optional<Faction> optionalPromotedPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(promotedPlayer.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (!optionalPromotedPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.THIS_PLAYER_IS_NOT_IN_YOUR_FACTION}));
        }
        if (!optionalPromotedPlayerFaction.get().getName().equals(playerFaction.getName())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.THIS_PLAYER_IS_NOT_IN_YOUR_FACTION}));
        }
        if (EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
            if (!playerFaction.getLeader().equals(promotedPlayer.getUniqueId()) && !playerFaction.getOfficers().contains(promotedPlayer.getUniqueId())) {
                FactionMemberType promotedTo = this.getPlugin().getFactionLogic().promotePlayer(playerFaction, promotedPlayer.getUniqueId());
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.YOU_PROMOTED + " ", TextColors.GOLD, promotedPlayer.getName(), TextColors.RESET, " " + PluginMessages.TO, " ", promotedTo.toString() + "!"}));
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_CANT_PROMOTE_THIS_PLAYER_MORE}));
            }
            return CommandResult.success();
        }
        if (playerFaction.getLeader().equals(player.getUniqueId())) {
            if (!playerFaction.getLeader().equals(promotedPlayer.getUniqueId()) && !playerFaction.getOfficers().contains(promotedPlayer.getUniqueId())) {
                FactionMemberType promotedTo = this.getPlugin().getFactionLogic().promotePlayer(playerFaction, promotedPlayer.getUniqueId());
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.YOU_PROMOTED + " ", TextColors.GOLD, promotedPlayer.getName(), TextColors.RESET, " " + PluginMessages.TO, " ", promotedTo.toString() + "!"}));
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_CANT_PROMOTE_THIS_PLAYER_MORE}));
            }
        } else if (playerFaction.getOfficers().contains(player.getUniqueId())) {
            if (!(playerFaction.getLeader().equals(promotedPlayer.getUniqueId()) || playerFaction.getOfficers().contains(promotedPlayer.getUniqueId()) || playerFaction.getMembers().contains(promotedPlayer.getUniqueId()))) {
                FactionMemberType promotedTo = this.getPlugin().getFactionLogic().promotePlayer(playerFaction, promotedPlayer.getUniqueId());
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.YOU_PROMOTED + " ", TextColors.GOLD, promotedPlayer.getName(), TextColors.RESET, " " + PluginMessages.TO, " ", promotedTo.toString() + "!"}));
            } else {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_CANT_PROMOTE_THIS_PLAYER_MORE}));
            }
        }
        return CommandResult.success();
    }
}

