/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class PublicCommand
extends AbstractCommand {
    public PublicCommand(EagleFactions plugin) {
        super(plugin);
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        String publicMessage;
        Optional providedFactionName = context.getOne((Text)Text.of((String)"faction name"));
        if (!(source instanceof Player)) {
            if (!providedFactionName.isPresent()) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "You must specify the name of the faction!"}));
            }
            Optional<Faction> optionalFaction = Optional.ofNullable(super.getPlugin().getFactionLogic().getFactionByName((String)providedFactionName.get()));
            if (!optionalFaction.isPresent()) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, "Provided faction does not exist!"}));
            }
            super.getPlugin().getFactionLogic().setIsPublic(optionalFaction.get(), !optionalFaction.get().isPublic());
            String publicMessage2 = !optionalFaction.get().isPublic() ? "Faction is now public." : "Faction is no longer public.";
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, publicMessage2}));
            return CommandResult.success();
        }
        Player player = (Player)source;
        Optional<Faction> optionalFaction = providedFactionName.isPresent() ? Optional.ofNullable(super.getPlugin().getFactionLogic().getFactionByName((String)providedFactionName.get())) : super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction faction = optionalFaction.get();
        String string = publicMessage = !faction.isPublic() ? "Faction is now public." : "Faction is no longer public.";
        if (EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, publicMessage}));
            super.getPlugin().getFactionLogic().setIsPublic(faction, !faction.isPublic());
            return CommandResult.success();
        }
        if (!faction.getLeader().equals(player.getUniqueId()) && !faction.getOfficers().contains(player.getUniqueId())) {
            throw new CommandException(Text.of((Object[])new Object[]{Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_THE_FACTIONS_LEADER_OR_OFFICER_TO_DO_THIS})}));
        }
        super.getPlugin().getFactionLogic().setIsPublic(faction, !faction.isPublic());
        source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, publicMessage}));
        return CommandResult.success();
    }
}

