/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.ArrayList;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class SquareClaimCommand
extends AbstractCommand {
    private final FactionsConfig factionsConfig;
    private final ProtectionConfig protectionConfig;

    public SquareClaimCommand(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalNumber = context.getOne((Text)Text.of((String)"radius"));
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        if (!optionalNumber.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.WRONG_COMMAND_ARGUMENTS}), true);
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        if (!this.protectionConfig.getClaimableWorldNames().contains(player.getWorld().getName()) && this.protectionConfig.getNotClaimableWorldNames().contains(player.getWorld().getName()) && !EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
            throw new CommandException(PluginInfo.ERROR_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.RED, "You can not claim territories in this world!"})));
        }
        int number = (Integer)optionalNumber.get();
        Faction playerFaction = optionalPlayerFaction.get();
        World world = player.getWorld();
        Vector3i playerChunk = player.getLocation().getChunkPosition();
        int startX = playerChunk.getX() - number;
        int startZ = playerChunk.getZ() - number;
        int endX = playerChunk.getX() + number;
        int endZ = playerChunk.getZ() + number;
        ArrayList<Vector3i> chunksToClaim = new ArrayList<Vector3i>();
        ArrayList<Claim> newFactionClaims = new ArrayList<Claim>();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                Vector3i chunk = new Vector3i(x, 0, z);
                chunksToClaim.add(chunk);
            }
        }
        for (Vector3i chunk : chunksToClaim) {
            boolean isCancelled;
            Optional<Faction> optionalChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), chunk);
            if (optionalChunkFaction.isPresent()) continue;
            if (EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(player.getUniqueId())) {
                isCancelled = EventRunner.runFactionClaimEvent(player, playerFaction, world, chunk);
                if (isCancelled) continue;
                newFactionClaims.add(new Claim(world.getUniqueId(), chunk));
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.LAND + " ", TextColors.GOLD, chunk.toString(), TextColors.WHITE, " " + PluginMessages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, PluginMessages.CLAIMED, TextColors.WHITE, "!"}));
                continue;
            }
            if (!this.getPlugin().getFlagManager().canClaim(player.getUniqueId(), playerFaction)) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PLAYERS_WITH_YOUR_RANK_CANT_CLAIM_LANDS}));
            }
            if (super.getPlugin().getPowerManager().getFactionMaxClaims(playerFaction) <= playerFaction.getClaims().size() + newFactionClaims.size()) {
                source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOUR_FACTION_DOES_NOT_HAVE_POWER_TO_CLAIM_MORE_LANDS}));
                break;
            }
            if (EagleFactionsPlugin.ATTACKED_FACTIONS.containsKey(playerFaction.getName())) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOUR_FACTION_IS_UNDER_ATTACK + " " + PluginMessages.YOU_NEED_TO_WAIT + " ", TextColors.GOLD, PluginMessages.TWO_MINUTES, TextColors.RED, " " + PluginMessages.TO_BE_ABLE_TO_CLAIM_AGAIN}));
            }
            if (playerFaction.getName().equalsIgnoreCase("SafeZone") || playerFaction.getName().equalsIgnoreCase("WarZone")) {
                isCancelled = EventRunner.runFactionClaimEvent(player, playerFaction, world, chunk);
                if (isCancelled) continue;
                newFactionClaims.add(new Claim(world.getUniqueId(), chunk));
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.LAND + " ", TextColors.GOLD, chunk.toString(), TextColors.WHITE, " " + PluginMessages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, PluginMessages.CLAIMED, TextColors.WHITE, "!"}));
                continue;
            }
            if (this.factionsConfig.requireConnectedClaims() && !super.getPlugin().getFactionLogic().isClaimConnected(playerFaction, new Claim(world.getUniqueId(), chunk)) || (isCancelled = EventRunner.runFactionClaimEvent(player, playerFaction, world, chunk))) continue;
            if (this.factionsConfig.shouldDelayClaim()) {
                throw new CommandException((Text)Text.of((String)"Can't rectangleclaim if delayed claiming is turned on."));
            }
            newFactionClaims.add(new Claim(world.getUniqueId(), chunk));
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.LAND + " ", TextColors.GOLD, chunk.toString(), TextColors.WHITE, " " + PluginMessages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, PluginMessages.CLAIMED, TextColors.WHITE, "!"}));
        }
        super.getPlugin().getFactionLogic().addClaims(playerFaction, newFactionClaims);
        return CommandResult.success();
    }
}

