/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class TagCommand
extends AbstractCommand {
    private final FactionsConfig factionsConfig;

    public TagCommand(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalNewTag = context.getOne("tag");
        if (!optionalNewTag.isPresent()) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.WRONG_COMMAND_ARGUMENTS}));
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, PluginMessages.USAGE + " /f tag <new_tag>"}));
            return CommandResult.success();
        }
        if (!(source instanceof Player)) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
            return CommandResult.success();
        }
        Player player = (Player)source;
        String newFactionTag = (String)optionalNewTag.get();
        Optional<Faction> optionalPlayerFaction = this.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
            return CommandResult.success();
        }
        if (!optionalPlayerFaction.get().getLeader().equals(player.getUniqueId())) {
            source.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MUST_BE_THE_FACTIONS_LEADER_TO_DO_THIS}));
            return CommandResult.success();
        }
        if (super.getPlugin().getFactionLogic().getFactionsTags().stream().anyMatch(x -> x.equalsIgnoreCase(newFactionTag))) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PROVIDED_FACTION_TAG_IS_ALREADY_TAKEN}));
            return CommandResult.success();
        }
        if (newFactionTag.length() > this.factionsConfig.getMaxTagLength()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PROVIDED_FACTION_TAG_IS_TOO_LONG + " (" + PluginMessages.MAX + " " + this.factionsConfig.getMaxTagLength() + " " + PluginMessages.CHARS + ")"}));
            return CommandResult.success();
        }
        if (newFactionTag.length() < this.factionsConfig.getMinTagLength()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.PROVIDED_FACTION_TAG_IS_TOO_SHORT + " (" + PluginMessages.MIN + " " + this.factionsConfig.getMinTagLength() + " " + PluginMessages.CHARS + ")"}));
            return CommandResult.success();
        }
        super.getPlugin().getFactionLogic().changeTag(optionalPlayerFaction.get(), newFactionTag);
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, "Successfully changed faction's tag to " + newFactionTag + "!"}));
        return CommandResult.success();
    }
}

