/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands.args;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class FactionPlayerArgument
extends CommandElement {
    private final EagleFactions plugin;

    public FactionPlayerArgument(EagleFactions plugin, @Nullable Text key) {
        super(key);
        this.plugin = plugin;
    }

    @Nullable
    protected FactionPlayer parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        Set<FactionPlayer> serverPlayers = this.plugin.getPlayerManager().getServerPlayers();
        if (args.hasNext()) {
            String argument = args.next();
            for (FactionPlayer player : serverPlayers) {
                if (!player.getName().equals(argument)) continue;
                return player;
            }
            throw new ArgumentParseException((Text)Text.of((String)"Argument is not a valid player"), argument, argument.length());
        }
        return null;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        ArrayList<String> list = new ArrayList<String>(this.plugin.getPlayerManager().getServerPlayerNames());
        if (args.hasNext()) {
            String charSequence = (String)args.nextIfPresent().get();
            return list.stream().filter(x -> x.contains(charSequence)).collect(Collectors.toList());
        }
        return list;
    }
}

