/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.dynmap.util;

import io.github.aquerr.eaglefactions.api.config.DynmapConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.dynmap.util.TempAreaMarker;
import io.github.aquerr.eaglefactions.common.dynmap.util.TileFlags;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;

public class DynmapUtils {
    private static DynmapConfig dynmapConfig = EagleFactionsPlugin.getPlugin().getConfiguration().getDynmapConfig();

    public static String getFactionInfoWindow(Faction faction) {
        Optional userStorage = Sponge.getServiceManager().provide(UserStorageService.class);
        StringBuilder description = new StringBuilder();
        String factionName = faction.getName();
        String factionDesc = faction.getDescription();
        description.append("<div class=\"infowindow\">\n").append("<span style=\"font-weight: bold; font-size: 150%;\">%name%</span></br>\n".replace("%name%", factionName)).append("<span style=\"font-style: italic; font-size: 110%;\">%description%</span></br>\n".replace("%description%", factionDesc.length() > 0 ? factionDesc : "No description"));
        if (faction.getTag().toPlain().length() > 0) {
            description.append("<span style=\"font-weight: bold;\">Tag:</span> %tag%</br>\n".replace("%tag%", faction.getTag().toPlain())).append("</br>\n");
        }
        if (dynmapConfig.showDynmapFactionLeader() && userStorage.isPresent() && ((UserStorageService)userStorage.get()).get(faction.getLeader()).isPresent()) {
            description.append("<span style=\"font-weight: bold;\">Leader:</span> %leader%</br>\n".replace("%leader%", ((User)((UserStorageService)userStorage.get()).get(faction.getLeader()).get()).getName()));
        }
        if (dynmapConfig.showDynmapMemberInfo()) {
            int memberCount = faction.getPlayers().size();
            description.append("<span style=\"font-weight: bold;\">Total members:</span> %players%</br>\n".replace("%players%", String.valueOf(memberCount)));
        }
        description.append("</br>\n</div>");
        return description.toString();
    }

    public static int getAreaColor(Faction faction) {
        DynmapConfig dynmapConfig = EagleFactionsPlugin.getPlugin().getConfiguration().getDynmapConfig();
        int areaColor = dynmapConfig.getDynmapFactionColor();
        if (faction.getName().equals("SafeZone")) {
            areaColor = dynmapConfig.getDynmapSafezoneColor();
        } else if (faction.getName().equals("WarZone")) {
            areaColor = dynmapConfig.getDynmapWarzoneColor();
        }
        return areaColor;
    }

    private static void floodFillTarget(TileFlags source, TileFlags destination, int x, int y) {
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(new int[]{x, y});
        while (!stack.isEmpty()) {
            int[] nxt = (int[])stack.pop();
            x = nxt[0];
            if (!source.getFlag(x, y = nxt[1])) continue;
            source.setFlag(x, y, false);
            destination.setFlag(x, y, true);
            if (source.getFlag(x + 1, y)) {
                stack.push(new int[]{x + 1, y});
            }
            if (source.getFlag(x - 1, y)) {
                stack.push(new int[]{x - 1, y});
            }
            if (source.getFlag(x, y + 1)) {
                stack.push(new int[]{x, y + 1});
            }
            if (!source.getFlag(x, y - 1)) continue;
            stack.push(new int[]{x, y - 1});
        }
    }

    public static ArrayList<TempAreaMarker> createAreas(Set<Claim> chunks) {
        ArrayList<TempAreaMarker> ret = new ArrayList<TempAreaMarker>();
        TileFlags allChunkFlags = new TileFlags();
        LinkedList<Claim> allChunks = new LinkedList<Claim>();
        for (Claim chunk : chunks) {
            allChunkFlags.setFlag(chunk.getChunkPosition().getX(), chunk.getChunkPosition().getZ(), true);
            allChunks.addLast(chunk);
        }
        while (allChunks != null) {
            TileFlags ourChunkFlags = null;
            LinkedList<Claim> ourChunks = null;
            LinkedList<Claim> newChunks = null;
            int minimumX = Integer.MAX_VALUE;
            int minimumZ = Integer.MAX_VALUE;
            for (Claim chunk : allChunks) {
                int chunkX = chunk.getChunkPosition().getX();
                int chunkZ = chunk.getChunkPosition().getZ();
                if (ourChunkFlags == null && allChunkFlags.getFlag(chunkX, chunkZ)) {
                    ourChunkFlags = new TileFlags();
                    ourChunks = new LinkedList<Claim>();
                    DynmapUtils.floodFillTarget(allChunkFlags, ourChunkFlags, chunkX, chunkZ);
                    ourChunks.add(chunk);
                    minimumX = chunkX;
                    minimumZ = chunkZ;
                    continue;
                }
                if (ourChunkFlags != null && ourChunkFlags.getFlag(chunkX, chunkZ)) {
                    ourChunks.add(chunk);
                    if (chunkX < minimumX) {
                        minimumX = chunkX;
                        minimumZ = chunkZ;
                        continue;
                    }
                    if (chunkX != minimumX || chunkZ >= minimumZ) continue;
                    minimumZ = chunkZ;
                    continue;
                }
                if (newChunks == null) {
                    newChunks = new LinkedList<Claim>();
                }
                newChunks.add(chunk);
            }
            allChunks = newChunks;
            if (ourChunkFlags == null) continue;
            int initialX = minimumX;
            int initialZ = minimumZ;
            int currentX = minimumX;
            int currentZ = minimumZ;
            Direction direction = Direction.XPLUS;
            ArrayList<int[]> linelist = new ArrayList<int[]>();
            linelist.add(new int[]{initialX, initialZ});
            while (currentX != initialX || currentZ != initialZ || direction != Direction.ZMINUS) {
                switch (direction) {
                    case XPLUS: {
                        if (!ourChunkFlags.getFlag(currentX + 1, currentZ)) {
                            linelist.add(new int[]{currentX + 1, currentZ});
                            direction = Direction.ZPLUS;
                            break;
                        }
                        if (!ourChunkFlags.getFlag(currentX + 1, currentZ - 1)) {
                            ++currentX;
                            break;
                        }
                        linelist.add(new int[]{currentX + 1, currentZ--});
                        direction = Direction.ZMINUS;
                        ++currentX;
                        break;
                    }
                    case ZPLUS: {
                        if (!ourChunkFlags.getFlag(currentX, currentZ + 1)) {
                            linelist.add(new int[]{currentX + 1, currentZ + 1});
                            direction = Direction.XMINUS;
                            break;
                        }
                        if (!ourChunkFlags.getFlag(currentX + 1, currentZ + 1)) {
                            ++currentZ;
                            break;
                        }
                        linelist.add(new int[]{currentX + 1, currentZ + 1});
                        direction = Direction.XPLUS;
                        ++currentX;
                        ++currentZ;
                        break;
                    }
                    case XMINUS: {
                        if (!ourChunkFlags.getFlag(currentX - 1, currentZ)) {
                            linelist.add(new int[]{currentX, currentZ + 1});
                            direction = Direction.ZMINUS;
                            break;
                        }
                        if (!ourChunkFlags.getFlag(currentX - 1, currentZ + 1)) {
                            --currentX;
                            break;
                        }
                        linelist.add(new int[]{currentX--, currentZ + 1});
                        direction = Direction.ZPLUS;
                        ++currentZ;
                        break;
                    }
                    case ZMINUS: {
                        if (!ourChunkFlags.getFlag(currentX, currentZ - 1)) {
                            linelist.add(new int[]{currentX, currentZ});
                            direction = Direction.XPLUS;
                            break;
                        }
                        if (!ourChunkFlags.getFlag(currentX - 1, currentZ - 1)) {
                            --currentZ;
                            break;
                        }
                        linelist.add(new int[]{currentX--, currentZ--});
                        direction = Direction.XMINUS;
                    }
                }
            }
            int sz = linelist.size();
            double[] x = new double[sz];
            double[] z = new double[sz];
            for (int i = 0; i < sz; ++i) {
                int[] line = (int[])linelist.get(i);
                x[i] = (double)line[0] * 16.0;
                z[i] = (double)line[1] * 16.0;
            }
            TempAreaMarker temp = new TempAreaMarker(x, z);
            ret.add(temp);
        }
        return ret;
    }

    static enum Direction {
        XPLUS,
        ZPLUS,
        XMINUS,
        ZMINUS;

    }
}

