/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.ChatConfig;
import io.github.aquerr.eaglefactions.api.entities.ChatEnum;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;

public class ChatMessageListener
extends AbstractListener {
    private final ChatConfig chatConfig;

    public ChatMessageListener(EagleFactions plugin) {
        super(plugin);
        this.chatConfig = plugin.getConfiguration().getChatConfig();
    }

    @Listener
    public void onChatMessage(MessageChannelEvent.Chat event, @Root Player player) {
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (!optionalPlayerFaction.isPresent()) {
            if (this.chatConfig.shouldSuppressOtherFactionsMessagesWhileInTeamChat()) {
                MessageChannel messageChannel = event.getOriginalChannel();
                Collection chatMembers = messageChannel.getMembers();
                HashSet newReceivers = new HashSet(chatMembers);
                for (MessageReceiver messageReceiver : chatMembers) {
                    Player receiver;
                    if (!(messageReceiver instanceof Player) || !EagleFactionsPlugin.CHAT_LIST.containsKey((receiver = (Player)messageReceiver).getUniqueId()) || EagleFactionsPlugin.CHAT_LIST.get(receiver.getUniqueId()) == ChatEnum.GLOBAL) continue;
                    newReceivers.remove(receiver);
                }
                messageChannel = MessageChannel.fixed(newReceivers);
                event.setChannel(messageChannel);
            }
            if (!this.chatConfig.getNonFactionPlayerPrefix().toPlain().equals("")) {
                Text.Builder formattedMessage = Text.builder();
                formattedMessage.append(new Text[]{this.chatConfig.getFactionStartPrefix()}).append(new Text[]{this.chatConfig.getNonFactionPlayerPrefix()}).append(new Text[]{this.chatConfig.getFactionEndPrefix()}).append(new Text[]{event.getMessage()});
                event.setMessage((TextRepresentable)formattedMessage);
            }
            return;
        }
        MessageChannel messageChannel = event.getOriginalChannel();
        Faction playerFaction = optionalPlayerFaction.get();
        Text.Builder formattedMessage = Text.builder();
        Text.Builder factionAndRankPrefix = Text.builder();
        Text.Builder otherPrefixesAndPlayer = Text.builder();
        Text.Builder factionPrefixText = Text.builder();
        Text.Builder rankPrefixText = Text.builder();
        Text.Builder message = Text.builder();
        otherPrefixesAndPlayer.append(new Text[]{(Text)event.getMessage().getChildren().get(0)});
        if (EagleFactionsPlugin.CHAT_LIST.containsKey(player.getUniqueId())) {
            HashSet<Object> receivers = new HashSet<Object>();
            Text.Builder chatTypePrefix = Text.builder();
            if (EagleFactionsPlugin.CHAT_LIST.get(player.getUniqueId()).equals((Object)ChatEnum.ALLIANCE)) {
                message.append(new Text[]{Text.of((Object[])new Object[]{TextColors.BLUE, event.getRawMessage()})});
                chatTypePrefix.append(new Text[]{this.getAlliancePrefix()});
                messageChannel.asMutable().clearMembers();
                for (String allianceName : playerFaction.getAlliances()) {
                    Faction allyFaction = super.getPlugin().getFactionLogic().getFactionByName(allianceName);
                    if (allyFaction == null) continue;
                    receivers.addAll(this.getPlugin().getFactionLogic().getOnlinePlayers(allyFaction));
                }
                receivers.addAll(this.getPlugin().getFactionLogic().getOnlinePlayers(playerFaction));
            } else if (EagleFactionsPlugin.CHAT_LIST.get(player.getUniqueId()).equals((Object)ChatEnum.FACTION)) {
                message.append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, event.getRawMessage()})});
                chatTypePrefix.append(new Text[]{this.getFactionPrefix()});
                messageChannel.asMutable().clearMembers();
                receivers = new HashSet<Player>(this.getPlugin().getFactionLogic().getOnlinePlayers(playerFaction));
            }
            for (UUID adminUUID : EagleFactionsPlugin.ADMIN_MODE_PLAYERS) {
                Optional optionalAdminPlayer = Sponge.getServer().getPlayer(adminUUID);
                if (!optionalAdminPlayer.isPresent()) continue;
                receivers.add(optionalAdminPlayer.get());
            }
            receivers.add(Sponge.getServer().getConsole());
            messageChannel = MessageChannel.fixed(receivers);
            formattedMessage.append(new Text[]{chatTypePrefix.build()});
        } else {
            message.append(new Text[]{(Text)event.getMessage().getChildren().get(1)});
            if (this.chatConfig.shouldSuppressOtherFactionsMessagesWhileInTeamChat()) {
                Collection chatMembers = messageChannel.getMembers();
                HashSet newReceivers = new HashSet(chatMembers);
                for (MessageReceiver messageReceiver : chatMembers) {
                    Optional<Faction> receiverFaction;
                    Player receiver;
                    if (!(messageReceiver instanceof Player) || !EagleFactionsPlugin.CHAT_LIST.containsKey((receiver = (Player)messageReceiver).getUniqueId()) || EagleFactionsPlugin.CHAT_LIST.get(receiver.getUniqueId()) == ChatEnum.GLOBAL || !(receiverFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(receiver.getUniqueId())).isPresent() || playerFaction.getAlliances().contains(receiverFaction.get().getName()) || receiverFaction.get().getName().equals(playerFaction.getName())) continue;
                    newReceivers.remove(receiver);
                }
                messageChannel = MessageChannel.fixed(newReceivers);
            }
        }
        if (this.chatConfig.getChatPrefixType().equals("tag")) {
            if (!playerFaction.getTag().toPlainSingle().equals("")) {
                Text factionTag;
                if (this.chatConfig.canColorTags()) {
                    factionTag = Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), playerFaction.getTag(), this.chatConfig.getFactionEndPrefix()}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.BLUE, TextStyles.ITALIC, "Click to view more information about the faction!"}))).onClick((ClickAction)TextActions.runCommand((String)("/f info " + playerFaction.getName()))).build();
                    factionPrefixText.append(new Text[]{factionTag});
                } else {
                    factionTag = Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), Text.of((Object[])new Object[]{TextColors.GREEN, playerFaction.getTag()}), this.chatConfig.getFactionEndPrefix()}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.BLUE, TextStyles.ITALIC, "Click to view more information about the faction!"}))).onClick((ClickAction)TextActions.runCommand((String)("/f info " + playerFaction.getName()))).build();
                    factionPrefixText.append(new Text[]{factionTag});
                }
            }
        } else if (this.chatConfig.getChatPrefixType().equals("name")) {
            Text factionNamePrefix = Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), Text.of((Object[])new Object[]{TextColors.GREEN, playerFaction.getName(), TextColors.RESET}), this.chatConfig.getFactionEndPrefix()}).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.BLUE, TextStyles.ITALIC, "Click to view more information about the faction!"}))).onClick((ClickAction)TextActions.runCommand((String)("/f info " + playerFaction.getName()))).build();
            factionPrefixText.append(new Text[]{factionNamePrefix});
        }
        if (this.chatConfig.shouldDisplayRank()) {
            if (playerFaction.getLeader().equals(player.getUniqueId())) {
                Text leaderPrefix = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{this.chatConfig.getFactionStartPrefix(), TextColors.GOLD, PluginMessages.LEADER, TextColors.RESET, this.chatConfig.getFactionEndPrefix()})}).build();
                rankPrefixText.append(new Text[]{leaderPrefix});
            } else if (playerFaction.getOfficers().contains(player.getUniqueId())) {
                Text officerPrefix = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{this.chatConfig.getFactionStartPrefix(), TextColors.GOLD, PluginMessages.OFFICER, TextColors.RESET, this.chatConfig.getFactionEndPrefix()})}).build();
                rankPrefixText.append(new Text[]{officerPrefix});
            } else if (playerFaction.getRecruits().contains(player.getUniqueId())) {
                Text recruitPrefix = Text.builder().append(new Text[]{Text.of((Object[])new Object[]{this.chatConfig.getFactionStartPrefix(), TextColors.GOLD, PluginMessages.RECRUIT, TextColors.RESET, this.chatConfig.getFactionEndPrefix()})}).build();
                rankPrefixText.append(new Text[]{recruitPrefix});
            }
        }
        if (this.chatConfig.isFactionPrefixFirstInChat()) {
            factionAndRankPrefix.append(new Text[]{factionPrefixText.build()});
            factionAndRankPrefix.append(new Text[]{rankPrefixText.build()});
        } else {
            factionAndRankPrefix.append(new Text[]{rankPrefixText.build()});
            factionAndRankPrefix.append(new Text[]{factionPrefixText.build()});
        }
        formattedMessage.append(new Text[]{factionAndRankPrefix.build()});
        formattedMessage.append(new Text[]{otherPrefixesAndPlayer.build()});
        formattedMessage.append(new Text[]{message.build()});
        Text messageToPrint = Text.builder().append(new Text[]{formattedMessage.build()}).build();
        event.setChannel(messageChannel);
        event.setMessage((TextRepresentable)messageToPrint);
    }

    private Text getAlliancePrefix() {
        return Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), Text.of((Object[])new Object[]{TextColors.BLUE, PluginMessages.ALLIANCE_CHAT, TextColors.RESET}), this.chatConfig.getFactionEndPrefix()}).build();
    }

    private Text getFactionPrefix() {
        return Text.builder().append(new Text[]{this.chatConfig.getFactionStartPrefix(), Text.of((Object[])new Object[]{TextColors.GREEN, PluginMessages.FACTION_CHAT, TextColors.RESET}), this.chatConfig.getFactionEndPrefix()}).build();
    }
}

