/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import com.flowpowered.math.vector.Vector3d;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.PowerConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.PVPLogger;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Optional;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.IndirectEntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.IgniteEntityEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class EntityDamageListener
extends AbstractListener {
    private final PVPLogger pvpLogger;
    private final ProtectionConfig protectionConfig;
    private final FactionsConfig factionsConfig;
    private final PowerConfig powerConfig;

    public EntityDamageListener(EagleFactions plugin) {
        super(plugin);
        this.pvpLogger = plugin.getPVPLogger();
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        this.powerConfig = plugin.getConfiguration().getPowerConfig();
    }

    @Listener(order=Order.EARLY, beforeModifications=true)
    public void onEntityDamage(DamageEntityEvent event) {
        if (!(event.getCause().root() instanceof DamageSource)) {
            return;
        }
        if (event.getTargetEntity().getType() != EntityTypes.PLAYER) {
            return;
        }
        Player attackedPlayer = (Player)event.getTargetEntity();
        World world = attackedPlayer.getWorld();
        boolean willCauseDeath = event.willCauseDeath();
        if (this.protectionConfig.getSafeZoneWorldNames().contains(world.getName())) {
            event.setBaseDamage(0.0);
            event.setCancelled(true);
            return;
        }
        Optional<Faction> optionalChunkFaction = this.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), attackedPlayer.getLocation().getChunkPosition());
        if (optionalChunkFaction.isPresent() && optionalChunkFaction.get().getName().equals("SafeZone")) {
            event.setBaseDamage(0.0);
            event.setCancelled(true);
            return;
        }
        Object rootCause = event.getCause().root();
        if (rootCause instanceof IndirectEntityDamageSource) {
            boolean shouldBlockDamage;
            IndirectEntityDamageSource indirectEntityDamageSource = (IndirectEntityDamageSource)rootCause;
            Entity indirectSource = indirectEntityDamageSource.getIndirectSource();
            if (indirectSource instanceof Player && (shouldBlockDamage = this.shouldBlockDamageFromPlayer(attackedPlayer, (Player)indirectSource, willCauseDeath))) {
                event.setBaseDamage(0.0);
                event.setCancelled(true);
                if (!(indirectEntityDamageSource.getSource() instanceof Player)) {
                    indirectEntityDamageSource.getSource().remove();
                }
                world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.SMOKE).quantity(50).offset(new Vector3d(0.5, 1.5, 0.5)).build(), attackedPlayer.getPosition());
                return;
            }
        } else if (rootCause instanceof EntityDamageSource) {
            Player player;
            boolean shouldBlockDamage;
            EntityDamageSource entityDamageSource = (EntityDamageSource)rootCause;
            Entity entitySource = entityDamageSource.getSource();
            if (entityDamageSource.getClass().getName().contains("techguns")) {
                try {
                    Object attacker = entityDamageSource.getClass().getField("attacker").get(entityDamageSource);
                    if (attacker instanceof Player) {
                        entitySource = (Player)attacker;
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            if (entitySource instanceof Player && (shouldBlockDamage = this.shouldBlockDamageFromPlayer(attackedPlayer, player = (Player)entitySource, willCauseDeath))) {
                event.setBaseDamage(0.0);
                event.setCancelled(true);
                world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.SMOKE).quantity(50).offset(new Vector3d(0.5, 1.5, 0.5)).build(), attackedPlayer.getPosition());
                return;
            }
        }
    }

    private boolean shouldBlockDamageFromPlayer(Player attackedPlayer, Player sourcePlayer, boolean willCauseDeath) {
        World world = attackedPlayer.getWorld();
        Optional<Faction> playerChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), sourcePlayer.getLocation().getChunkPosition());
        if (playerChunkFaction.isPresent() && playerChunkFaction.get().getName().equals("SafeZone")) {
            return true;
        }
        if (attackedPlayer.equals(sourcePlayer)) {
            return false;
        }
        Optional<Faction> optionalSourcePlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(sourcePlayer.getUniqueId());
        if (!optionalSourcePlayerFaction.isPresent()) {
            if (willCauseDeath) {
                this.sendKillAwardMessageAndIncreasePower(sourcePlayer);
                return false;
            }
            if (this.pvpLogger.isActive()) {
                this.pvpLogger.addOrUpdatePlayer(attackedPlayer);
            }
            return false;
        }
        Faction sourcePlayerFaction = optionalSourcePlayerFaction.get();
        Optional<Faction> optionalAttackedPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(attackedPlayer.getUniqueId());
        if (!optionalAttackedPlayerFaction.isPresent()) {
            if (willCauseDeath) {
                this.sendKillAwardMessageAndIncreasePower(sourcePlayer);
                return false;
            }
            if (this.pvpLogger.isActive()) {
                this.pvpLogger.addOrUpdatePlayer(attackedPlayer);
            }
            return false;
        }
        Faction attackedPlayerFaction = optionalAttackedPlayerFaction.get();
        if (sourcePlayerFaction.getName().equals(attackedPlayerFaction.getName())) {
            if (!this.factionsConfig.isFactionFriendlyFire()) {
                return true;
            }
            if (willCauseDeath) {
                this.sendPenaltyMessageAndDecreasePower(sourcePlayer);
                return false;
            }
        } else {
            if (sourcePlayerFaction.getAlliances().contains(attackedPlayerFaction.getName())) {
                if (!this.factionsConfig.isAllianceFriendlyFire()) {
                    return true;
                }
                if (willCauseDeath) {
                    this.sendPenaltyMessageAndDecreasePower(sourcePlayer);
                    return false;
                }
                if (this.pvpLogger.isActive()) {
                    this.pvpLogger.addOrUpdatePlayer(attackedPlayer);
                }
                return false;
            }
            if (willCauseDeath) {
                this.sendKillAwardMessageAndIncreasePower(sourcePlayer);
                return false;
            }
            if (this.pvpLogger.isActive()) {
                this.pvpLogger.addOrUpdatePlayer(attackedPlayer);
            }
            return false;
        }
        return false;
    }

    @Listener
    public void onIgniteEntity(IgniteEntityEvent event) {
        EventContext eventContext = event.getContext();
        Entity entity = event.getTargetEntity();
        World world = event.getTargetEntity().getWorld();
        if (!(entity instanceof Player)) {
            return;
        }
        if (this.protectionConfig.getSafeZoneWorldNames().contains(world.getName())) {
            event.setCancelled(true);
            return;
        }
        Player ignitedPlayer = (Player)entity;
        Optional<Faction> optionalChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), ignitedPlayer.getLocation().getChunkPosition());
        if (optionalChunkFaction.isPresent() && optionalChunkFaction.get().getName().equalsIgnoreCase("SafeZone")) {
            event.setCancelled(true);
            return;
        }
        if (!eventContext.containsKey(EventContextKeys.OWNER) || !(eventContext.get(EventContextKeys.OWNER).get() instanceof Player)) {
            return;
        }
        Player igniterPlayer = (Player)eventContext.get(EventContextKeys.OWNER).get();
        boolean isFactionFriendlyFireOn = this.factionsConfig.isFactionFriendlyFire();
        boolean isAllianceFriendlyFireOn = this.factionsConfig.isAllianceFriendlyFire();
        if (isFactionFriendlyFireOn && isAllianceFriendlyFireOn) {
            return;
        }
        Optional<Faction> optionalIgnitedPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(ignitedPlayer.getUniqueId());
        Optional<Faction> optionalIgniterPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(igniterPlayer.getUniqueId());
        if (optionalIgnitedPlayerFaction.isPresent() && optionalIgniterPlayerFaction.isPresent()) {
            Faction ignitedPlayerFaction = optionalIgnitedPlayerFaction.get();
            Faction igniterPlayerFaction = optionalIgniterPlayerFaction.get();
            if (!isFactionFriendlyFireOn && ignitedPlayerFaction.getName().equals(igniterPlayerFaction.getName())) {
                event.setCancelled(true);
                return;
            }
            if (!isAllianceFriendlyFireOn && ignitedPlayerFaction.getAlliances().contains(igniterPlayerFaction.getName())) {
                event.setCancelled(true);
                return;
            }
        }
    }

    private void sendPenaltyMessageAndDecreasePower(Player player) {
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.YOUR_POWER_HAS_BEEN_DECREASED_BY + " ", TextColors.GOLD, this.powerConfig.getPenalty() + "\n", TextColors.GRAY, PluginMessages.CURRENT_POWER + " ", super.getPlugin().getPowerManager().getPlayerPower(player.getUniqueId()) + "/" + this.getPlugin().getPowerManager().getPlayerMaxPower(player.getUniqueId())}));
        super.getPlugin().getPowerManager().penalty(player.getUniqueId());
    }

    private void sendKillAwardMessageAndIncreasePower(Player player) {
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.YOUR_POWER_HAS_BEEN_INCREASED_BY + " ", TextColors.GOLD, this.powerConfig.getKillAward() + "\n", TextColors.GRAY, PluginMessages.CURRENT_POWER + " ", super.getPlugin().getPowerManager().getPlayerPower(player.getUniqueId()) + "/" + this.getPlugin().getPowerManager().getPlayerMaxPower(player.getUniqueId())}));
        super.getPlugin().getPowerManager().addPower(player.getUniqueId(), true);
    }
}

