/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import io.github.aquerr.eaglefactions.common.version.VersionChecker;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class PlayerJoinListener
extends AbstractListener {
    private final ProtectionConfig protectionConfig;

    public PlayerJoinListener(EagleFactions plugin) {
        super(plugin);
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
    }

    @Listener(order=Order.POST)
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Root Player player) {
        Optional<Faction> optionalPlayerFaction;
        if (player.hasPermission("eaglefactions.admin.version.notify") && !VersionChecker.isLatest("0.13.1")) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.A_NEW_VERSION_OF + " ", TextColors.AQUA, "Eagle Factions", TextColors.GREEN, " " + PluginMessages.IS_AVAILABLE}));
        }
        if (!super.getPlugin().getPlayerManager().checkIfPlayerExists(player.getUniqueId(), player.getName())) {
            super.getPlugin().getPlayerManager().addPlayer(player.getUniqueId(), player.getName());
        }
        super.getPlugin().getPlayerManager().updatePlayerName(player.getUniqueId(), player.getName());
        super.getPlugin().getPowerManager().startIncreasingPower(player.getUniqueId());
        if (!this.protectionConfig.getDetectedWorldNames().contains(player.getWorld().getName())) {
            CompletableFuture.runAsync(() -> this.protectionConfig.addWorld(player.getWorld().getName()));
        }
        if ((optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId())).isPresent() && !optionalPlayerFaction.get().getMessageOfTheDay().equals("")) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GOLD, optionalPlayerFaction.get().getName() + "'s message of the day: ", TextColors.RESET, optionalPlayerFaction.get().getMessageOfTheDay()}));
        }
    }
}

