/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.logic;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.AttackLogic;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class AttackLogicImpl
implements AttackLogic {
    private static AttackLogic INSTANCE = null;
    private final FactionsConfig factionsConfig;
    private final FactionLogic factionLogic;

    private AttackLogicImpl(EagleFactions eagleFactions) {
        this.factionsConfig = eagleFactions.getConfiguration().getFactionsConfig();
        this.factionLogic = eagleFactions.getFactionLogic();
    }

    public static AttackLogic getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            INSTANCE = new AttackLogicImpl(eagleFactions);
        }
        return INSTANCE;
    }

    @Override
    public void attack(final Player player, final Vector3i attackedChunk) {
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.interval(1L, TimeUnit.SECONDS).execute((Consumer)new Consumer<Task>(){
            int seconds = 1;

            @Override
            public void accept(Task task) {
                if (attackedChunk.toString().equals(player.getLocation().getChunkPosition().toString())) {
                    if (this.seconds == AttackLogicImpl.this.factionsConfig.getAttackTime()) {
                        Faction chunkFaction = AttackLogicImpl.this.factionLogic.getFactionByChunk(player.getWorld().getUniqueId(), attackedChunk).get();
                        AttackLogicImpl.this.informAboutDestroying(chunkFaction);
                        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.CLAIM_DESTROYED}));
                        Claim claim = new Claim(player.getWorld().getUniqueId(), attackedChunk);
                        AttackLogicImpl.this.factionLogic.destroyClaim(chunkFaction, claim);
                        task.cancel();
                    } else {
                        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RESET, this.seconds}));
                        ++this.seconds;
                    }
                } else {
                    player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_MOVED_FROM_THE_CHUNK}));
                    task.cancel();
                }
            }
        }).submit((Object)EagleFactionsPlugin.getPlugin());
    }

    @Override
    public void blockClaiming(String factionName) {
        if (EagleFactionsPlugin.ATTACKED_FACTIONS.containsKey(factionName)) {
            EagleFactionsPlugin.ATTACKED_FACTIONS.replace(factionName, 120);
        } else {
            EagleFactionsPlugin.ATTACKED_FACTIONS.put(factionName, 120);
            this.runClaimingRestorer(factionName);
        }
    }

    @Override
    public void runClaimingRestorer(String factionName) {
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.interval(1L, TimeUnit.SECONDS).execute(task -> {
            if (EagleFactionsPlugin.ATTACKED_FACTIONS.containsKey(factionName)) {
                int seconds = EagleFactionsPlugin.ATTACKED_FACTIONS.get(factionName);
                if (seconds <= 0) {
                    EagleFactionsPlugin.ATTACKED_FACTIONS.remove(factionName);
                    task.cancel();
                } else {
                    EagleFactionsPlugin.ATTACKED_FACTIONS.replace(factionName, seconds, seconds - 1);
                }
            }
        }).submit((Object)EagleFactionsPlugin.getPlugin());
    }

    @Override
    public void informAboutAttack(Faction faction) {
        List<Player> playersList = this.factionLogic.getOnlinePlayers(faction);
        playersList.forEach(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.YOUR_FACTION_IS_UNDER + " ", TextColors.RED, PluginMessages.ATTACK, TextColors.RESET, "!"})));
    }

    @Override
    public void informAboutDestroying(Faction faction) {
        List<Player> playersList = this.factionLogic.getOnlinePlayers(faction);
        playersList.forEach(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.ONE_OF_YOUR_CLAIMS_HAS_BEEN + " ", TextColors.RED, PluginMessages.DESTROYED, TextColors.RESET, " " + PluginMessages.BY_AN_ENEMY})));
    }

    @Override
    public void blockHome(UUID playerUUID) {
        if (EagleFactionsPlugin.BLOCKED_HOME.containsKey(playerUUID)) {
            EagleFactionsPlugin.BLOCKED_HOME.replace(playerUUID, this.factionsConfig.getHomeBlockTimeAfterDeathInOwnFaction());
        } else {
            EagleFactionsPlugin.BLOCKED_HOME.put(playerUUID, this.factionsConfig.getHomeBlockTimeAfterDeathInOwnFaction());
            this.runHomeUsageRestorer(playerUUID);
        }
    }

    @Override
    public void runHomeUsageRestorer(UUID playerUUID) {
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.interval(1L, TimeUnit.SECONDS).execute(task -> {
            if (EagleFactionsPlugin.BLOCKED_HOME.containsKey(playerUUID)) {
                int seconds = EagleFactionsPlugin.BLOCKED_HOME.get(playerUUID);
                if (seconds <= 0) {
                    EagleFactionsPlugin.BLOCKED_HOME.remove(playerUUID);
                    task.cancel();
                } else {
                    EagleFactionsPlugin.BLOCKED_HOME.replace(playerUUID, seconds, seconds - 1);
                }
            }
        }).submit((Object)EagleFactionsPlugin.getPlugin());
    }
}

