/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.logic;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionFlagTypes;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.caching.FactionsCache;
import io.github.aquerr.eaglefactions.common.managers.PlayerManagerImpl;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import io.github.aquerr.eaglefactions.common.scheduling.ClaimDelayTask;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsScheduler;
import io.github.aquerr.eaglefactions.common.util.ParticlesUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

public class FactionLogicImpl
implements FactionLogic {
    private static FactionLogicImpl INSTANCE = null;
    private final StorageManager storageManager;
    private final FactionsConfig factionsConfig;
    private final PlayerManagerImpl _playerManager;
    private final EagleFactionsPlugin plugin;
    private final UUID DUMMY_UUID = new UUID(0L, 0L);

    public static FactionLogic getInstance(EagleFactionsPlugin eagleFactions) {
        if (INSTANCE == null) {
            return new FactionLogicImpl(eagleFactions);
        }
        return INSTANCE;
    }

    public FactionLogicImpl(EagleFactionsPlugin plugin) {
        INSTANCE = this;
        this.plugin = plugin;
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        this._playerManager = plugin.getPlayerManager();
        this.storageManager = plugin.getStorageManager();
    }

    @Override
    public Optional<Faction> getFactionByPlayerUUID(UUID playerUUID) {
        for (Faction faction : this.getFactions().values()) {
            if (faction.getLeader() != null && faction.getLeader().equals(playerUUID)) {
                return Optional.of(faction);
            }
            if (faction.getOfficers().contains(playerUUID)) {
                return Optional.of(faction);
            }
            if (faction.getMembers().contains(playerUUID)) {
                return Optional.of(faction);
            }
            if (!faction.getRecruits().contains(playerUUID)) continue;
            return Optional.of(faction);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Faction> getFactionByChunk(UUID worldUUID, Vector3i chunk) {
        Claim claim = new Claim(worldUUID, chunk);
        for (Faction faction : this.getFactions().values()) {
            if (!faction.getClaims().contains(claim)) continue;
            return Optional.of(faction);
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public Faction getFactionByName(String factionName) {
        Faction faction = this.storageManager.getFaction(factionName);
        if (faction != null) {
            return faction;
        }
        return null;
    }

    @Override
    public List<Player> getOnlinePlayers(Faction faction) {
        ArrayList<Player> factionPlayers = new ArrayList<Player>();
        UUID factionLeader = faction.getLeader();
        if (!faction.getLeader().equals(this.DUMMY_UUID) && this._playerManager.isPlayerOnline(factionLeader)) {
            factionPlayers.add(this._playerManager.getPlayer(factionLeader).get());
        }
        for (UUID uuid : faction.getOfficers()) {
            if (!this._playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this._playerManager.getPlayer(uuid).get());
        }
        for (UUID uuid : faction.getMembers()) {
            if (!this._playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this._playerManager.getPlayer(uuid).get());
        }
        for (UUID uuid : faction.getRecruits()) {
            if (!this._playerManager.isPlayerOnline(uuid)) continue;
            factionPlayers.add(this._playerManager.getPlayer(uuid).get());
        }
        return factionPlayers;
    }

    @Override
    public Set<String> getFactionsNames() {
        return this.getFactions().keySet();
    }

    @Override
    public Map<String, Faction> getFactions() {
        return FactionsCache.getFactionsMap();
    }

    @Override
    public void addFaction(Faction faction) {
        this.storageManager.addOrUpdateFaction(faction);
    }

    @Override
    public boolean disbandFaction(String factionName) {
        return this.storageManager.deleteFaction(factionName);
    }

    @Override
    public void joinFaction(UUID playerUUID, String factionName) {
        if (playerUUID == null || factionName.equals("")) {
            throw new IllegalArgumentException("playerUUID can't be null and/or factionName can't be empty.");
        }
        Faction faction = this.getFactionByName(factionName);
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        recruits.add(playerUUID);
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void leaveFaction(UUID playerUUID, String factionName) {
        Faction faction = this.getFactionByName(factionName);
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (faction.getRecruits().contains(playerUUID)) {
            recruits.remove(playerUUID);
        } else if (faction.getMembers().contains(playerUUID)) {
            members.remove(playerUUID);
        } else {
            officers.remove(playerUUID);
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setMembers(members).setOfficers(officers).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void addAlly(String playerFactionName, String invitedFactionName) {
        if (playerFactionName == null || invitedFactionName == null || playerFactionName.equals("") || invitedFactionName.equals("")) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction invitedFaction = this.getFactionByName(invitedFactionName);
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getAlliances());
        HashSet<String> invitedFactionAlliances = new HashSet<String>(invitedFaction.getAlliances());
        playerFactionAlliances.add(invitedFactionName);
        invitedFactionAlliances.add(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setAlliances(playerFactionAlliances).build();
        Faction updatedInvitedFaction = invitedFaction.toBuilder().setAlliances(invitedFactionAlliances).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedInvitedFaction);
    }

    @Override
    public void removeAlly(String playerFactionName, String removedFactionName) {
        if (playerFactionName == null || removedFactionName == null || playerFactionName.equals("") || removedFactionName.equals("")) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction removedFaction = this.getFactionByName(removedFactionName);
        HashSet<String> playerFactionAlliances = new HashSet<String>(playerFaction.getAlliances());
        HashSet<String> removedFactionAlliances = new HashSet<String>(removedFaction.getAlliances());
        playerFactionAlliances.remove(removedFactionName);
        removedFactionAlliances.remove(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setAlliances(playerFactionAlliances).build();
        Faction updatedRemovedFaction = removedFaction.toBuilder().setAlliances(removedFactionAlliances).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedRemovedFaction);
    }

    @Override
    public void addEnemy(String playerFactionName, String enemyFactionName) {
        if (playerFactionName == null || enemyFactionName == null || playerFactionName.equals("") || enemyFactionName.equals("")) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction enemyFaction = this.getFactionByName(enemyFactionName);
        HashSet<String> playerFactionEnemies = new HashSet<String>(playerFaction.getEnemies());
        HashSet<String> enemyFactionEnemies = new HashSet<String>(enemyFaction.getEnemies());
        playerFactionEnemies.add(enemyFactionName);
        enemyFactionEnemies.add(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setEnemies(playerFactionEnemies).build();
        Faction updatedEnemyFaction = enemyFaction.toBuilder().setEnemies(enemyFactionEnemies).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedEnemyFaction);
    }

    @Override
    public void removeEnemy(String playerFactionName, String enemyFactionName) {
        if (playerFactionName == null || enemyFactionName == null || playerFactionName.equals("") || enemyFactionName.equals("")) {
            throw new IllegalArgumentException("playerFactionName and invitedFactionName must contain a value.");
        }
        Faction playerFaction = this.getFactionByName(playerFactionName);
        Faction enemyFaction = this.getFactionByName(enemyFactionName);
        HashSet<String> playerFactionEnemies = new HashSet<String>(playerFaction.getEnemies());
        HashSet<String> enemyFactionEnemies = new HashSet<String>(enemyFaction.getEnemies());
        playerFactionEnemies.remove(enemyFactionName);
        enemyFactionEnemies.remove(playerFactionName);
        Faction updatedPlayerFaction = playerFaction.toBuilder().setEnemies(playerFactionEnemies).build();
        Faction updatedEnemyFaction = enemyFaction.toBuilder().setEnemies(enemyFactionEnemies).build();
        this.storageManager.addOrUpdateFaction(updatedPlayerFaction);
        this.storageManager.addOrUpdateFaction(updatedEnemyFaction);
    }

    @Override
    public void setLeader(UUID newLeaderUUID, String playerFactionName) {
        Faction faction = this.getFactionByName(playerFactionName);
        UUID leader = faction.getLeader();
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        if (!faction.getLeader().equals(this.DUMMY_UUID)) {
            officers.add(faction.getLeader());
        }
        if (faction.getOfficers().contains(newLeaderUUID)) {
            officers.remove(newLeaderUUID);
            leader = newLeaderUUID;
        } else if (faction.getMembers().contains(newLeaderUUID)) {
            members.remove(newLeaderUUID);
            leader = newLeaderUUID;
        } else if (faction.getRecruits().contains(newLeaderUUID)) {
            recruits.remove(newLeaderUUID);
            leader = newLeaderUUID;
        }
        Faction updatedFaction = faction.toBuilder().setLeader(leader).setOfficers(officers).setMembers(members).setRecruits(recruits).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public Set<Claim> getAllClaims() {
        return FactionsCache.getAllClaims();
    }

    @Override
    public void addClaims(Faction faction, List<Claim> claims) {
        HashSet<Claim> factionClaims = new HashSet<Claim>(faction.getClaims());
        for (Claim claim : claims) {
            factionClaims.add(claim);
            ParticlesUtil.spawnClaimParticles(claim);
        }
        Faction updatedFaction = faction.toBuilder().setClaims(factionClaims).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void addClaim(Faction faction, Claim claim) {
        HashSet<Claim> claims = new HashSet<Claim>(faction.getClaims());
        claims.add(claim);
        Faction updatedFaction = faction.toBuilder().setClaims(claims).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
        ParticlesUtil.spawnClaimParticles(claim);
    }

    @Override
    public void removeClaim(Faction faction, Claim claim) {
        this.removeClaimInternal(faction, claim);
        ParticlesUtil.spawnUnclaimParticles(claim);
    }

    @Override
    public void destroyClaim(Faction faction, Claim claim) {
        this.removeClaimInternal(faction, claim);
        ParticlesUtil.spawnDestroyClaimParticles(claim);
    }

    @Override
    public boolean isClaimed(UUID worldUUID, Vector3i chunk) {
        for (Claim claim : this.getAllClaims()) {
            if (!claim.getWorldUUID().equals(worldUUID) || !claim.getChunkPosition().equals((Object)chunk)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClaimConnected(Faction faction, Claim claimToCheck) {
        if (faction.getClaims().size() == 0) {
            return true;
        }
        for (Claim claim : faction.getClaims()) {
            if (!claimToCheck.getWorldUUID().equals(claim.getWorldUUID())) continue;
            Vector3i chunkToCheck = claimToCheck.getChunkPosition();
            Vector3i claimChunk = claim.getChunkPosition();
            if (claimChunk.getX() == chunkToCheck.getX() && (claimChunk.getZ() + 1 == chunkToCheck.getZ() || claimChunk.getZ() - 1 == chunkToCheck.getZ())) {
                return true;
            }
            if (claimChunk.getZ() != chunkToCheck.getZ() || claimChunk.getX() + 1 != chunkToCheck.getX() && claimChunk.getX() - 1 != chunkToCheck.getX()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setHome(@Nullable UUID worldUUID, Faction faction, @Nullable Vector3i home) {
        faction = home != null && worldUUID != null ? faction.toBuilder().setHome(new FactionHome(worldUUID, home)).build() : faction.toBuilder().setHome(null).build();
        this.storageManager.addOrUpdateFaction(faction);
    }

    @Override
    public List<String> getFactionsTags() {
        ArrayList<Faction> factionsList = new ArrayList<Faction>(this.getFactions().values());
        ArrayList<String> factionsTags = new ArrayList<String>();
        for (Faction faction : factionsList) {
            factionsTags.add(faction.getTag().toPlain());
        }
        return factionsTags;
    }

    @Override
    public boolean hasOnlinePlayers(Faction faction) {
        if (faction.getLeader() != null && !faction.getLeader().toString().equals("") && this._playerManager.isPlayerOnline(faction.getLeader())) {
            return true;
        }
        for (UUID playerUUID : faction.getOfficers()) {
            if (!this._playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        for (UUID playerUUID : faction.getMembers()) {
            if (!this._playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        for (UUID playerUUID : faction.getRecruits()) {
            if (!this._playerManager.isPlayerOnline(playerUUID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllClaims(Faction faction) {
        for (Claim claim : faction.getClaims()) {
            FactionsCache.removeClaimCache(claim);
        }
        Faction updatedFaction = faction.toBuilder().setClaims(new HashSet<Claim>()).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void kickPlayer(UUID playerUUID, String factionName) {
        Faction faction = this.getFactionByName(factionName);
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        if (faction.getRecruits().contains(playerUUID)) {
            recruits.remove(playerUUID);
        } else if (faction.getMembers().contains(playerUUID)) {
            members.remove(playerUUID);
        } else {
            officers.remove(playerUUID);
        }
        Faction updatedFaction = faction.toBuilder().setOfficers(officers).setMembers(members).setRecruits(recruits).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void startClaiming(Player player, Faction faction, UUID worldUUID, Vector3i chunk) {
        if (this.factionsConfig.shouldDelayClaim()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.CLAIMING_HAS_BEEN_STARTED + " " + PluginMessages.STAY_IN_THE_CHUNK_FOR + " ", TextColors.GOLD, this.factionsConfig.getClaimDelay() + " " + PluginMessages.SECONDS, TextColors.GREEN, " " + PluginMessages.TO_CLAIM_IT}));
            EagleFactionsScheduler.getInstance().scheduleWithDelayedInterval(new ClaimDelayTask(player, chunk), 1L, TimeUnit.SECONDS, 1L, TimeUnit.SECONDS);
        } else if (this.factionsConfig.shouldClaimByItems()) {
            boolean didSucceed = this.addClaimByItems(player, faction, worldUUID, chunk);
            if (didSucceed) {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.LAND + " ", TextColors.GOLD, chunk.toString(), TextColors.WHITE, " " + PluginMessages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, PluginMessages.CLAIMED, TextColors.WHITE, "!"}));
            } else {
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_DONT_HAVE_ENOUGH_RESOURCES_TO_CLAIM_A_TERRITORY}));
            }
        } else {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, PluginMessages.LAND + " ", TextColors.GOLD, chunk.toString(), TextColors.WHITE, " " + PluginMessages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, PluginMessages.CLAIMED, TextColors.WHITE, "!"}));
            this.addClaim(faction, new Claim(worldUUID, chunk));
        }
    }

    @Override
    public boolean addClaimByItems(Player player, Faction faction, UUID worldUUID, Vector3i chunk) {
        BlockState blockState;
        int variant;
        ItemStack itemStack;
        Optional itemType;
        String itemId;
        String[] idAndVariant;
        Map<String, Integer> requiredItems = this.factionsConfig.getRequiredItemsToClaim();
        PlayerInventory inventory = (PlayerInventory)player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(PlayerInventory.class)});
        int allRequiredItems = requiredItems.size();
        int foundItems = 0;
        for (String requiredItem : requiredItems.keySet()) {
            idAndVariant = requiredItem.split(":");
            itemId = idAndVariant[0] + ":" + idAndVariant[1];
            itemType = Sponge.getRegistry().getType(ItemType.class, itemId);
            if (!itemType.isPresent()) continue;
            itemStack = ItemStack.builder().itemType((ItemType)itemType.get()).build();
            itemStack.setQuantity(requiredItems.get(requiredItem).intValue());
            if (idAndVariant.length == 3 && ((ItemType)itemType.get()).getBlock().isPresent()) {
                variant = Integer.parseInt(idAndVariant[2]);
                blockState = (BlockState)((BlockType)((ItemType)itemType.get()).getBlock().get()).getAllBlockStates().toArray()[variant];
                itemStack = ItemStack.builder().fromBlockState(blockState).build();
            }
            if (inventory.contains(itemStack)) {
                ++foundItems;
                continue;
            }
            return false;
        }
        if (allRequiredItems == foundItems) {
            for (String requiredItem : requiredItems.keySet()) {
                idAndVariant = requiredItem.split(":");
                itemId = idAndVariant[0] + ":" + idAndVariant[1];
                itemType = Sponge.getRegistry().getType(ItemType.class, itemId);
                if (!itemType.isPresent()) continue;
                itemStack = ItemStack.builder().itemType((ItemType)itemType.get()).build();
                itemStack.setQuantity(requiredItems.get(requiredItem).intValue());
                if (idAndVariant.length == 3 && ((ItemType)itemType.get()).getBlock().isPresent()) {
                    variant = Integer.parseInt(idAndVariant[2]);
                    blockState = (BlockState)((BlockType)((ItemType)itemType.get()).getBlock().get()).getAllBlockStates().toArray()[variant];
                    itemStack = ItemStack.builder().fromBlockState(blockState).build();
                }
                inventory.query(new QueryOperation[]{QueryOperationTypes.ITEM_TYPE.of(itemType.get())}).poll(itemStack.getQuantity());
            }
            this.addClaim(faction, new Claim(worldUUID, chunk));
            return true;
        }
        return false;
    }

    @Override
    public void toggleFlag(Faction faction, FactionMemberType factionMemberType, FactionFlagTypes factionFlagTypes, Boolean flagValue) {
        HashMap<FactionMemberType, Map<FactionFlagTypes, Boolean>> flags = new HashMap<FactionMemberType, Map<FactionFlagTypes, Boolean>>(faction.getFlags());
        ((Map)flags.get((Object)factionMemberType)).replace(factionFlagTypes, flagValue);
        Faction updatedFaction = faction.toBuilder().setFlags(flags).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void changeTagColor(Faction faction, TextColor textColor) {
        Text text = Text.of((Object[])new Object[]{textColor, faction.getTag().toPlainSingle()});
        Faction updatedFaction = faction.toBuilder().setTag(text).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public FactionMemberType promotePlayer(Faction faction, UUID playerToPromote) {
        FactionMemberType promotedTo = FactionMemberType.RECRUIT;
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (recruits.contains(playerToPromote)) {
            members.add(playerToPromote);
            recruits.remove(playerToPromote);
            promotedTo = FactionMemberType.MEMBER;
        } else if (members.contains(playerToPromote)) {
            officers.add(playerToPromote);
            members.remove(playerToPromote);
            promotedTo = FactionMemberType.OFFICER;
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setOfficers(officers).setMembers(members).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
        return promotedTo;
    }

    @Override
    public FactionMemberType demotePlayer(Faction faction, UUID playerToDemote) {
        FactionMemberType demotedTo = FactionMemberType.RECRUIT;
        HashSet<UUID> recruits = new HashSet<UUID>(faction.getRecruits());
        HashSet<UUID> members = new HashSet<UUID>(faction.getMembers());
        HashSet<UUID> officers = new HashSet<UUID>(faction.getOfficers());
        if (members.contains(playerToDemote)) {
            recruits.add(playerToDemote);
            members.remove(playerToDemote);
            demotedTo = FactionMemberType.RECRUIT;
        } else if (officers.contains(playerToDemote)) {
            members.add(playerToDemote);
            officers.remove(playerToDemote);
            demotedTo = FactionMemberType.MEMBER;
        }
        Faction updatedFaction = faction.toBuilder().setRecruits(recruits).setOfficers(officers).setMembers(members).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
        return demotedTo;
    }

    @Override
    public void setLastOnline(Faction faction, Instant instantTime) {
        Faction updatedFaction = faction.toBuilder().setLastOnline(instantTime).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void renameFaction(Faction faction, String newFactionName) {
        this.storageManager.deleteFaction(faction.getName());
        Faction updatedFaction = faction.toBuilder().setName(newFactionName).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void changeTag(Faction faction, String newTag) {
        Faction updatedFaction = faction.toBuilder().setTag(Text.of((Object[])new Object[]{faction.getTag().getColor(), newTag})).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void setChest(Faction faction, FactionChest inventory) {
        Faction updatedFaction = faction.toBuilder().setChest(inventory).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void setDescription(Faction faction, String description) {
        Faction updatedFaction = faction.toBuilder().setDescription(description).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void setMessageOfTheDay(Faction faction, String motd) {
        Faction updatedFaction = faction.toBuilder().setMessageOfTheDay(motd).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    @Override
    public void setIsPublic(Faction playerFaction, boolean isPublic) {
        Faction updatedFaction = playerFaction.toBuilder().setIsPublic(isPublic).build();
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }

    private void removeClaimInternal(Faction faction, Claim claim) {
        HashSet<Claim> claims = new HashSet<Claim>(faction.getClaims());
        claims.remove(claim);
        Faction updatedFaction = faction.toBuilder().setClaims(claims).build();
        FactionsCache.removeClaimCache(claim);
        this.storageManager.addOrUpdateFaction(updatedFaction);
    }
}

