/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.logic;

import io.github.aquerr.eaglefactions.api.config.Configuration;
import io.github.aquerr.eaglefactions.api.config.PVPLoggerConfig;
import io.github.aquerr.eaglefactions.api.logic.PVPLogger;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.critieria.Criteria;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class PVPLoggerImpl
implements PVPLogger {
    private final PVPLoggerConfig pvpLoggerConfig;
    private Map<UUID, Integer> attackedPlayers;
    private Map<UUID, Integer> playersIdTaskMap;
    private boolean isActive;
    private int blockTime;
    private boolean shouldDisplayInScoreboard;
    private Set<String> blockedCommandsDuringFight;
    private final String PVPLOGGER_OBJECTIVE_NAME = "PVPLoggerImpl";

    public PVPLoggerImpl(Configuration configuration) {
        this.pvpLoggerConfig = configuration.getPvpLoggerConfig();
        this.isActive = this.pvpLoggerConfig.isPVPLoggerActive();
        if (this.isActive) {
            this.attackedPlayers = new HashMap<UUID, Integer>();
            this.playersIdTaskMap = new HashMap<UUID, Integer>();
            this.blockTime = this.pvpLoggerConfig.getPVPLoggerBlockTime();
            this.blockedCommandsDuringFight = this.pvpLoggerConfig.getBlockedCommandsDuringFight();
            this.shouldDisplayInScoreboard = this.pvpLoggerConfig.shouldDisplayPvpLoggerInScoreboard();
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public int getBlockTime() {
        return this.blockTime;
    }

    @Override
    public boolean shouldBlockCommand(Player player, String command) {
        if (!this.isPlayerBlocked(player)) {
            return false;
        }
        String usedCommand = command;
        if (command.charAt(0) == '/') {
            usedCommand = command.substring(1);
        }
        usedCommand = usedCommand.toLowerCase();
        for (String blockedCommand : this.blockedCommandsDuringFight) {
            if (blockedCommand.charAt(0) == '/') {
                blockedCommand = blockedCommand.substring(1);
            }
            if (!blockedCommand.equals("*") && !usedCommand.equals(blockedCommand) && !usedCommand.startsWith(blockedCommand)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrUpdatePlayer(final Player player) {
        Map<UUID, Integer> map = this.attackedPlayers;
        synchronized (map) {
            if (this.attackedPlayers.containsKey(player.getUniqueId())) {
                this.attackedPlayers.replace(player.getUniqueId(), this.getBlockTime());
            } else {
                this.attackedPlayers.put(player.getUniqueId(), this.getBlockTime());
                this.playersIdTaskMap.put(player.getUniqueId(), this.getNewTaskId(1));
                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.RED, PluginMessages.PVPLOGGER_HAS_TURNED_ON + " " + PluginMessages.YOU_WILL_DIE_IF_YOU_DISCONNECT_IN + " " + this.getBlockTime() + " " + PluginMessages.SECONDS + "!"}));
                Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
                taskBuilder.interval(1L, TimeUnit.SECONDS).execute((Consumer)new Consumer<Task>(){

                    @Override
                    public void accept(Task task) {
                        if (PVPLoggerImpl.this.attackedPlayers.containsKey(player.getUniqueId())) {
                            int seconds = (Integer)PVPLoggerImpl.this.attackedPlayers.get(player.getUniqueId());
                            if (seconds <= 0) {
                                player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, PluginMessages.PVPLOGGER_HAS_TURNED_OFF + " " + PluginMessages.YOU_CAN_NOW_DISCONNECT_SAFELY}));
                                PVPLoggerImpl.this.removePlayer(player);
                                task.cancel();
                            } else {
                                PVPLoggerImpl.this.attackedPlayers.replace(player.getUniqueId(), seconds - 1);
                                if (PVPLoggerImpl.this.shouldDisplayInScoreboard) {
                                    Scoreboard scoreboard = player.getScoreboard();
                                    Optional<Objective> optionalObjective = scoreboard.getObjective("PVPLoggerImpl-" + PVPLoggerImpl.this.playersIdTaskMap.get(player.getUniqueId()));
                                    if (!optionalObjective.isPresent()) {
                                        optionalObjective = Optional.of(Objective.builder().name("PVPLoggerImpl-" + PVPLoggerImpl.this.playersIdTaskMap.get(player.getUniqueId())).displayName(Text.of((Object[])new Object[]{TextColors.WHITE, "===", TextColors.RED, "PVP-LOGGER", TextColors.WHITE, "==="})).criterion(Criteria.DUMMY).objectiveDisplayMode(ObjectiveDisplayModes.INTEGER).build());
                                        scoreboard.addObjective(optionalObjective.get());
                                        scoreboard.updateDisplaySlot(optionalObjective.get(), DisplaySlots.SIDEBAR);
                                    }
                                    Score pvpTimer = ((Objective)optionalObjective.get()).getOrCreateScore((Text)Text.of((String)"Time:"));
                                    pvpTimer.setScore(seconds - 1);
                                }
                            }
                        } else {
                            task.cancel();
                        }
                    }
                }).async().submit((Object)EagleFactionsPlugin.getPlugin());
            }
        }
    }

    @Override
    public boolean isPlayerBlocked(Player player) {
        return this.attackedPlayers.containsKey(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlayer(Player player) {
        if (!this.isPlayerBlocked(player)) {
            return;
        }
        Map<UUID, Integer> map = this.attackedPlayers;
        synchronized (map) {
            Scoreboard scoreboard = player.getScoreboard();
            Optional pvploggerObjective = scoreboard.getObjective("PVPLoggerImpl-" + this.playersIdTaskMap.get(player.getUniqueId()));
            if (pvploggerObjective.isPresent()) {
                scoreboard.removeObjective((Objective)pvploggerObjective.get());
            }
            this.attackedPlayers.remove(player.getUniqueId());
        }
        map = this.playersIdTaskMap;
        synchronized (map) {
            this.playersIdTaskMap.remove(player.getUniqueId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPlayerBlockTime(Player player) {
        Map<UUID, Integer> map = this.attackedPlayers;
        synchronized (map) {
            return this.attackedPlayers.getOrDefault(player.getUniqueId(), 0);
        }
    }

    private Integer getNewTaskId(int preferredId) {
        if (this.playersIdTaskMap.values().contains(preferredId)) {
            return this.getNewTaskId(preferredId + 1);
        }
        return preferredId;
    }
}

