/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.PowerConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.managers.PlayerManager;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.storage.StorageManagerImpl;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;

public class PlayerManagerImpl
implements PlayerManager {
    private static PlayerManagerImpl INSTANCE = null;
    private final EagleFactions plugin;
    private final FactionsConfig factionsConfig;
    private final PowerConfig powerConfig;
    private final StorageManagerImpl storageManager;
    private UserStorageService userStorageService;

    private PlayerManagerImpl(EagleFactions plugin) {
        INSTANCE = this;
        this.plugin = plugin;
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        this.powerConfig = plugin.getConfiguration().getPowerConfig();
        this.storageManager = StorageManagerImpl.getInstance(plugin);
        Optional optionalUserStorageService = Sponge.getServiceManager().provide(UserStorageService.class);
        optionalUserStorageService.ifPresent(x -> {
            this.userStorageService = x;
        });
    }

    public static PlayerManagerImpl getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            return new PlayerManagerImpl(eagleFactions);
        }
        return INSTANCE;
    }

    @Override
    public boolean addPlayer(UUID playerUUID, String playerName) {
        return this.storageManager.addPlayer(playerUUID, playerName, this.powerConfig.getStartingPower(), this.powerConfig.getGlobalMaxPower());
    }

    @Override
    public float getPlayerPower(UUID playerUUID) {
        return this.storageManager.getPlayerPower(playerUUID);
    }

    @Override
    public boolean setPlayerPower(UUID playerUUID, float power) {
        return this.storageManager.setPlayerPower(playerUUID, power);
    }

    @Override
    public float getPlayerMaxPower(UUID playerUUID) {
        return this.storageManager.getPlayerMaxPower(playerUUID);
    }

    @Override
    public boolean setPlayerMaxPower(UUID playerUUID, float maxpower) {
        return this.storageManager.setPlayerMaxPower(playerUUID, maxpower);
    }

    @Override
    public Optional<String> getPlayerName(UUID playerUUID) {
        Optional<User> oUser = this.getUser(playerUUID);
        if (oUser.isPresent()) {
            return Optional.of(oUser.get().getName());
        }
        return this.getLastKnownPlayerName(playerUUID);
    }

    @Override
    public FactionPlayer convertToFactionPlayer(User user) {
        String factionName = "";
        FactionMemberType factionMemberType = null;
        Optional<Faction> optionalFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        if (optionalFaction.isPresent()) {
            factionName = optionalFaction.get().getName();
            factionMemberType = optionalFaction.get().getPlayerMemberType(user.getUniqueId());
        }
        return new FactionPlayerImpl(user.getName(), user.getUniqueId(), factionName, factionMemberType, this.powerConfig.getStartingPower(), this.powerConfig.getGlobalMaxPower());
    }

    private Optional<String> getLastKnownPlayerName(UUID playerUUID) {
        String playerName = this.storageManager.getPlayerName(playerUUID);
        if (playerName.equals("")) {
            return Optional.empty();
        }
        return Optional.of(playerName);
    }

    @Override
    public Optional<Player> getPlayer(UUID playerUUID) {
        Optional<User> oUser = this.getUser(playerUUID);
        if (!oUser.isPresent()) {
            return Optional.empty();
        }
        return oUser.get().getPlayer();
    }

    @Override
    public boolean isPlayerOnline(UUID playerUUID) {
        Optional<User> oUser = this.getUser(playerUUID);
        return oUser.map(User::isOnline).orElse(false);
    }

    @Override
    public Set<String> getServerPlayerNames() {
        return this.storageManager.getServerPlayerNames();
    }

    @Override
    public void setDeathInWarZone(UUID playerUUID, boolean didDieInWarZone) {
        this.storageManager.setDeathInWarzone(playerUUID, didDieInWarZone);
    }

    @Override
    public boolean lastDeathAtWarZone(UUID playerUUID) {
        return this.storageManager.getLastDeathInWarzone(playerUUID);
    }

    @Override
    public boolean checkIfPlayerExists(UUID playerUUID, String playerName) {
        return this.storageManager.checkIfPlayerExists(playerUUID, playerName);
    }

    @Override
    @Nullable
    public FactionMemberType getFactionMemberType(UUID playerUUID, Faction faction) {
        if (faction.getLeader() != null && faction.getLeader().equals(playerUUID)) {
            return FactionMemberType.LEADER;
        }
        if (faction.getMembers().contains(playerUUID)) {
            return FactionMemberType.MEMBER;
        }
        if (faction.getOfficers().contains(playerUUID)) {
            return FactionMemberType.OFFICER;
        }
        if (faction.getRecruits().contains(playerUUID)) {
            return FactionMemberType.RECRUIT;
        }
        return null;
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        return this.storageManager.getServerPlayers();
    }

    @Override
    public void updatePlayerName(UUID playerUUID, String playerName) {
        this.storageManager.updatePlayerName(playerUUID, playerName);
    }

    private Optional<User> getUser(UUID playerUUID) {
        Optional oUser = this.userStorageService.get(playerUUID);
        return oUser;
    }
}

