/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.PowerConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.managers.PowerManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;

@Singleton
public class PowerManagerImpl
implements PowerManager {
    private static PowerManagerImpl INSTANCE = null;
    private final EagleFactions plugin;
    private final PowerConfig powerConfig;
    private CommentedConfigurationNode _factionsNode;
    private final UUID dummyUUID = new UUID(0L, 0L);

    public static PowerManagerImpl getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            return new PowerManagerImpl(eagleFactions);
        }
        return INSTANCE;
    }

    private PowerManagerImpl(EagleFactions eagleFactions) {
        INSTANCE = this;
        this.plugin = eagleFactions;
        this.powerConfig = eagleFactions.getConfiguration().getPowerConfig();
        Path configDir = eagleFactions.getConfigDir();
        try {
            this._factionsNode = (CommentedConfigurationNode)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(Paths.get(configDir.resolve("data") + "/factions.conf", new String[0]))).build().load();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int getFactionMaxClaims(Faction faction) {
        float power = this.getFactionPower(faction);
        return (int)power;
    }

    @Override
    public float getPlayerPower(@Nullable UUID playerUUID) {
        if (playerUUID == null || playerUUID.equals(this.dummyUUID)) {
            return 0.0f;
        }
        return this.plugin.getPlayerManager().getPlayerPower(playerUUID);
    }

    @Override
    public float getFactionPower(Faction faction) {
        if (faction.getName().equals("SafeZone") || faction.getName().equals("WarZone")) {
            CommentedConfigurationNode powerNode = this._factionsNode.getNode(new Object[]{"factions", faction.getName(), "power"});
            return powerNode.getFloat(9999.0f);
        }
        float factionPower = 0.0f;
        if (faction.getLeader() != null && !faction.getLeader().toString().equals("")) {
            factionPower += this.getPlayerPower(faction.getLeader());
        }
        if (faction.getOfficers() != null && !faction.getOfficers().isEmpty()) {
            for (UUID officer : faction.getOfficers()) {
                float officerPower = this.getPlayerPower(officer);
                factionPower += officerPower;
            }
        }
        if (faction.getMembers() != null && !faction.getMembers().isEmpty()) {
            for (UUID member : faction.getMembers()) {
                float memberPower = this.getPlayerPower(member);
                factionPower += memberPower;
            }
        }
        if (faction.getRecruits() != null && !faction.getRecruits().isEmpty()) {
            for (UUID recruit : faction.getRecruits()) {
                float recruitPower = this.getPlayerPower(recruit);
                factionPower += recruitPower;
            }
        }
        return factionPower;
    }

    @Override
    public float getFactionMaxPower(Faction faction) {
        if (faction.getName().equals("SafeZone") || faction.getName().equals("WarZone")) {
            CommentedConfigurationNode powerNode = this._factionsNode.getNode(new Object[]{"factions", faction.getName(), "power"});
            return powerNode.getFloat(9999.0f);
        }
        float factionMaxPower = 0.0f;
        if (faction.getLeader() != null && !faction.getLeader().toString().equals("")) {
            factionMaxPower += this.getPlayerMaxPower(faction.getLeader());
        }
        if (faction.getOfficers() != null && !faction.getOfficers().isEmpty()) {
            for (UUID officer : faction.getOfficers()) {
                factionMaxPower += this.getPlayerMaxPower(officer);
            }
        }
        if (faction.getMembers() != null && !faction.getMembers().isEmpty()) {
            for (UUID member : faction.getMembers()) {
                factionMaxPower += this.getPlayerMaxPower(member);
            }
        }
        if (faction.getRecruits() != null && !faction.getRecruits().isEmpty()) {
            for (UUID recruit : faction.getRecruits()) {
                factionMaxPower += this.getPlayerMaxPower(recruit);
            }
        }
        return factionMaxPower;
    }

    @Override
    public float getPlayerMaxPower(UUID playerUUID) {
        if (playerUUID == null || playerUUID.equals(this.dummyUUID)) {
            return 0.0f;
        }
        return this.plugin.getPlayerManager().getPlayerMaxPower(playerUUID);
    }

    @Override
    public void addPower(UUID playerUUID, boolean isKillAward) {
        float playerPower = this.plugin.getPlayerManager().getPlayerPower(playerUUID);
        if (playerPower + this.powerConfig.getPowerIncrement() < this.getPlayerMaxPower(playerUUID)) {
            if (isKillAward) {
                float killAward = this.powerConfig.getKillAward();
                this.plugin.getPlayerManager().setPlayerPower(playerUUID, playerPower + killAward);
            } else {
                float newPower = PowerManagerImpl.round(playerPower + this.powerConfig.getPowerIncrement(), 2);
                this.plugin.getPlayerManager().setPlayerPower(playerUUID, newPower);
            }
        }
    }

    public static float round(float number, int decimalPlace) {
        BigDecimal bd = new BigDecimal(number);
        bd = bd.setScale(decimalPlace, 4);
        return bd.floatValue();
    }

    @Override
    public void setPower(UUID playerUUID, float power) {
        this.plugin.getPlayerManager().setPlayerPower(playerUUID, power);
    }

    @Override
    public void startIncreasingPower(UUID playerUUID) {
        Task.Builder taskBuilder = Sponge.getScheduler().createTaskBuilder();
        taskBuilder.interval(1L, TimeUnit.MINUTES).execute(task -> {
            if (!this.plugin.getPlayerManager().isPlayerOnline(playerUUID)) {
                task.cancel();
            }
            if (this.getPlayerPower(playerUUID) + this.powerConfig.getPowerIncrement() < this.getPlayerMaxPower(playerUUID)) {
                this.addPower(playerUUID, false);
            } else {
                this.setPower(playerUUID, this.getPlayerMaxPower(playerUUID));
            }
        }).async().submit((Object)this.plugin);
    }

    @Override
    public void decreasePower(UUID playerUUID) {
        float playerPower = this.plugin.getPlayerManager().getPlayerPower(playerUUID);
        if (playerPower - this.powerConfig.getPowerDecrement() > 0.0f) {
            this.plugin.getPlayerManager().setPlayerPower(playerUUID, playerPower - this.powerConfig.getPowerDecrement());
        } else {
            this.setPower(playerUUID, 0.0f);
        }
    }

    @Override
    public void penalty(UUID playerUUID) {
        float penalty;
        float playerPower = this.plugin.getPlayerManager().getPlayerPower(playerUUID);
        if (playerPower - (penalty = this.powerConfig.getPenalty()) > 0.0f) {
            this.plugin.getPlayerManager().setPlayerPower(playerUUID, playerPower - penalty);
        } else {
            this.plugin.getPlayerManager().setPlayerPower(playerUUID, 0.0f);
        }
    }

    @Override
    public void setMaxPower(UUID playerUUID, float power) {
        this.plugin.getPlayerManager().setPlayerMaxPower(playerUUID, power);
    }
}

