/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.managers;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.EagleFeather;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.managers.ProtectionManager;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Singleton
public class ProtectionManagerImpl
implements ProtectionManager {
    private static ProtectionManagerImpl INSTANCE = null;
    private final EagleFactions plugin;
    private final ProtectionConfig protectionConfig;

    public static ProtectionManagerImpl getInstance(EagleFactions plugin) {
        if (INSTANCE == null) {
            return new ProtectionManagerImpl(plugin);
        }
        return INSTANCE;
    }

    private ProtectionManagerImpl(EagleFactions plugin) {
        INSTANCE = this;
        this.plugin = plugin;
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
    }

    @Override
    public boolean canInteractWithBlock(Location<World> location, User user, boolean shouldNotify) {
        boolean isTileEntityAtLocation = location.getTileEntity().isPresent();
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Interact With Block:")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
        }
        World world = (World)location.getExtent();
        if (this.hasAdminMode(user.getUniqueId())) {
            return true;
        }
        if (this.isBlockWhitelistedForInteraction(location.getBlockType().getId())) {
            return true;
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName()) || warZoneWorlds.contains(world.getName())) {
            if (safeZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.safezone.interact")) {
                return true;
            }
            if (warZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.warzone.interact")) {
                return true;
            }
            if (warZoneWorlds.contains(world.getName()) && isTileEntityAtLocation && this.isHoldingEagleFeather(user)) {
                this.removeEagleFeather(user);
                return true;
            }
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        Optional<Faction> optionalChunkFaction = this.plugin.getFactionLogic().getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        if (!optionalChunkFaction.isPresent()) {
            return true;
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.getName().equalsIgnoreCase("SafeZone") && user.hasPermission("eaglefactions.safezone.interact")) {
            return true;
        }
        if (chunkFaction.getName().equalsIgnoreCase("WarZone") && user.hasPermission("eaglefactions.warzone.interact")) {
            return true;
        }
        if (chunkFaction.getName().equalsIgnoreCase("WarZone") && isTileEntityAtLocation && this.isHoldingEagleFeather(user)) {
            this.removeEagleFeather(user);
            return true;
        }
        if (!optionalPlayerFaction.isPresent()) {
            if (isTileEntityAtLocation && this.isHoldingEagleFeather(user)) {
                this.removeEagleFeather(user);
                return true;
            }
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (this.plugin.getFlagManager().canInteract(user.getUniqueId(), playerFaction, chunkFaction)) {
            return true;
        }
        if (isTileEntityAtLocation && this.isHoldingEagleFeather(user)) {
            this.removeEagleFeather(user);
            return true;
        }
        if (shouldNotify) {
            this.notifyPlayer(user);
        }
        return false;
    }

    @Override
    public boolean canUseItem(Location<World> location, User user, ItemStackSnapshot usedItem, boolean shouldNotify) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Usage of item:")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Used item: " + usedItem.getType().getName()))));
        }
        World world = (World)location.getExtent();
        if (this.hasAdminMode(user.getUniqueId())) {
            return true;
        }
        if (this.isItemWhitelisted(usedItem.getType().getId())) {
            return true;
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName()) || warZoneWorlds.contains(world.getName())) {
            if (safeZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.safezone.interact")) {
                return true;
            }
            if (warZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.warzone.interact")) {
                return true;
            }
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        Optional<Faction> optionalChunkFaction = this.plugin.getFactionLogic().getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        if (!optionalChunkFaction.isPresent()) {
            return true;
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.getName().equalsIgnoreCase("SafeZone") && user.hasPermission("eaglefactions.safezone.interact")) {
            return true;
        }
        if (chunkFaction.getName().equalsIgnoreCase("WarZone") && user.hasPermission("eaglefactions.warzone.interact")) {
            return true;
        }
        if (!optionalPlayerFaction.isPresent()) {
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        Faction playerFaction = optionalPlayerFaction.get();
        if (this.plugin.getFlagManager().canInteract(user.getUniqueId(), playerFaction, chunkFaction)) {
            return true;
        }
        if (shouldNotify) {
            this.notifyPlayer(user);
        }
        return false;
    }

    @Override
    public boolean canBreak(Location<World> location, User user, boolean shouldNotify) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Block break event!")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
        }
        World world = (World)location.getExtent();
        if (this.hasAdminMode(user.getUniqueId()) || this.isBlockWhitelistedForPlaceDestroy(location.getBlockType().getId())) {
            return true;
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName()) || warZoneWorlds.contains(world.getName())) {
            if (safeZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.safezone.build")) {
                return true;
            }
            if (warZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.warzone.build")) {
                return true;
            }
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        Optional<Faction> optionalChunkFaction = this.plugin.getFactionLogic().getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        Optional<Faction> optionalPlayerFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        if (optionalChunkFaction.isPresent()) {
            if (optionalChunkFaction.get().getName().equals("WarZone") || optionalChunkFaction.get().getName().equals("SafeZone")) {
                if (optionalChunkFaction.get().getName().equals("SafeZone") && user.hasPermission("eaglefactions.safezone.build")) {
                    return true;
                }
                if (optionalChunkFaction.get().getName().equals("WarZone") && user.hasPermission("eaglefactions.warzone.build")) {
                    return true;
                }
                if (shouldNotify) {
                    this.notifyPlayer(user);
                }
                return false;
            }
            if (optionalPlayerFaction.isPresent()) {
                if (!this.plugin.getFlagManager().canBreakBlock(user.getUniqueId(), optionalPlayerFaction.get(), optionalChunkFaction.get())) {
                    if (shouldNotify) {
                        this.notifyPlayer(user);
                    }
                    return false;
                }
            } else {
                if (shouldNotify) {
                    this.notifyPlayer(user);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canBreak(Location<World> location) {
        World world = (World)location.getExtent();
        if (this.isBlockWhitelistedForPlaceDestroy(location.getBlockType().getId())) {
            return true;
        }
        if (this.protectionConfig.getSafeZoneWorldNames().contains(world.getName())) {
            return false;
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(world.getName()) && this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
            return false;
        }
        Optional<Faction> optionalChunkFaction = this.plugin.getFactionLogic().getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return true;
        }
        if (optionalChunkFaction.get().getName().equalsIgnoreCase("SafeZone")) {
            return false;
        }
        if (optionalChunkFaction.get().getName().equalsIgnoreCase("WarZone") && this.protectionConfig.shouldProtectWarZoneFromMobGrief()) {
            return false;
        }
        return !this.protectionConfig.shouldProtectClaimFromMobGrief();
    }

    @Override
    public boolean canPlace(Location<World> location, User user, boolean shouldNotify) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Block place:")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Item in hand: " + (user.getItemInHand(HandTypes.MAIN_HAND).isPresent() ? ((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).getType().getName() : "")))));
        }
        World world = (World)location.getExtent();
        if (this.hasAdminMode(user.getUniqueId()) || user.getItemInHand(HandTypes.MAIN_HAND).isPresent() && this.isBlockWhitelistedForPlaceDestroy(((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).getType().getId())) {
            return true;
        }
        Set<String> safeZoneWorlds = this.protectionConfig.getSafeZoneWorldNames();
        Set<String> warZoneWorlds = this.protectionConfig.getWarZoneWorldNames();
        if (safeZoneWorlds.contains(world.getName()) || warZoneWorlds.contains(world.getName())) {
            if (safeZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.safezone.build")) {
                return true;
            }
            if (warZoneWorlds.contains(world.getName()) && user.hasPermission("eaglefactions.warzone.build")) {
                return true;
            }
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        Optional<Faction> optionalPlayerFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        Optional<Faction> optionalChunkFaction = this.plugin.getFactionLogic().getFactionByChunk(world.getUniqueId(), location.getChunkPosition());
        if (optionalChunkFaction.isPresent()) {
            if (optionalChunkFaction.get().getName().equals("WarZone") || optionalChunkFaction.get().getName().equals("SafeZone")) {
                if (optionalChunkFaction.get().getName().equals("SafeZone") && user.hasPermission("eaglefactions.safezone.build")) {
                    return true;
                }
                if (optionalChunkFaction.get().getName().equals("WarZone") && user.hasPermission("eaglefactions.warzone.build")) {
                    return true;
                }
                if (shouldNotify) {
                    this.notifyPlayer(user);
                }
                return false;
            }
            if (optionalPlayerFaction.isPresent()) {
                if (!this.plugin.getFlagManager().canPlaceBlock(user.getUniqueId(), optionalPlayerFaction.get(), optionalChunkFaction.get())) {
                    if (shouldNotify) {
                        this.notifyPlayer(user);
                    }
                    return false;
                }
            } else {
                if (shouldNotify) {
                    this.notifyPlayer(user);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canExplode(Location<World> location, User user, boolean shouldNotify) {
        if (EagleFactionsPlugin.DEBUG_MODE_PLAYERS.contains(user.getUniqueId()) && user instanceof Player) {
            Player player = (Player)user;
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)"Explosion:")));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Location: " + location.toString()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("User: " + user.getName()))));
            player.sendMessage(PluginInfo.PLUGIN_PREFIX.concat((Text)Text.of((String)("Block at location: " + location.getBlockType().getName()))));
        }
        boolean shouldProtectWarZoneFromPlayers = this.protectionConfig.shouldProtectWarzoneFromPlayers();
        boolean allowExplosionsByOtherPlayersInClaims = this.protectionConfig.shouldAllowExplosionsByOtherPlayersInClaims();
        if (EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(user.getUniqueId())) {
            return true;
        }
        if (this.protectionConfig.getSafeZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            if (shouldProtectWarZoneFromPlayers) {
                if (shouldNotify) {
                    this.notifyPlayer(user);
                }
                return false;
            }
            return true;
        }
        Optional<Faction> optionalChunkFaction = this.plugin.getFactionLogic().getFactionByChunk(((World)location.getExtent()).getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return true;
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.getName().equals("WarZone") || chunkFaction.getName().equals("SafeZone")) {
            if (chunkFaction.getName().equals("SafeZone") && user.hasPermission("eaglefactions.safezone.build")) {
                return true;
            }
            if (chunkFaction.getName().equals("WarZone") && user.hasPermission("eaglefactions.warzone.build")) {
                return true;
            }
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        Optional<Faction> optionalPlayerFaction = this.plugin.getFactionLogic().getFactionByPlayerUUID(user.getUniqueId());
        if (optionalPlayerFaction.isPresent()) {
            Faction playerFaction = optionalPlayerFaction.get();
            if (chunkFaction.getName().equalsIgnoreCase(playerFaction.getName())) {
                if (!this.plugin.getFlagManager().canPlaceBlock(user.getUniqueId(), playerFaction, chunkFaction)) {
                    if (shouldNotify) {
                        this.notifyPlayer(user);
                    }
                    return false;
                }
                return true;
            }
        }
        if (!allowExplosionsByOtherPlayersInClaims) {
            if (shouldNotify) {
                this.notifyPlayer(user);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canExplode(Location<World> location) {
        boolean shouldProtectWarZoneFromMobGrief = this.protectionConfig.shouldProtectWarZoneFromMobGrief();
        boolean shouldProtectClaimsFromMobGrief = this.protectionConfig.shouldProtectClaimFromMobGrief();
        if (this.protectionConfig.getSafeZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            return false;
        }
        if (this.protectionConfig.getWarZoneWorldNames().contains(((World)location.getExtent()).getName())) {
            return !shouldProtectWarZoneFromMobGrief;
        }
        Optional<Faction> optionalChunkFaction = this.plugin.getFactionLogic().getFactionByChunk(((World)location.getExtent()).getUniqueId(), location.getChunkPosition());
        if (!optionalChunkFaction.isPresent()) {
            return true;
        }
        Faction chunkFaction = optionalChunkFaction.get();
        if (chunkFaction.getName().equalsIgnoreCase("SafeZone")) {
            return false;
        }
        if (chunkFaction.getName().equalsIgnoreCase("WarZone") && shouldProtectWarZoneFromMobGrief) {
            return false;
        }
        return !shouldProtectClaimsFromMobGrief;
    }

    @Override
    public boolean isItemWhitelisted(String itemId) {
        Set<String> whiteListedItems = this.protectionConfig.getWhiteListedItems();
        return this.isWhiteListed(whiteListedItems, itemId);
    }

    @Override
    public boolean isBlockWhitelistedForInteraction(String blockId) {
        Set<String> whiteListedBlocks = this.protectionConfig.getWhiteListedInteractBlocks();
        return this.isWhiteListed(whiteListedBlocks, blockId);
    }

    @Override
    public boolean isBlockWhitelistedForPlaceDestroy(String blockOrItemId) {
        Set<String> whiteListedBlocks = this.protectionConfig.getWhiteListedPlaceDestroyBlocks();
        return this.isWhiteListed(whiteListedBlocks, blockOrItemId);
    }

    private boolean isWhiteListed(Collection<String> collection, String itemId) {
        for (String whiteListedItemId : collection) {
            if (whiteListedItemId.equals(itemId)) {
                return true;
            }
            try {
                Pattern pattern = Pattern.compile(whiteListedItemId);
                if (!pattern.matcher(itemId).matches()) continue;
                return true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
            }
        }
        return false;
    }

    private boolean hasAdminMode(UUID playerUUID) {
        return EagleFactionsPlugin.ADMIN_MODE_PLAYERS.contains(playerUUID);
    }

    private boolean isHoldingEagleFeather(User user) {
        return user.getItemInHand(HandTypes.MAIN_HAND).isPresent() && ((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).getType() == ItemTypes.FEATHER && ((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).get(Keys.DISPLAY_NAME).isPresent() && ((Text)((ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get()).get(Keys.DISPLAY_NAME).get()).equals((Object)EagleFeather.getDisplayName());
    }

    private void removeEagleFeather(User user) {
        ItemStack feather = (ItemStack)user.getItemInHand(HandTypes.MAIN_HAND).get();
        feather.setQuantity(feather.getQuantity() - 1);
        user.getPlayer().ifPresent(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.DARK_PURPLE, "You have used eagle's feather!"})));
    }

    private void notifyPlayer(User user) {
        if (this.plugin.getConfiguration().getChatConfig().shouldDisplayProtectionSystemMessages()) {
            user.getPlayer().ifPresent(x -> x.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, PluginMessages.YOU_DONT_HAVE_ACCESS_TO_DO_THIS})));
        }
    }
}

