/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.message;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;

@Singleton
public class MessageLoader {
    private final FactionsConfig factionsConfig;
    private static MessageLoader instance = null;

    public static MessageLoader getInstance(EagleFactions plugin) {
        if (instance == null) {
            return new MessageLoader(plugin);
        }
        return instance;
    }

    private MessageLoader(EagleFactions plugin) {
        Optional optionalMessagesFile;
        instance = this;
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        Path configDir = plugin.getConfigDir();
        String messagesFileName = this.factionsConfig.getLanguageFileName();
        Path messagesFilePath = configDir.resolve("messages").resolve(messagesFileName);
        if (!Files.exists(configDir.resolve("messages"), new LinkOption[0])) {
            try {
                Files.createDirectory(configDir.resolve("messages"), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((optionalMessagesFile = Sponge.getAssetManager().getAsset((Object)plugin, "messages" + File.separator + messagesFileName)).isPresent()) {
            try {
                ((Asset)optionalMessagesFile.get()).copyToFile(messagesFilePath, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            optionalMessagesFile = Sponge.getAssetManager().getAsset((Object)plugin, "messages" + File.separator + "english.conf");
            optionalMessagesFile.ifPresent(x -> {
                try {
                    x.copyToFile(messagesFilePath, false, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        HoconConfigurationLoader configLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(messagesFilePath)).build();
        try {
            ConfigurationNode configNode = configLoader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
            this.loadPluginMessages(configNode, (ConfigurationLoader)configLoader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPluginMessages(ConfigurationNode configNode, ConfigurationLoader configLoader) {
        Field[] messageFields = PluginMessages.class.getFields();
        boolean missingNodes = false;
        for (Field messageField : messageFields) {
            String object = configNode.getNode(new Object[]{messageField.getName()}).getString("MISSING_MESSAGE");
            if (object.equals("MISSING_MESSAGE")) {
                missingNodes = true;
            }
            String message = object.toString();
            try {
                messageField.set(PluginMessages.class.getClass(), message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (missingNodes) {
            try {
                configLoader.save(configNode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

