/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.scheduling;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.Configuration;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.message.PluginMessages;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsRunnableTask;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class FactionRemoverTask
implements EagleFactionsRunnableTask {
    private final Configuration configuration;
    private final FactionLogic factionLogic;
    private final FactionsConfig factionsConfig;

    public FactionRemoverTask(EagleFactions plugin) {
        this.configuration = plugin.getConfiguration();
        this.factionLogic = plugin.getFactionLogic();
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public void run() {
        long maxInactiveTimeInSeconds = this.factionsConfig.getMaxInactiveTime();
        HashMap<String, Faction> factionsList = new HashMap<String, Faction>(this.factionLogic.getFactions());
        boolean shouldNotifyWhenRemoved = this.factionsConfig.shouldNotifyWhenFactionRemoved();
        for (Map.Entry factionEntry : factionsList.entrySet()) {
            boolean didSucceed;
            Duration inactiveTime;
            if (this.factionLogic.hasOnlinePlayers((Faction)factionEntry.getValue()) || ((Faction)factionEntry.getValue()).getName().equalsIgnoreCase("safezone") || ((Faction)factionEntry.getValue()).getName().equalsIgnoreCase("warzone") || (inactiveTime = Duration.between(((Faction)factionEntry.getValue()).getLastOnline(), Instant.now())).getSeconds() < maxInactiveTimeInSeconds || !(didSucceed = this.factionLogic.disbandFaction(((Faction)factionEntry.getValue()).getName())) || !shouldNotifyWhenRemoved) continue;
            Sponge.getServer().getBroadcastChannel().send(PluginInfo.PLUGIN_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.RED, PluginMessages.FACTION + " ", TextColors.GOLD, factionEntry.getKey(), TextColors.RED, " has been removed due to its long inactivity time."})));
        }
    }
}

