/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.StorageConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.caching.FactionsCache;
import io.github.aquerr.eaglefactions.common.storage.IFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.IPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.HOCONFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.HOCONPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.h2.H2FactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.h2.H2PlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mariadb.MariaDbFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mariadb.MariaDbPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mysql.MySQLFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mysql.MySQLPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.utils.DeleteFactionTask;
import io.github.aquerr.eaglefactions.common.storage.utils.IStorageTask;
import io.github.aquerr.eaglefactions.common.storage.utils.UpdateFactionTask;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class StorageManagerImpl
implements StorageManager,
Runnable {
    private static StorageManagerImpl INSTANCE = null;
    private final IFactionStorage factionsStorage;
    private final IPlayerStorage playerStorage;
    private final Queue<IStorageTask> storageTaskQueue;
    private final EagleFactions plugin;
    private final Thread storageThread;

    public static StorageManagerImpl getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            return new StorageManagerImpl(eagleFactions);
        }
        return INSTANCE;
    }

    private StorageManagerImpl(EagleFactions eagleFactions) {
        INSTANCE = this;
        this.plugin = eagleFactions;
        StorageConfig storageConfig = eagleFactions.getConfiguration().getStorageConfig();
        Path configDir = eagleFactions.getConfigDir();
        switch (storageConfig.getStorageType().toLowerCase()) {
            case "hocon": {
                this.factionsStorage = new HOCONFactionStorage(configDir);
                this.playerStorage = new HOCONPlayerStorage(configDir);
                this.plugin.printInfo("HOCON storage has been initialized!");
                break;
            }
            case "h2": {
                this.factionsStorage = new H2FactionStorage(eagleFactions);
                this.playerStorage = new H2PlayerStorage(eagleFactions);
                this.plugin.printInfo("H2 storage has been initialized!");
                break;
            }
            case "mysql": {
                this.factionsStorage = new MySQLFactionStorage(eagleFactions);
                this.playerStorage = new MySQLPlayerStorage(eagleFactions);
                this.plugin.printInfo("MySQL storage has been initialized!");
                break;
            }
            case "mariadb": {
                this.factionsStorage = new MariaDbFactionStorage(eagleFactions);
                this.playerStorage = new MariaDbPlayerStorage(eagleFactions);
                this.plugin.printInfo("MariaDB storage has been initialized!");
                break;
            }
            default: {
                this.plugin.printInfo("Couldn't find provided storage type.");
                this.factionsStorage = new HOCONFactionStorage(configDir);
                this.playerStorage = new HOCONPlayerStorage(configDir);
                this.plugin.printInfo("Initialized default HOCON storage.");
            }
        }
        this.prepareFactionsCache();
        this.storageTaskQueue = new LinkedList<IStorageTask>();
        this.storageThread = new Thread(this::run);
        this.storageThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueStorageTask(IStorageTask task) {
        Queue<IStorageTask> queue = this.storageTaskQueue;
        synchronized (queue) {
            this.storageTaskQueue.add(task);
            this.storageTaskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Queue<IStorageTask> queue = this.storageTaskQueue;
            synchronized (queue) {
                if (this.storageTaskQueue.size() > 0) {
                    IStorageTask storageTask = this.storageTaskQueue.poll();
                    if (storageTask instanceof DeleteFactionTask) {
                        this.factionsStorage.deleteFaction(((DeleteFactionTask)storageTask).getFactionName());
                    } else if (storageTask instanceof UpdateFactionTask) {
                        this.factionsStorage.addOrUpdateFaction(((UpdateFactionTask)storageTask).getFaction());
                    }
                } else {
                    try {
                        this.storageTaskQueue.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void addOrUpdateFaction(Faction faction) {
        FactionsCache.addOrUpdateFactionCache(faction);
        this.queueStorageTask(new UpdateFactionTask(faction));
    }

    @Override
    public boolean deleteFaction(String factionName) {
        FactionsCache.removeFactionCache(factionName);
        this.queueStorageTask(new DeleteFactionTask(factionName));
        return true;
    }

    @Override
    @Nullable
    public Faction getFaction(String factionName) {
        try {
            Faction factionCache = FactionsCache.getFactionCache(factionName);
            if (factionCache != null) {
                return factionCache;
            }
            Faction faction = this.factionsStorage.getFaction(factionName);
            if (faction == null) {
                return null;
            }
            FactionsCache.addOrUpdateFactionCache(faction);
            return faction;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void prepareFactionsCache() {
        Set<Faction> factionSet = this.factionsStorage.getFactions();
        for (Faction faction : factionSet) {
            FactionsCache.addOrUpdateFactionCache(faction);
        }
    }

    @Override
    public void reloadStorage() {
        FactionsCache.clearCache();
        this.factionsStorage.load();
        this.prepareFactionsCache();
    }

    @Override
    public boolean checkIfPlayerExists(UUID playerUUID, String playerName) {
        return this.playerStorage.checkIfPlayerExists(playerUUID, playerName);
    }

    @Override
    public boolean addPlayer(UUID playerUUID, String playerName, float startingPower, float maxpower) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.addPlayer(playerUUID, playerName, startingPower, maxpower)).isDone();
    }

    @Override
    public boolean setDeathInWarzone(UUID playerUUID, boolean didDieInWarZone) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.setDeathInWarzone(playerUUID, didDieInWarZone)).isDone();
    }

    @Override
    public boolean getLastDeathInWarzone(UUID playerUUID) {
        return this.playerStorage.getLastDeathInWarzone(playerUUID);
    }

    @Override
    public float getPlayerPower(UUID playerUUID) {
        return this.playerStorage.getPlayerPower(playerUUID);
    }

    @Override
    public boolean setPlayerPower(UUID playerUUID, float power) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.setPlayerPower(playerUUID, power)).isDone();
    }

    @Override
    public float getPlayerMaxPower(UUID playerUUID) {
        return this.playerStorage.getPlayerMaxPower(playerUUID);
    }

    @Override
    public boolean setPlayerMaxPower(UUID playerUUID, float maxpower) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.setPlayerMaxPower(playerUUID, maxpower)).isDone();
    }

    @Override
    public Set<String> getServerPlayerNames() {
        return this.playerStorage.getServerPlayerNames();
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        return this.playerStorage.getServerPlayers();
    }

    @Override
    public String getPlayerName(UUID playerUUID) {
        return this.playerStorage.getPlayerName(playerUUID);
    }

    @Override
    public boolean updatePlayerName(UUID playerUUID, String playerName) {
        return CompletableFuture.supplyAsync(() -> this.playerStorage.updatePlayerName(playerUUID, playerName)).isDone();
    }
}

