/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.file.hocon;

import com.google.common.reflect.TypeToken;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionFlagTypes;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.common.entities.FactionChestImpl;
import io.github.aquerr.eaglefactions.common.entities.FactionImpl;
import io.github.aquerr.eaglefactions.common.storage.IFactionStorage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.text.Text;

public class HOCONFactionStorage
implements IFactionStorage {
    private Path filePath;
    private ConfigurationLoader<CommentedConfigurationNode> configLoader;
    private CommentedConfigurationNode configNode;
    private boolean needToSave = false;
    private Function<Object, Set<UUID>> objectToUUIDListTransformer = object -> {
        if (object instanceof List) {
            HashSet<UUID> uuidSet = new HashSet<UUID>();
            List list = (List)object;
            for (String stringUUID : list) {
                String[] components = stringUUID.split("-");
                if (components.length != 5) continue;
                uuidSet.add(UUID.fromString(stringUUID));
            }
            return uuidSet;
        }
        return null;
    };

    public HOCONFactionStorage(Path configDir) {
        try {
            Path dataPath = configDir.resolve("data");
            if (!Files.exists(dataPath, new LinkOption[0])) {
                Files.createDirectory(dataPath, new FileAttribute[0]);
            }
            this.filePath = dataPath.resolve("factions.conf");
            if (!Files.exists(this.filePath, new LinkOption[0])) {
                Files.createFile(this.filePath, new FileAttribute[0]);
                this.configLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.filePath)).build();
                this.preCreate();
            } else {
                this.configLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.filePath)).build();
                this.load();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void preCreate() {
        this.load();
        this.getStorage().getNode(new Object[]{"factions"}).setComment("This file stores all data about factions");
        this.getStorage().getNode(new Object[]{"factions", "WarZone", "claims"}).setValue(new ArrayList());
        this.getStorage().getNode(new Object[]{"factions", "WarZone", "members"}).setValue(new ArrayList());
        this.getStorage().getNode(new Object[]{"factions", "SafeZone", "claims"}).setValue(new ArrayList());
        this.getStorage().getNode(new Object[]{"factions", "SafeZone", "members"}).setValue(new ArrayList());
        this.saveChanges();
    }

    public boolean saveFaction(Faction faction) {
        try {
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "tag"}).setValue(TypeToken.of(Text.class), (Object)faction.getTag());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "leader"}).setValue((Object)faction.getLeader().toString());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "description"}).setValue((Object)faction.getDescription());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "motd"}).setValue((Object)faction.getMessageOfTheDay());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "officers"}).setValue((TypeToken)new TypeToken<ArrayList<UUID>>(){}, new ArrayList<UUID>(faction.getOfficers()));
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "members"}).setValue((TypeToken)new TypeToken<ArrayList<UUID>>(){}, new ArrayList<UUID>(faction.getMembers()));
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "recruits"}).setValue((TypeToken)new TypeToken<ArrayList<UUID>>(){}, new ArrayList<UUID>(faction.getRecruits()));
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "enemies"}).setValue(faction.getEnemies());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "alliances"}).setValue(faction.getAlliances());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "claims"}).setValue(faction.getClaims().stream().map(Claim::toString).collect(Collectors.toList()));
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "last_online"}).setValue((Object)faction.getLastOnline().toString());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "flags"}).setValue(faction.getFlags());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "chest"}).setValue((TypeToken)new TypeToken<List<FactionChest.SlotItem>>(){}, faction.getChest().getItems());
            this.configNode.getNode(new Object[]{"factions", faction.getName(), "isPublic"}).setValue((Object)faction.isPublic());
            if (faction.getHome() == null) {
                this.configNode.getNode(new Object[]{"factions", faction.getName(), "home"}).setValue((Object)faction.getHome());
            } else {
                this.configNode.getNode(new Object[]{"factions", faction.getName(), "home"}).setValue((Object)(faction.getHome().getWorldUUID().toString() + '|' + faction.getHome().getBlockPosition().toString()));
            }
            return this.saveChanges();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean addOrUpdateFaction(Faction faction) {
        return this.saveFaction(faction);
    }

    @Override
    public boolean deleteFaction(String factionName) {
        try {
            this.configNode.getNode(new Object[]{"factions"}).removeChild((Object)factionName);
            return this.saveChanges();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.saveChanges();
        }
    }

    @Override
    @Nullable
    public Faction getFaction(String factionName) {
        if (this.configNode.getNode(new Object[]{"factions", factionName}).getValue() == null) {
            return null;
        }
        return this.createFactionObject(factionName);
    }

    private Faction createFactionObject(String factionName) {
        Text tag = this.getFactionTag(factionName);
        String description = this.getFactionDescription(factionName);
        String messageOfTheDay = this.getFactionMessageOfTheDay(factionName);
        UUID leader = this.getFactionLeader(factionName);
        FactionHome home = this.getFactionHome(factionName);
        Set<UUID> officers = this.getFactionOfficers(factionName);
        Set<UUID> members = this.getFactionMembers(factionName);
        Set<UUID> recruits = this.getFactionRecruits(factionName);
        Set<String> alliances = this.getFactionAlliances(factionName);
        Set<String> enemies = this.getFactionEnemies(factionName);
        Set<Claim> claims = this.getFactionClaims(factionName);
        Instant lastOnline = this.getLastOnline(factionName);
        Map<FactionMemberType, Map<FactionFlagTypes, Boolean>> flags = this.getFactionFlags(factionName);
        FactionChest chest = this.getFactionChest(factionName);
        boolean isPublic = this.getFactionIsPublic(factionName);
        Faction faction = FactionImpl.builder(factionName, tag, leader).setDescription(description).setMessageOfTheDay(messageOfTheDay).setHome(home).setOfficers(officers).setMembers(members).setRecruits(recruits).setAlliances(alliances).setEnemies(enemies).setClaims(claims).setLastOnline(lastOnline).setFlags(flags).setChest(chest).setIsPublic(isPublic).build();
        if (this.needToSave) {
            this.saveChanges();
        }
        return faction;
    }

    private FactionChest getFactionChest(String factionName) {
        List slotItems = null;
        try {
            slotItems = (List)this.configNode.getNode(new Object[]{"factions", factionName, "chest"}).getValue((TypeToken)new TypeToken<List<FactionChest.SlotItem>>(){});
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return new FactionChestImpl(factionName);
        }
        if (slotItems != null) {
            return new FactionChestImpl(factionName, slotItems);
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "chest"}).setValue(new ArrayList());
        this.needToSave = true;
        return new FactionChestImpl(factionName);
    }

    private Map<FactionMemberType, Map<FactionFlagTypes, Boolean>> getFactionFlags(String factionName) {
        LinkedHashMap<FactionMemberType, Map<FactionFlagTypes, Boolean>> flagMap = new LinkedHashMap<FactionMemberType, Map<FactionFlagTypes, Boolean>>();
        LinkedHashMap<FactionFlagTypes, Boolean> leaderMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        LinkedHashMap<FactionFlagTypes, Boolean> officerMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        LinkedHashMap<FactionFlagTypes, Boolean> membersMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        LinkedHashMap<FactionFlagTypes, Boolean> recruitMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        LinkedHashMap<FactionFlagTypes, Boolean> allyMap = new LinkedHashMap<FactionFlagTypes, Boolean>();
        boolean leaderUSE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "LEADER", "USE"}).getBoolean(true);
        boolean leaderPLACE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "LEADER", "PLACE"}).getBoolean(true);
        boolean leaderDESTROY = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "LEADER", "DESTROY"}).getBoolean(true);
        boolean leaderCLAIM = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "LEADER", "CLAIM"}).getBoolean(true);
        boolean leaderATTACK = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "LEADER", "ATTACK"}).getBoolean(true);
        boolean leaderINVITE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "LEADER", "INVITE"}).getBoolean(true);
        boolean officerUSE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "OFFICER", "USE"}).getBoolean(true);
        boolean officerPLACE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "OFFICER", "PLACE"}).getBoolean(true);
        boolean officerDESTROY = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "OFFICER", "DESTROY"}).getBoolean(true);
        boolean officerCLAIM = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "OFFICER", "CLAIM"}).getBoolean(true);
        boolean officerATTACK = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "LEADER", "ATTACK"}).getBoolean(true);
        boolean officerINVITE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "OFFICER", "INVITE"}).getBoolean(true);
        boolean memberUSE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "MEMBER", "USE"}).getBoolean(true);
        boolean memberPLACE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "MEMBER", "PLACE"}).getBoolean(true);
        boolean memberDESTROY = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "MEMBER", "DESTROY"}).getBoolean(true);
        boolean memberCLAIM = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "MEMBER", "CLAIM"}).getBoolean(false);
        boolean memberATTACK = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "LEADER", "ATTACK"}).getBoolean(false);
        boolean memberINVITE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "MEMBER", "INVITE"}).getBoolean(true);
        boolean recruitUSE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "RECRUIT", "USE"}).getBoolean(true);
        boolean recruitPLACE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "RECRUIT", "PLACE"}).getBoolean(true);
        boolean recruitDESTROY = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "RECRUIT", "DESTROY"}).getBoolean(true);
        boolean recruitCLAIM = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "RECRUIT", "CLAIM"}).getBoolean(false);
        boolean recruitATTACK = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "RECRUIT", "ATTACK"}).getBoolean(false);
        boolean recruitINVITE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "RECRUIT", "INVITE"}).getBoolean(false);
        boolean allyUSE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "ALLY", "USE"}).getBoolean(true);
        boolean allyPLACE = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "ALLY", "PLACE"}).getBoolean(false);
        boolean allyDESTROY = this.configNode.getNode(new Object[]{"factions", factionName, "flags", "ALLY", "DESTROY"}).getBoolean(false);
        leaderMap.put(FactionFlagTypes.USE, leaderUSE);
        leaderMap.put(FactionFlagTypes.PLACE, leaderPLACE);
        leaderMap.put(FactionFlagTypes.DESTROY, leaderDESTROY);
        leaderMap.put(FactionFlagTypes.CLAIM, leaderCLAIM);
        leaderMap.put(FactionFlagTypes.ATTACK, leaderATTACK);
        leaderMap.put(FactionFlagTypes.INVITE, leaderINVITE);
        officerMap.put(FactionFlagTypes.USE, officerUSE);
        officerMap.put(FactionFlagTypes.PLACE, officerPLACE);
        officerMap.put(FactionFlagTypes.DESTROY, officerDESTROY);
        officerMap.put(FactionFlagTypes.CLAIM, officerCLAIM);
        officerMap.put(FactionFlagTypes.ATTACK, officerATTACK);
        officerMap.put(FactionFlagTypes.INVITE, officerINVITE);
        membersMap.put(FactionFlagTypes.USE, memberUSE);
        membersMap.put(FactionFlagTypes.PLACE, memberPLACE);
        membersMap.put(FactionFlagTypes.DESTROY, memberDESTROY);
        membersMap.put(FactionFlagTypes.CLAIM, memberCLAIM);
        membersMap.put(FactionFlagTypes.ATTACK, memberATTACK);
        membersMap.put(FactionFlagTypes.INVITE, memberINVITE);
        recruitMap.put(FactionFlagTypes.USE, recruitUSE);
        recruitMap.put(FactionFlagTypes.PLACE, recruitPLACE);
        recruitMap.put(FactionFlagTypes.DESTROY, recruitDESTROY);
        recruitMap.put(FactionFlagTypes.CLAIM, recruitCLAIM);
        recruitMap.put(FactionFlagTypes.ATTACK, recruitATTACK);
        recruitMap.put(FactionFlagTypes.INVITE, recruitINVITE);
        allyMap.put(FactionFlagTypes.USE, allyUSE);
        allyMap.put(FactionFlagTypes.PLACE, allyPLACE);
        allyMap.put(FactionFlagTypes.DESTROY, allyDESTROY);
        flagMap.put(FactionMemberType.LEADER, leaderMap);
        flagMap.put(FactionMemberType.OFFICER, officerMap);
        flagMap.put(FactionMemberType.MEMBER, membersMap);
        flagMap.put(FactionMemberType.RECRUIT, recruitMap);
        flagMap.put(FactionMemberType.ALLY, allyMap);
        return flagMap;
    }

    private Instant getLastOnline(String factionName) {
        Object lastOnline = this.configNode.getNode(new Object[]{"factions", factionName, "last_online"}).getValue();
        if (lastOnline != null) {
            return Instant.parse(lastOnline.toString());
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "last_online"}).setValue((Object)Instant.now().toString());
        this.needToSave = true;
        return Instant.now();
    }

    private Set<Claim> getFactionClaims(String factionName) {
        Object claimsObject = this.configNode.getNode(new Object[]{"factions", factionName, "claims"}).getValue();
        if (claimsObject != null) {
            HashSet<Claim> claims = new HashSet<Claim>();
            for (String claimAsString : (List)claimsObject) {
                Claim claim = Claim.valueOf(claimAsString);
                claims.add(claim);
            }
            return claims;
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "claims"}).setValue(new HashSet());
        this.needToSave = true;
        return new HashSet<Claim>();
    }

    private Set<String> getFactionEnemies(String factionName) {
        Object enemiesObject = this.configNode.getNode(new Object[]{"factions", factionName, "enemies"}).getValue();
        if (enemiesObject != null) {
            return new HashSet<String>((List)enemiesObject);
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "enemies"}).setValue(new HashSet());
        this.needToSave = true;
        return new HashSet<String>();
    }

    private Set<String> getFactionAlliances(String factionName) {
        Object alliancesObject = this.configNode.getNode(new Object[]{"factions", factionName, "alliances"}).getValue();
        if (alliancesObject != null) {
            return new HashSet<String>((List)alliancesObject);
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "alliances"}).setValue(new HashSet());
        this.needToSave = true;
        return new HashSet<String>();
    }

    private Set<UUID> getFactionMembers(String factionName) {
        Set membersObject = (Set)this.configNode.getNode(new Object[]{"factions", factionName, "members"}).getValue(this.objectToUUIDListTransformer);
        if (membersObject != null) {
            return membersObject;
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "members"}).setValue(new HashSet());
        this.needToSave = true;
        return new HashSet<UUID>();
    }

    private Set<UUID> getFactionRecruits(String factionName) {
        Set recruitsObject = (Set)this.configNode.getNode(new Object[]{"factions", factionName, "recruits"}).getValue(this.objectToUUIDListTransformer);
        if (recruitsObject != null) {
            return recruitsObject;
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "recruits"}).setValue(new HashSet());
        this.needToSave = true;
        return new HashSet<UUID>();
    }

    private FactionHome getFactionHome(String factionName) {
        Object homeObject = this.configNode.getNode(new Object[]{"factions", factionName, "home"}).getValue();
        if (homeObject != null) {
            if (String.valueOf(homeObject).equals("")) {
                return null;
            }
            return FactionHome.from(String.valueOf(homeObject));
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "home"}).setValue((Object)"");
        this.needToSave = true;
        return null;
    }

    private Set<UUID> getFactionOfficers(String factionName) {
        Set officersObject = (Set)this.configNode.getNode(new Object[]{"factions", factionName, "officers"}).getValue(this.objectToUUIDListTransformer);
        if (officersObject != null) {
            return officersObject;
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "officers"}).setValue(new HashSet());
        this.needToSave = true;
        return new HashSet<UUID>();
    }

    @Nullable
    private UUID getFactionLeader(String factionName) {
        Object leaderObject = this.configNode.getNode(new Object[]{"factions", factionName, "leader"}).getValue();
        if (leaderObject != null && !leaderObject.equals("")) {
            return UUID.fromString(String.valueOf(leaderObject));
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "leader"}).setValue((Object)"");
        this.needToSave = true;
        return new UUID(0L, 0L);
    }

    private Text getFactionTag(String factionName) {
        Object tagObject = null;
        try {
            tagObject = this.configNode.getNode(new Object[]{"factions", factionName, "tag"}).getValue(TypeToken.of(Text.class));
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        if (tagObject != null) {
            return (Text)tagObject;
        }
        try {
            this.configNode.getNode(new Object[]{"factions", factionName, "tag"}).setValue(TypeToken.of(Text.class), (Object)Text.of((String)""));
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        this.needToSave = true;
        return Text.of((String)"");
    }

    private String getFactionDescription(String factionName) {
        Object leaderObject = this.configNode.getNode(new Object[]{"factions", factionName, "description"}).getValue();
        if (leaderObject != null) {
            return (String)leaderObject;
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "description"}).setValue((Object)"");
        this.needToSave = true;
        return "";
    }

    private String getFactionMessageOfTheDay(String factionName) {
        Object leaderObject = this.configNode.getNode(new Object[]{"factions", factionName, "motd"}).getValue();
        if (leaderObject != null) {
            return (String)leaderObject;
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "motd"}).setValue((Object)"");
        this.needToSave = true;
        return "";
    }

    private boolean getFactionIsPublic(String factionName) {
        Object isPublicObject = this.configNode.getNode(new Object[]{"factions", factionName, "isPublic"}).getValue();
        if (isPublicObject != null) {
            return (Boolean)isPublicObject;
        }
        this.configNode.getNode(new Object[]{"factions", factionName, "isPublic"}).setValue((Object)false);
        this.needToSave = true;
        return false;
    }

    @Override
    public Set<Faction> getFactions() {
        HashSet<Faction> factions = new HashSet<Faction>();
        Set keySet = this.getStorage().getNode(new Object[]{"factions"}).getChildrenMap().keySet();
        for (Object object : keySet) {
            if (!(object instanceof String)) continue;
            Faction faction = this.createFactionObject(String.valueOf(object));
            factions.add(faction);
        }
        return factions;
    }

    @Override
    public void load() {
        try {
            this.configNode = (CommentedConfigurationNode)this.configLoader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean saveChanges() {
        try {
            this.configLoader.save((ConfigurationNode)this.configNode);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private CommentedConfigurationNode getStorage() {
        return this.configNode;
    }
}

