/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.sql;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.storage.IPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public abstract class AbstractPlayerStorage
implements IPlayerStorage {
    private static final String INSERT_PLAYER = "INSERT INTO Players (PlayerUUID, Name, Power, MaxPower, DeathInWarzone) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_PLAYER = "UPDATE Players SET PlayerUUID = ?, Name = ?, Power = ?, MaxPower = ?, DeathInWarzone = ? WHERE PlayerUUID = ?";
    private static final String MERGE_PLAYER = "MERGE INTO Players (PlayerUUID, Name, Power, MaxPower, DeathInWarzone) KEY (PlayerUUID) VALUES (?, ?, ?, ?, ?)";
    private static final String SELECT_PLAYER_WHERE_PLAYERUUID = "SELECT Name FROM Players WHERE PlayerUUID=? LIMIT 1";
    private static final String SELECT_PLAYERS = "SELECT * FROM Players";
    private static final String SELECT_PLAYER_NAMES = "SELECT Name FROM Players";
    private static final String SELECT_DEATH_IN_WARZONE_WHERE_PLAYERUUID = "SELECT DeathInWarzone FROM Players WHERE PlayerUUID=? LIMIT 1";
    private static final String SELECT_PLAYER_WHERE_PLAYERUUID_AND_PLAYERNAME = "SELECT * FROM Players WHERE PlayerUUID=? AND Name=? LIMIT 1";
    private static final String SELECT_POWER_WHERE_PLAYERUUID = "SELECT Power FROM Players WHERE PlayerUUID=? LIMIT 1";
    private static final String SELECT_MAXPOWER_WHERE_PLAYERUUID = "SELECT MaxPower FROM Players WHERE PlayerUUID=? LIMIT 1";
    private static final String UPDATE_POWER_WHERE_PLAYERUUID = "UPDATE Players SET Power=? WHERE PlayerUUID=?";
    private static final String UPDATE_MAXPOWER_WHERE_PLAYERUUID = "UPDATE Players SET MaxPower=? WHERE PlayerUUID=?";
    private static final String UPDATE_DEATH_IN_WARZONE_WHERE_PLAYERUUID = "UPDATE Players SET DeathInWarzone=? WHERE PlayerUUID=?";
    private static final String UPDATE_PLAYERNAME_WHERE_PLAYERUUID = "UPDATE Players SET Name=? WHERE PlayerUUID=?";
    private final EagleFactions plugin;
    private final SQLProvider sqlProvider;

    protected AbstractPlayerStorage(EagleFactions plugin, SQLProvider sqlProvider) {
        if (sqlProvider == null) {
            Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not establish connection to the database. Aborting..."}));
            Sponge.getServer().shutdown();
        }
        this.plugin = plugin;
        this.sqlProvider = sqlProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkIfPlayerExists(UUID playerUUID, String playerName) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement statement = connection.prepareStatement(SELECT_PLAYER_WHERE_PLAYERUUID_AND_PLAYERNAME);
            statement.setString(1, playerUUID.toString());
            statement.setString(2, playerName);
            ResultSet resultSet = statement.executeQuery();
            boolean exists = resultSet.next();
            resultSet.close();
            statement.close();
            boolean bl = exists;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addPlayer(UUID playerUUID, String playerName, float startingPower, float maxPower) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement statement = connection.prepareStatement(INSERT_PLAYER);
            statement.setString(1, playerUUID.toString());
            statement.setString(2, playerName);
            statement.setFloat(3, startingPower);
            statement.setFloat(4, maxPower);
            statement.setBoolean(5, false);
            boolean didSucceed = statement.execute();
            statement.close();
            boolean bl = didSucceed;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setDeathInWarzone(UUID playerUUID, boolean didDieInWarZone) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(UPDATE_DEATH_IN_WARZONE_WHERE_PLAYERUUID);
            preparedStatement.setBoolean(1, didDieInWarZone);
            preparedStatement.setString(2, playerUUID.toString());
            boolean didSucceed = preparedStatement.execute();
            preparedStatement.close();
            boolean bl = didSucceed;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getLastDeathInWarzone(UUID playerUUID) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(SELECT_DEATH_IN_WARZONE_WHERE_PLAYERUUID);
            preparedStatement.setString(1, playerUUID.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            boolean lastDeathInWarzone = false;
            if (resultSet.next()) {
                lastDeathInWarzone = resultSet.getBoolean("DeathInWarzone");
            }
            resultSet.close();
            preparedStatement.close();
            boolean bl = lastDeathInWarzone;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getPlayerPower(UUID playerUUID) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(SELECT_POWER_WHERE_PLAYERUUID);
            preparedStatement.setString(1, playerUUID.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            float power = 0.0f;
            if (resultSet.next()) {
                power = resultSet.getFloat("Power");
            }
            resultSet.close();
            preparedStatement.close();
            float f = power;
            return f;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setPlayerPower(UUID playerUUID, float power) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(UPDATE_POWER_WHERE_PLAYERUUID);
            preparedStatement.setFloat(1, power);
            preparedStatement.setString(2, playerUUID.toString());
            boolean didSucceed = preparedStatement.execute();
            preparedStatement.close();
            boolean bl = didSucceed;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getPlayerMaxPower(UUID playerUUID) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(SELECT_MAXPOWER_WHERE_PLAYERUUID);
            preparedStatement.setString(1, playerUUID.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            float power = 0.0f;
            if (resultSet.next()) {
                power = resultSet.getFloat("MaxPower");
            }
            resultSet.close();
            preparedStatement.close();
            float f = power;
            return f;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setPlayerMaxPower(UUID playerUUID, float maxpower) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(UPDATE_MAXPOWER_WHERE_PLAYERUUID);
            preparedStatement.setFloat(1, maxpower);
            preparedStatement.setString(2, playerUUID.toString());
            boolean didSucceed = preparedStatement.execute();
            preparedStatement.close();
            boolean bl = didSucceed;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Set<String> getServerPlayerNames() {
        HashSet<String> playerNames = new HashSet<String>();
        try (Connection connection = this.sqlProvider.getConnection();){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(SELECT_PLAYER_NAMES);
            while (resultSet.next()) {
                String playerName = resultSet.getString("Name");
                playerNames.add(playerName);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return playerNames;
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        HashSet<FactionPlayer> factionPlayers = new HashSet<FactionPlayer>();
        try (Connection connection = this.sqlProvider.getConnection();){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(SELECT_PLAYERS);
            while (resultSet.next()) {
                UUID playerUUID = resultSet.getObject("PlayerUUID", UUID.class);
                String name = resultSet.getString("Name");
                float power = resultSet.getInt("Power");
                float maxpower = resultSet.getInt("Maxpower");
                FactionPlayerImpl factionPlayer = new FactionPlayerImpl(name, playerUUID, null, null, power, maxpower);
                factionPlayers.add(factionPlayer);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return factionPlayers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPlayerName(UUID playerUUID) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(SELECT_PLAYER_WHERE_PLAYERUUID);
            preparedStatement.setString(1, playerUUID.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            String playerName = "";
            while (resultSet.next()) {
                playerName = resultSet.getString("Name");
            }
            resultSet.close();
            preparedStatement.close();
            String string = playerName;
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updatePlayerName(UUID playerUUID, String playerName) {
        try (Connection connection = this.sqlProvider.getConnection();){
            PreparedStatement preparedStatement = connection.prepareStatement(UPDATE_PLAYERNAME_WHERE_PLAYERUUID);
            preparedStatement.setString(1, playerName);
            preparedStatement.setString(2, playerUUID.toString());
            boolean didSucceed = preparedStatement.execute();
            preparedStatement.close();
            boolean bl = didSucceed;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }
}

