/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.sql.mariadb;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLAbstractProvider;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MariaDbProvider
extends SQLAbstractProvider
implements SQLProvider {
    private static MariaDbProvider INSTANCE = null;

    public static MariaDbProvider getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new MariaDbProvider(eagleFactions);
                return INSTANCE;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return INSTANCE;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:mariadb://" + super.getDatabaseUrl() + super.getDatabaseName(), super.getUsername(), super.getPassword());
    }

    @Override
    public String getProviderName() {
        return "mariadb";
    }

    private MariaDbProvider(EagleFactions eagleFactions) throws SQLException {
        super(eagleFactions);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    private boolean databaseExists() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:mariadb://" + super.getDatabaseUrl(), super.getUsername(), super.getPassword());
        ResultSet resultSet = connection.getMetaData().getCatalogs();
        while (resultSet.next()) {
            if (!resultSet.getString(1).equalsIgnoreCase(super.getDatabaseName())) continue;
            resultSet.close();
            connection.close();
            return true;
        }
        resultSet.close();
        connection.close();
        return false;
    }

    private void createDatabase() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:mariadb://" + super.getDatabaseUrl() + "?user=" + super.getUsername() + "&password=" + super.getPassword());
        Statement statement = connection.createStatement();
        statement.execute("CREATE SCHEMA " + super.getDatabaseName() + ";");
        statement.close();
        connection.close();
    }
}

