/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.util;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.world.World;

public final class ParticlesUtil {
    private ParticlesUtil() {
    }

    public static void spawnClaimParticles(Claim claim) {
        Optional optionalWorld = Sponge.getServer().getWorld(claim.getWorldUUID());
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Vector3d position = ParticlesUtil.getChunkCenter(world, claim.getChunkPosition());
        world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.END_ROD).option(ParticleOptions.VELOCITY, (Object)new Vector3d(0.0, 0.15, 0.0)).quantity(400).offset(new Vector3d(8.0f, 1.0f, 8.0f)).build(), position);
        world.playSound(SoundTypes.BLOCK_ENDERCHEST_OPEN, position, 5.0, -20.0);
    }

    public static void spawnUnclaimParticles(Claim claim) {
        Optional optionalWorld = Sponge.getServer().getWorld(claim.getWorldUUID());
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Vector3d position = ParticlesUtil.getChunkCenter(world, claim.getChunkPosition());
        world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.CLOUD).option(ParticleOptions.VELOCITY, (Object)new Vector3d(0.0, 0.15, 0.0)).quantity(800).offset(new Vector3d(8.0f, 1.0f, 8.0f)).build(), position);
        world.playSound(SoundTypes.ENTITY_SHULKER_SHOOT, position, 5.0, -20.0);
    }

    public static void spawnDestroyClaimParticles(Claim claim) {
        Optional optionalWorld = Sponge.getServer().getWorld(claim.getWorldUUID());
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Vector3d position = ParticlesUtil.getChunkCenter(world, claim.getChunkPosition());
        world.spawnParticles(ParticleEffect.builder().type(ParticleTypes.FLAME).option(ParticleOptions.VELOCITY, (Object)new Vector3d(0.0, 0.15, 0.0)).quantity(800).offset(new Vector3d(8.0f, 1.0f, 8.0f)).build(), position);
        world.playSound(SoundTypes.ENTITY_BLAZE_SHOOT, position, 5.0, -20.0);
    }

    private static Vector3d getChunkCenter(World world, Vector3i chunkPosition) {
        double x = (chunkPosition.getX() << 4) + 8;
        double z = (chunkPosition.getZ() << 4) + 8;
        double y = world.getHighestYAt((int)x, (int)z);
        return new Vector3d(x, y, z);
    }
}

