/*
 * Decompiled with CFR 0.152.
 */
package com.mineaurion.aurionvotelistener;

import com.mineaurion.aurionvotelistener.Main;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.asset.Asset;

public class Config {
    private Main plugin;
    private Path settingPath;
    public static ConfigurationLoader<CommentedConfigurationNode> settingLoader;
    public CommentedConfigurationNode settingNode;
    private Path rewardPath;
    public static ConfigurationLoader<CommentedConfigurationNode> rewardLoader;
    public CommentedConfigurationNode rewardNode;
    private Path adrewardPath;
    public static ConfigurationLoader<CommentedConfigurationNode> adrewardLoader;
    public CommentedConfigurationNode adrewardNode;
    public static boolean onlineOnly;
    public static boolean broadcastoffline;
    public static boolean votecommand;
    public static boolean joinmessage;
    public static String dbHost;
    public static int dbPort;
    public static String dbUser;
    public static String dbPass;
    public static String dbName;
    public static String dbPrefix;
    public static String dbTableTotal;
    public static String dbTableQueue;
    public static int votetopnumber;
    public static boolean AddExtraRandom;
    public static boolean GiveChanceReward;
    public static List<String> extrarandom;
    public static List<Integer> cumulativreward;
    public static List<String> permission;
    public static int delay;
    public static boolean cumulativevoting;
    public static String SQLType;
    public static String SQLFile;
    public static List<String> voteMessage;
    public static List<String> messagejoin;
    public static List<String> annoucement;
    public static String offlineBroadcast;
    public static String offlinePlayerMessage;
    public static String votetopformat;
    public static List<String> votetopheader;

    public Config(Main main) throws IOException {
        this.plugin = main;
        this.settingPath = Paths.get(this.plugin.configDir + "/Setting.conf", new String[0]);
        this.rewardPath = Paths.get(this.plugin.configDir + "/Reward.conf", new String[0]);
        this.adrewardPath = Paths.get(this.plugin.configDir + "/AdvancedReward.conf", new String[0]);
        this.configCheck();
    }

    private void configCheck() throws IOException {
        if (!(Files.exists(this.settingPath, new LinkOption[0]) || Files.exists(this.rewardPath, new LinkOption[0]) || Files.exists(this.adrewardPath, new LinkOption[0]))) {
            this.plugin.sendmessage("<YELLOW>Copy config File", "console");
            Asset configAsset = (Asset)this.plugin.pluginContainer.getAsset("Setting.conf").get();
            Asset RewardAsset = (Asset)this.plugin.pluginContainer.getAsset("Reward.conf").get();
            Asset AdRewardAsset = (Asset)this.plugin.pluginContainer.getAsset("AdvancedReward.conf").get();
            configAsset.copyToDirectory(this.plugin.configDir);
            RewardAsset.copyToDirectory(this.plugin.configDir);
            AdRewardAsset.copyToDirectory(this.plugin.configDir);
        }
        settingLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.settingPath)).build();
        rewardLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.rewardPath)).build();
        adrewardLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.adrewardPath)).build();
        this.settingNode = (CommentedConfigurationNode)settingLoader.load();
        this.rewardNode = (CommentedConfigurationNode)rewardLoader.load();
        this.adrewardNode = (CommentedConfigurationNode)adrewardLoader.load();
        this.getSetting((ConfigurationNode)this.settingNode);
        this.GetAdvancedReward((ConfigurationNode)this.adrewardNode);
    }

    private void getSetting(ConfigurationNode Node) {
        extrarandom.clear();
        voteMessage.clear();
        messagejoin.clear();
        votetopheader.clear();
        onlineOnly = Node.getNode(new Object[]{"settings", "onlineonly"}).getBoolean();
        broadcastoffline = Node.getNode(new Object[]{"settings", "broadcastoffline"}).getBoolean();
        votecommand = Node.getNode(new Object[]{"settings", "votecommand"}).getBoolean();
        joinmessage = Node.getNode(new Object[]{"settings", "joinmessage"}).getBoolean();
        SQLType = Node.getNode(new Object[]{"settings", "dbMode"}).getString();
        dbHost = Node.getNode(new Object[]{"settings", "dbHost"}).getString();
        dbPort = Node.getNode(new Object[]{"settings", "dbPort"}).getInt();
        dbPrefix = Node.getNode(new Object[]{"settings", "dbPrefix"}).getString();
        dbUser = Node.getNode(new Object[]{"settings", "dbUser"}).getString();
        dbPass = Node.getNode(new Object[]{"settings", "dbPass"}).getString();
        dbName = Node.getNode(new Object[]{"settings", "dbName"}).getString();
        dbTableTotal = Node.getNode(new Object[]{"settings", "dbTableTotal"}).getString();
        dbTableQueue = Node.getNode(new Object[]{"settings", "dbTableQueue"}).getString();
        votetopnumber = Node.getNode(new Object[]{"settings", "votetopnumber"}).getInt();
        SQLFile = Node.getNode(new Object[]{"settings", "dbFile"}).getString();
        AddExtraRandom = Node.getNode(new Object[]{"settings", "AddExtraReward"}).getBoolean();
        GiveChanceReward = Node.getNode(new Object[]{"settings", "GiveChanceReward"}).getBoolean();
        delay = Node.getNode(new Object[]{"settings", "AnnouncementDelay"}).getInt();
        cumulativevoting = Node.getNode(new Object[]{"settings", "cumulativevoting"}).getBoolean();
        voteMessage = Node.getNode(new Object[]{"votemessage"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(Collectors.toList());
        messagejoin = Node.getNode(new Object[]{"joinmessage"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(Collectors.toList());
        annoucement = Node.getNode(new Object[]{"Announcement"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(Collectors.toList());
        offlineBroadcast = Node.getNode(new Object[]{"Offline", "broadcast"}).getString();
        offlinePlayerMessage = Node.getNode(new Object[]{"Offline", "playermessage"}).getString();
        votetopformat = Node.getNode(new Object[]{"votetopformat"}).getString();
        votetopheader = Node.getNode(new Object[]{"votetopheader"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(Collectors.toList());
    }

    public void GetAdvancedReward(ConfigurationNode Node) {
        String key;
        for (Map.Entry markers : Node.getNode(new Object[]{"ExtraReward"}).getChildrenMap().entrySet()) {
            key = (String)markers.getKey();
            extrarandom.add(key);
        }
        Collections.sort(extrarandom, Collections.reverseOrder());
        for (Map.Entry markers : Node.getNode(new Object[]{"cumulativevoting"}).getChildrenMap().entrySet()) {
            key = (String)markers.getKey();
            cumulativreward.add(Integer.parseInt(key));
        }
        Collections.sort(cumulativreward);
        for (Map.Entry markers : Node.getNode(new Object[]{"perms"}).getChildrenMap().entrySet()) {
            key = (String)markers.getKey();
            permission.add(key);
        }
    }

    static {
        onlineOnly = true;
        broadcastoffline = false;
        votecommand = true;
        joinmessage = true;
        dbPort = 3306;
        dbName = "";
        dbPrefix = "";
        dbTableTotal = "ListenerTotal";
        dbTableQueue = "ListenerQueue";
        votetopnumber = 10;
        AddExtraRandom = false;
        GiveChanceReward = true;
        extrarandom = new ArrayList<String>();
        cumulativreward = new ArrayList<Integer>();
        permission = new ArrayList<String>();
        delay = 300;
        cumulativevoting = false;
        voteMessage = new ArrayList<String>();
        messagejoin = new ArrayList<String>();
        annoucement = new ArrayList<String>();
        votetopformat = "<POSITION>. <GREEN><username> - <WHITE><TOTAL>";
        votetopheader = new ArrayList<String>();
    }
}

