/*
 * Decompiled with CFR 0.152.
 */
package com.mineaurion.aurionvotelistener;

import com.google.inject.Inject;
import com.mineaurion.aurionvotelistener.Config;
import com.mineaurion.aurionvotelistener.EventManager;
import com.mineaurion.aurionvotelistener.Rewards;
import com.mineaurion.aurionvotelistener.SQL.MySqlTask;
import com.mineaurion.aurionvotelistener.SQL.SQLTask;
import com.mineaurion.aurionvotelistener.SQL.SwitchSQL;
import com.mineaurion.aurionvotelistener.commands.CommandManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.serializer.TextSerializers;

@Plugin(id="aurionsvotelistener", name="AurionsVoteListener", version="2.4.2", authors={"THEJean_Kevin", "Yann151924"}, description="A votifier listener for Sponge", dependencies={@Dependency(id="nuvotifier", optional=true)})
public class Main {
    @Inject
    private Game game;
    @Inject
    public PluginContainer pluginContainer;
    @Inject
    public Logger logger;
    @Inject
    @ConfigDir(sharedRoot=false)
    public Path configDir;
    public CommandManager commandManager;
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_RESET = "\u001b[0m";
    public Task task;
    public SwitchSQL switchsql;
    public MySqlTask mysqltask;
    public SQLTask sqltask;
    public Rewards rewardTask;
    public Config config;

    @Listener
    public void onInitialization(GameInitializationEvent event) throws IOException {
        this.logger.info("AurionsVoteListener Vote loading...");
        this.logger.info("Trying To setup Config Loader");
        this.config = new Config(this);
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EventManager(this));
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) throws IOException, SQLException {
        this.loadCommands(this);
        this.switchsql = new SwitchSQL(this, this.game);
        this.mysqltask = new MySqlTask();
        this.sqltask = new SQLTask();
        this.initialiseDatabase();
        this.rewardTask = new Rewards(this);
        this.loadTask(this);
        this.logger.info("AurionsVoteListener Enabled");
    }

    @Listener
    public void onServerReload(GameReloadEvent event) throws IOException, SQLException {
        this.task.cancel();
        this.config = new Config(this);
        this.initialiseDatabase();
        this.loadTask(this);
        MessageReceiver src = (MessageReceiver)event.getCause().first(CommandSource.class).orElse(Sponge.getServer().getConsole());
        src.sendMessage(Text.of((Object[])new Object[]{this.formatmessage("<YELLOW>Reload Finish", "", "")}));
    }

    private void loadTask(Main main) {
        this.task = Task.builder().execute(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < Config.annoucement.size(); ++i) {
                    MessageChannel messageChannel = MessageChannel.TO_PLAYERS;
                    messageChannel.send(Main.this.formatmessage(Config.annoucement.get(i), "", ""));
                }
            }
        }).async().delay((long)Config.delay, TimeUnit.SECONDS).interval((long)Config.delay, TimeUnit.SECONDS).submit((Object)main);
        if (Config.delay < 0) {
            this.task.cancel();
        }
    }

    private void initialiseDatabase() throws SQLException {
        this.sendmessage("<YELLOW>Loading DataBase", "console");
        if (Config.SQLType == "MySQL" && (Config.dbHost.isEmpty() || Config.dbHost == null || Config.dbUser.isEmpty() || Config.dbUser == null || Config.dbPass.isEmpty() || Config.dbPass == null)) {
            this.logger.warn("Please config database");
            Sponge.getGame().getServer().getConsole().sendMessage(TextSerializers.FORMATTING_CODE.deserialize("[AurionsVoteListener] &c----------------------"));
            Sponge.getGame().getServer().getConsole().sendMessage(TextSerializers.FORMATTING_CODE.deserialize("[AurionsVoteListener] &cPlease config database"));
            Sponge.getGame().getServer().getConsole().sendMessage(TextSerializers.FORMATTING_CODE.deserialize("[AurionsVoteListener] &c----------------------"));
        } else {
            if (SwitchSQL.datasource != null && !SwitchSQL.datasource.getConnection().isClosed()) {
                SwitchSQL.datasource.getConnection().close();
            }
            this.switchsql.open();
        }
    }

    private void loadCommands(Main main) {
        this.commandManager = new CommandManager(main);
        Sponge.getCommandManager().register((Object)this, (CommandCallable)this.commandManager.listenerCommandSpec, new String[]{"aurions"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)this.commandManager.voteCmd, new String[]{"vote"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)this.commandManager.votetopCmd, new String[]{"votetop"});
    }

    public void sendmessage(String message, String sender) {
        if (sender.equals("console") || sender.equals("Server")) {
            Sponge.getGame().getServer().getConsole().sendMessage(this.formatmessage(message, "", sender));
        } else {
            ((Player)Sponge.getGame().getServer().getPlayer(sender).get()).sendMessage(this.formatmessage(message, "", sender));
        }
    }

    public Text formatmessage(String message, String service, String player) {
        if (message == null) {
            return Text.of((String)"");
        }
        String serviceName = service;
        String playerName = player;
        int votes = 0;
        if (message.contains("<votes>")) {
            votes = this.switchsql.TotalsVote(playerName);
            message = message.replace("<votes>", String.valueOf(votes));
        }
        if (message.indexOf("/") == 0) {
            message = message.substring(1);
        }
        if ((message = message.replace("<servicename>", serviceName).replace("<service>", serviceName).replace("<SERVICE>", serviceName).replace("<name>", playerName).replace("(name)", playerName).replace("<player>", playerName).replace("(player)", playerName).replace("<username>", playerName).replace("(username)", playerName).replace("<name>", playerName).replace("<player>", playerName).replace("<username>", playerName).replace("[name]", playerName).replace("[player]", playerName).replace("[username]", playerName).replace("<AQUA>", "&b").replace("<BLACK>", "&0").replace("<BLUE>", "&9").replace("<DARK_AQUA>", "&3").replace("<DARK_BLUE>", "&1").replace("<DARK_GRAY>", "&8").replace("<DARK_GREEN>", "&2").replace("<DARK_PURPLE>", "&5").replace("<DARK_RED>", "&4").replace("<GOLD>", "&6").replace("<GRAY>", "&7").replace("<GREEN>", "&a").replace("<LIGHT_PURPLE>", "&d").replace("<RED>", "&c").replace("<WHITE>", "&f").replace("<YELLOW>", "&e").replace("<BOLD>", "&l").replace("<ITALIC>", "&o").replace("<MAGIC>", "&k").replace("<RESET>", "&r").replace("<STRIKE>", "&m").replace("<STRIKETHROUGH>", "&m").replace("<UNDERLINE>", "&n").replace("<votes>", String.valueOf(votes))).toLowerCase().contains("http")) {
            String url = "";
            Pattern pattern = Pattern.compile("http(\\S+)");
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                url = matcher.group(0);
            }
            Text text = null;
            try {
                text = TextSerializers.FORMATTING_CODE.deserialize(message).toBuilder().onClick((ClickAction)TextActions.openUrl((URL)new URL(url))).build();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return Text.of((String)"Url False, contact admin");
            }
            return text;
        }
        return TextSerializers.FORMATTING_CODE.deserialize(message);
    }
}

