/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.ceres.blocks;

import galaxyspace.core.registers.items.GSItems;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CeresBlocks
extends Block
implements ISortableBlock,
ITerraformableBlock {
    public static final PropertyEnum<EnumCeresBlocks> BASIC_TYPE = PropertyEnum.func_177709_a((String)"type", EnumCeresBlocks.class);

    public CeresBlocks() {
        super(Material.field_151576_e);
        this.func_149663_c("ceresblocks");
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumCeresBlocks blockBasic : EnumCeresBlocks.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blockBasic.getMeta()));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch (this.func_176201_c(state)) {
            case 2: {
                return GSItems.BASIC;
            }
            case 3: {
                return GCItems.meteoricIronRaw;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return this.func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int bonus = 0;
        if (this.func_176201_c(state) == 3) {
            bonus = 1;
        }
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a(state, random, fortune)) {
            int j = random.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return this.func_149745_a(random) * (j + 1) + bonus;
        }
        return this.func_149745_a(random) + bonus;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumCeresBlocks.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumCeresBlocks)((Object)state.func_177229_b(BASIC_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE});
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumCeresBlocks.CERES_GRUNT));
    }

    public static enum EnumCeresBlocks implements IStringSerializable
    {
        CERES_GRUNT(0, "ceres_grunt"),
        CERES_SUBGRUNT(1, "ceres_subgrunt"),
        CERES_DOLOMITE_ORE(2, "ceres_dolomite_ore"),
        CERES_METEORICIRON_ORE(3, "ceres_meteoriciron_ore"),
        CERES_DUNGEON_TOP(4, "ceres_dungeon_top"),
        CERES_DUNGEON_FLOOR(5, "ceres_dungeon_floor");

        private final int meta;
        private final String name;
        private static final EnumCeresBlocks[] values;

        private EnumCeresBlocks(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumCeresBlocks byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumCeresBlocks.values();
        }
    }
}

