/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.recipes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import reborncore.api.praescriptum.Utils.LogUtils;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.ingredients.output.FluidStackOutputIngredient;
import reborncore.api.praescriptum.ingredients.output.ItemStackOutputIngredient;
import reborncore.api.praescriptum.ingredients.output.OutputIngredient;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.common.util.ItemUtils;

public class Recipe
implements Serializable {
    private static final long serialVersionUID = 528013385268499955L;
    private final RecipeHandler manager;
    private List<InputIngredient<?>> inputIngredients = new ArrayList();
    private List<OutputIngredient<?>> outputIngredients = new ArrayList();
    private NBTTagCompound metadata;

    public Recipe(RecipeHandler manager) {
        this.manager = manager;
    }

    public Recipe withInput(List<InputIngredient<?>> inputs) {
        this.inputIngredients.addAll(inputs);
        return this;
    }

    public Recipe withInput(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            throw new IllegalArgumentException("Input cannot be empty");
        }
        this.inputIngredients.add(ItemStackInputIngredient.of(itemStack));
        return this;
    }

    public Recipe withInput(String oreDict) {
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict));
        return this;
    }

    public Recipe withInput(String oreDict, int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Input cannot be empty");
        }
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict, amount));
        return this;
    }

    public Recipe withInput(String oreDict, int amount, Integer meta) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Input cannot be empty");
        }
        this.inputIngredients.add(OreDictionaryInputIngredient.of(oreDict, amount, meta));
        return this;
    }

    public Recipe withInput(FluidStack fluidStack) {
        if (fluidStack.amount <= 0) {
            throw new IllegalArgumentException("Input cannot be empty");
        }
        this.inputIngredients.add(FluidStackInputIngredient.of(fluidStack));
        return this;
    }

    public Recipe withOutput(List<OutputIngredient<?>> outputs) {
        this.outputIngredients.addAll(outputs);
        return this;
    }

    public Recipe withOutput(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            throw new IllegalArgumentException("Output cannot be empty");
        }
        this.outputIngredients.add(ItemStackOutputIngredient.of(itemStack));
        return this;
    }

    public Recipe withOutput(FluidStack fluidStack) {
        if (fluidStack.amount <= 0) {
            throw new IllegalArgumentException("Output cannot be empty");
        }
        this.outputIngredients.add(FluidStackOutputIngredient.of(fluidStack));
        return this;
    }

    public Recipe withEnergyCostPerTick(int energyCostPerTick) {
        if (energyCostPerTick < 0) {
            throw new IllegalArgumentException("Energy cost per tick cannot be less than 0");
        }
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74768_a("energyCostPerTick", energyCostPerTick);
        return this;
    }

    public Recipe withOperationDuration(int operationDuration) {
        if (operationDuration < 0) {
            throw new IllegalArgumentException("Operation duration cannot be less than 0");
        }
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74768_a("operationDuration", operationDuration);
        return this;
    }

    public Recipe withMetadata(NBTTagCompound metadata) {
        this.metadata = metadata;
        return this;
    }

    public Recipe withMetadata(String key, int value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74768_a(key, value);
        return this;
    }

    public Recipe withMetadata(String key, short value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74777_a(key, value);
        return this;
    }

    public Recipe withMetadata(String key, byte value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74774_a(key, value);
        return this;
    }

    public Recipe withMetadata(String key, float value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74776_a(key, value);
        return this;
    }

    public Recipe withMetadata(String key, double value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74780_a(key, value);
        return this;
    }

    public Recipe withMetadata(String key, boolean value) {
        if (this.metadata == null) {
            this.metadata = new NBTTagCompound();
        }
        this.metadata.func_74757_a(key, value);
        return this;
    }

    public void register() {
        this.register(false);
    }

    public void register(boolean replace) {
        boolean success = false;
        success = this.manager.addRecipe(this, replace);
        if (!success) {
            LogUtils.LOGGER.warn("Registration failed for input " + this);
        }
    }

    public List<InputIngredient<?>> getInputIngredients() {
        return this.inputIngredients;
    }

    public List<OutputIngredient<?>> getOutputIngredients() {
        return this.outputIngredients;
    }

    public int getEnergyCostPerTick() {
        if (this.metadata == null) {
            return 0;
        }
        return this.metadata.func_74764_b("energyCostPerTick") ? this.metadata.func_74762_e("energyCostPerTick") : 0;
    }

    public int getOperationDuration() {
        if (this.metadata == null) {
            return 0;
        }
        return this.metadata.func_74764_b("operationDuration") ? this.metadata.func_74762_e("operationDuration") : 0;
    }

    public NBTTagCompound getMetadata() {
        return this.metadata;
    }
}

