/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.shop.Shop;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ShopsLogs {
    private static File carrotLogsFolder;

    public static void init(File rootDir) throws IOException {
        carrotLogsFolder = new File(rootDir, "logs");
        carrotLogsFolder.mkdirs();
    }

    public static Optional<String> getLog(UUID shopOwnerUUID) {
        String shopOwner = shopOwnerUUID != null ? shopOwnerUUID.toString() : "server";
        File fileBuy = new File(carrotLogsFolder, shopOwner + ".buy");
        File fileSell = new File(carrotLogsFolder, shopOwner + ".sell");
        File fileTrade = new File(carrotLogsFolder, shopOwner + ".trade");
        if (!(fileBuy.exists() || fileSell.exists() || fileTrade.exists())) {
            return Optional.empty();
        }
        StringBuilder data = new StringBuilder();
        data.append("{\"info\":{");
        data.append("\"dbtime\":{\".sv\":\"timestamp\"}");
        data.append(",\"time\":" + System.currentTimeMillis());
        Optional userStorage = Sponge.getServiceManager().provide(UserStorageService.class);
        if (shopOwnerUUID != null) {
            Optional player = ((UserStorageService)userStorage.get()).get(shopOwnerUUID);
            if (!player.isPresent()) {
                return Optional.empty();
            }
            data.append(",\"player\":\"" + ((User)player.get()).getName() + "\"");
            data.append(",\"playerID\":\"" + ((User)player.get()).getUniqueId().toString() + "\"");
        }
        data.append(",\"motdplain\":\"" + Sponge.getServer().getMotd().toPlain() + "\"");
        data.append(",\"motd\":\"" + TextSerializers.FORMATTING_CODE.serialize(Sponge.getServer().getMotd()) + "\"");
        if (CarrotShop.getEcoService() != null) {
            data.append(",\"currencySymbol\":\"" + TextSerializers.FORMATTING_CODE.serialize(ShopsData.getCurrency().getSymbol()) + "\"");
            data.append(",\"currencySymbolplain\":\"" + ShopsData.getCurrency().getSymbol().toPlain() + "\"");
            data.append(",\"currencyName\":\"" + ShopsData.getCurrency().getName() + "\"");
            data.append(",\"currencyDName\":\"" + TextSerializers.FORMATTING_CODE.serialize(ShopsData.getCurrency().getDisplayName()) + "\"");
            data.append(",\"currencyPDName\":\"" + TextSerializers.FORMATTING_CODE.serialize(ShopsData.getCurrency().getPluralDisplayName()) + "\"");
        }
        data.append("},\"logs\":{");
        data.append("\"buy\":[");
        if (fileBuy.exists()) {
            try {
                data.append(new String(Files.readAllBytes(fileBuy.toPath()), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        data.append("],");
        data.append("\"sell\":[");
        if (fileSell.exists()) {
            try {
                data.append(new String(Files.readAllBytes(fileSell.toPath()), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        data.append("],");
        data.append("\"trade\":[");
        if (fileTrade.exists()) {
            try {
                data.append(new String(Files.readAllBytes(fileTrade.toPath()), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        data.append("]}}");
        return Optional.of(data.toString());
    }

    public static void log(UUID shopOwnerUUID, Player player, String type, Location<World> location, Optional<Float> price, Optional<Currency> currency, Optional<Inventory> itemsA, Optional<Inventory> itemsB) {
        Optional data;
        Optional seller;
        String shopOwner;
        String string = shopOwner = shopOwnerUUID != null ? shopOwnerUUID.toString() : "server";
        if (shopOwnerUUID != null && !(seller = Sponge.getServer().getPlayer(shopOwnerUUID)).isPresent()) {
            ShopsData.soldSomethingOffline(shopOwnerUUID);
        }
        JsonObject newNode = new JsonObject();
        newNode.addProperty("player", player.getName());
        newNode.addProperty("playerID", player.getUniqueId().toString());
        newNode.addProperty("time", (Number)System.currentTimeMillis());
        JsonObject locationNode = new JsonObject();
        locationNode.addProperty("world", ((World)location.getExtent()).getName());
        locationNode.addProperty("worldID", ((World)location.getExtent()).getUniqueId().toString());
        locationNode.addProperty("X", (Number)location.getBlockX());
        locationNode.addProperty("Y", (Number)location.getBlockY());
        locationNode.addProperty("Z", (Number)location.getBlockZ());
        Optional sign = location.getTileEntity();
        if (sign.isPresent() && ((TileEntity)sign.get()).supports(SignData.class) && (data = ((TileEntity)sign.get()).getOrCreate(SignData.class)).isPresent()) {
            locationNode.addProperty("line0", ((Text)((SignData)data.get()).lines().get(0)).toPlain());
            locationNode.addProperty("line1", ((Text)((SignData)data.get()).lines().get(1)).toPlain());
            locationNode.addProperty("line2", ((Text)((SignData)data.get()).lines().get(2)).toPlain());
            locationNode.addProperty("line3", ((Text)((SignData)data.get()).lines().get(3)).toPlain());
        }
        newNode.add("sign", (JsonElement)locationNode);
        if (ShopsData.hasMultipleCurrencies() && currency.isPresent()) {
            JsonObject currencyNode = new JsonObject();
            currencyNode.addProperty("currencySymbol", TextSerializers.FORMATTING_CODE.serialize(currency.get().getSymbol()));
            currencyNode.addProperty("currencySymbolplain", currency.get().getSymbol().toPlain());
            currencyNode.addProperty("currencyName", currency.get().getName());
            currencyNode.addProperty("currencyDName", TextSerializers.FORMATTING_CODE.serialize(currency.get().getDisplayName()));
            currencyNode.addProperty("currencyPDName", TextSerializers.FORMATTING_CODE.serialize(currency.get().getPluralDisplayName()));
            newNode.add("currency", (JsonElement)currencyNode);
        }
        if (price.isPresent()) {
            newNode.addProperty("price", (Number)price.get());
        }
        if (itemsA.isPresent()) {
            newNode.add("items", (JsonElement)ShopsLogs.invToArray(itemsA.get()));
        }
        if (itemsB.isPresent()) {
            newNode.add("items2", (JsonElement)ShopsLogs.invToArray(itemsB.get()));
        }
        try {
            File file = new File(carrotLogsFolder, shopOwner + "." + type);
            if (!file.exists()) {
                file.createNewFile();
                JsonObject firstNode = new JsonObject();
                firstNode.addProperty("init", Boolean.valueOf(true));
                firstNode.addProperty("time", (Number)System.currentTimeMillis());
                Files.write(file.toPath(), firstNode.toString().getBytes(), StandardOpenOption.APPEND);
            }
            Files.write(file.toPath(), ",".getBytes(), StandardOpenOption.APPEND);
            Files.write(file.toPath(), newNode.toString().getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            CarrotShop.getLogger().error(Lang.CONSOLE_ERROR_LOGS.replace("%owner%", shopOwner).replace("%source%", player.getName()).replace("%error%", e.getMessage()));
        }
    }

    private static JsonArray invToArray(Inventory inv) {
        JsonArray array = new JsonArray();
        for (Inventory slot : inv.slots()) {
            if (!slot.peek().isPresent()) continue;
            JsonObject item = new JsonObject();
            item.addProperty("id", ((ItemStack)slot.peek().get()).getType().getId());
            item.addProperty("name", Shop.getItemName((ItemStack)slot.peek().get()).toPlain());
            item.addProperty("quantity", (Number)((ItemStack)slot.peek().get()).getQuantity());
            array.add((JsonElement)item);
        }
        return array;
    }

    public static void generateReport(CommandSource src, UUID target) {
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.REPORT_PREPARE}));
        Task.builder().execute(() -> {
            block7: {
                Optional<String> query = ShopsLogs.getLog(target);
                if (!query.isPresent()) {
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.REPORT_ERROR_DATA}));
                    return;
                }
                String url = "https://carrotshop-ffb97.firebaseio.com/shop.json";
                String charset = StandardCharsets.UTF_8.name();
                HttpURLConnection connection = null;
                try {
                    String line;
                    connection = (HttpURLConnection)new URL(url).openConnection();
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Accept-Charset", charset);
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + charset);
                    OutputStream output = connection.getOutputStream();
                    output.write(query.get().getBytes(charset));
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    JsonElement jelement = new JsonParser().parse(sb.toString());
                    JsonObject jobject = jelement.getAsJsonObject();
                    String reportURL = "http://carrotshop.xyz/" + jobject.get("name").getAsString() + ".htm";
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.split(Lang.REPORT_READY, "%url%", 0), Text.builder((String)reportURL).color(TextColors.DARK_AQUA).onClick((ClickAction)TextActions.openUrl((URL)new URL(reportURL))).build(), TextColors.GOLD, Lang.split(Lang.REPORT_READY, "%url%", 1)}));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    CarrotShop.getLogger().error(Lang.CONSOLE_ERROR_GENERIC.replace("%error%", e.getMessage()));
                    if (connection == null) break block7;
                    try {
                        CarrotShop.getLogger().error(connection.getResponseMessage());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }).async().name("CarrotShop - Report").submit((Object)CarrotShop.getInstance());
    }
}

