/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class InfuserRecipes
extends ProcessorRecipeHandler {
    public InfuserRecipes() {
        super("infuser", 1, 1, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addOxidizingRecipe("ingotThorium", 1000);
        this.addOxidizingRecipe("ingotUranium", 1000);
        this.addOxidizingRecipe("ingotManganese", 1000);
        this.addRecipe("ingotManganeseOxide", InfuserRecipes.fluidStack("oxygen", 1000), "ingotManganeseDioxide", 1.0, 1.0);
        this.addOxidizingRecipe("dustThorium", 1000);
        this.addOxidizingRecipe("dustUranium", 1000);
        this.addOxidizingRecipe("dustManganese", 1000);
        this.addRecipe("dustManganeseOxide", InfuserRecipes.fluidStack("oxygen", 1000), "dustManganeseDioxide", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new Block[]{Blocks.field_150432_aD, Blocks.field_150403_cj}), InfuserRecipes.fluidStack("liquidhelium", 50), NCBlocks.block_ice, 0.2, 0.5);
        this.addRecipe(new ItemStack(NCBlocks.cooler, 1, 0), InfuserRecipes.fluidStack("water", 1000), new ItemStack(NCBlocks.cooler, 1, 1), 1.0, 1.0);
        this.addRecipe(new ItemStack(NCBlocks.cooler, 1, 0), InfuserRecipes.fluidStack("liquidhelium", 1000), new ItemStack(NCBlocks.cooler, 1, 8), 1.0, 1.0);
        this.addRecipe(new ItemStack(NCBlocks.cooler, 1, 0), InfuserRecipes.fluidStack("cryotheum", 2000), new ItemStack(NCBlocks.cooler, 1, 10), 1.0, 1.0);
        this.addRecipe(InfuserRecipes.oreStack("bioplastic", 2), InfuserRecipes.fluidStack("radaway", 250), NCItems.radaway, 1.0, 0.5);
        this.addRecipe(InfuserRecipes.oreStack("bioplastic", 2), InfuserRecipes.fluidStack("radaway_slow", 250), NCItems.radaway_slow, 1.0, 0.5);
        this.addRecipe(NCItems.radaway, InfuserRecipes.fluidStack("redstone", 200), NCItems.radaway_slow, 1.0, 0.5);
        this.addRecipe("emptyFrame", InfuserRecipes.fluidStack("water", 2000), NCBlocks.water_source, 1.0, 1.0);
        this.addRecipe(NCBlocks.water_source, InfuserRecipes.fluidStack("lava", 1000), NCBlocks.cobblestone_generator, 1.0, 1.0);
        this.addRecipe(OreDictHelper.oreExists("blockGlassHardened") ? "blockGlassHardened" : "blockGlass", InfuserRecipes.fluidStack("tritium", 1000), NCBlocks.tritium_lamp, 1.0, 1.0);
        this.addRecipe("sandstone", InfuserRecipes.fluidStack("ender", 250), Blocks.field_150377_bs, 1.0, 1.0);
        for (int meta = 0; meta < 16; ++meta) {
            this.addRecipe(new ItemStack(Blocks.field_192444_dS, 1, meta), InfuserRecipes.fluidStack("water", 1000), new ItemStack(Blocks.field_192443_dR, 1, meta), 0.5, 0.5);
        }
        this.addRecipe("plankWood", InfuserRecipes.fluidStack("creosote", 100), RegistryHelper.blockStackFromRegistry("immersiveengineering:treated_wood"), 0.2, 0.5);
        this.addIngotInfusionRecipes("Electrum", "redstone", 200, "ElectrumFlux", 1.0, 1.0);
        this.addIngotInfusionRecipes("Shibuichi", "redstone", 250, "Signalum", 1.0, 1.0);
        this.addIngotInfusionRecipes("TinSilver", "glowstone", 250, "Lumium", 1.0, 1.0);
        this.addIngotInfusionRecipes("LeadPlatinum", "ender", 250, "Enderium", 1.0, 1.0);
        this.addRecipe(Lists.newArrayList((Object[])new String[]{"dirt", "grass"}), InfuserRecipes.fluidStack("water", 2000), Blocks.field_150435_aG, 1.0, 1.0);
        this.addRecipe("ingotBrick", InfuserRecipes.fluidStack("water", 2000), Items.field_151119_aD, 1.0, 1.0);
        this.addRecipe(Blocks.field_150405_ch, InfuserRecipes.fluidStack("water", 4000), Blocks.field_150435_aG, 4.0, 1.0);
        this.addFertileOxidizingRecipes("Thorium230");
        this.addFissileOxidizingRecipes("Thorium232");
        this.addFissileOxidizingRecipes("Uranium233");
        this.addFissileOxidizingRecipes("Uranium235");
        this.addFertileOxidizingRecipes("Uranium238");
        this.addFissileOxidizingRecipes("Neptunium236");
        this.addFertileOxidizingRecipes("Neptunium237");
        this.addFertileOxidizingRecipes("Plutonium238");
        this.addFissileOxidizingRecipes("Plutonium239");
        this.addFissileOxidizingRecipes("Plutonium241");
        this.addFertileOxidizingRecipes("Plutonium242");
        this.addFertileOxidizingRecipes("Americium241");
        this.addFissileOxidizingRecipes("Americium242");
        this.addFertileOxidizingRecipes("Americium243");
        this.addFissileOxidizingRecipes("Curium243");
        this.addFissileOxidizingRecipes("Curium245");
        this.addFertileOxidizingRecipes("Curium246");
        this.addFissileOxidizingRecipes("Curium247");
        this.addFertileOxidizingRecipes("Berkelium247");
        this.addFissileOxidizingRecipes("Berkelium248");
        this.addFissileOxidizingRecipes("Californium249");
        this.addFertileOxidizingRecipes("Californium250");
        this.addFissileOxidizingRecipes("Californium251");
        this.addFertileOxidizingRecipes("Californium252");
        this.addFuelOxidizingRecipes("TBU");
        this.addFuelOxidizingRecipes("LEU233");
        this.addFuelOxidizingRecipes("HEU233");
        this.addFuelOxidizingRecipes("LEU235");
        this.addFuelOxidizingRecipes("HEU235");
        this.addFuelOxidizingRecipes("LEN236");
        this.addFuelOxidizingRecipes("HEN236");
        this.addFuelOxidizingRecipes("LEP239");
        this.addFuelOxidizingRecipes("HEP239");
        this.addFuelOxidizingRecipes("LEP241");
        this.addFuelOxidizingRecipes("HEP241");
        this.addFuelOxidizingRecipes("LEA242");
        this.addFuelOxidizingRecipes("HEA242");
        this.addFuelOxidizingRecipes("LECm243");
        this.addFuelOxidizingRecipes("HECm243");
        this.addFuelOxidizingRecipes("LECm245");
        this.addFuelOxidizingRecipes("HECm245");
        this.addFuelOxidizingRecipes("LECm247");
        this.addFuelOxidizingRecipes("HECm247");
        this.addFuelOxidizingRecipes("LEB248");
        this.addFuelOxidizingRecipes("HEB248");
        this.addFuelOxidizingRecipes("LECf249");
        this.addFuelOxidizingRecipes("HECf249");
        this.addFuelOxidizingRecipes("LECf251");
        this.addFuelOxidizingRecipes("HECf251");
    }

    public void addOxidizingRecipe(String name, int oxygenAmount) {
        this.addRecipe(name, InfuserRecipes.fluidStack("oxygen", oxygenAmount), name + "Oxide", 1.0, 1.0);
    }

    public void addFertileOxidizingRecipes(String name) {
        this.addRecipe("ingot" + name + "Base", InfuserRecipes.fluidStack("oxygen", 400), "ingot" + name + "Oxide", 0.5, 1.0);
        this.addRecipe("nugget" + name, InfuserRecipes.fluidStack("oxygen", 50), "nugget" + name + "Oxide", 0.05555555555555555, 1.0);
    }

    public void addFissileOxidizingRecipes(String name) {
        this.addRecipe("ingot" + name, InfuserRecipes.fluidStack("oxygen", 400), "ingot" + name + "Oxide", 0.5, 1.0);
        this.addRecipe("nugget" + name, InfuserRecipes.fluidStack("oxygen", 50), "nugget" + name + "Oxide", 0.05555555555555555, 1.0);
    }

    public void addFuelOxidizingRecipes(String name) {
        this.addRecipe("fuel" + name, InfuserRecipes.fluidStack("oxygen", 4000), "fuel" + name + "Oxide", 2.0, 2.0);
        this.addRecipe("fuelRod" + name, InfuserRecipes.fluidStack("oxygen", 4000), "fuelRod" + name + "Oxide", 2.0, 2.0);
        this.addRecipe("depletedFuel" + name, InfuserRecipes.fluidStack("oxygen", 3200), "depletedFuel" + name + "Oxide", 2.0, 2.0);
        this.addRecipe("depletedFuelRod" + name, InfuserRecipes.fluidStack("oxygen", 3200), "depletedFuelRod" + name + "Oxide", 2.0, 2.0);
    }

    public void addIngotInfusionRecipes(String in, String fluid, int amount, String out, double time, double power) {
        this.addRecipe("ingot" + in, InfuserRecipes.fluidStack(fluid, amount), "ingot" + out, time, power);
        this.addRecipe("dust" + in, InfuserRecipes.fluidStack(fluid, amount), "dust" + out, time, power);
    }
}

