/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge;

import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.util.BridgeCommandSource;
import com.magitechserver.magibridge.util.FormatType;
import com.magitechserver.magibridge.util.GroupUtil;
import com.magitechserver.magibridge.util.ReplacerUtil;
import com.magitechserver.magibridge.util.Webhooking;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Tuple;

public class DiscordHandler {
    private static final int MESSAGE_SIZE_LIMIT = 2000;
    private static Queue<Tuple<String, String>> messageQueue;
    private static boolean initialized;
    private static Task messageSendingTask;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        messageQueue = new ConcurrentLinkedQueue<Tuple<String, String>>();
        messageSendingTask = Task.builder().execute(() -> {
            Tuple<String, String> message;
            if (messageQueue.isEmpty()) {
                return;
            }
            HashMap<Object, ArrayList<Object>> groupedMessages = new HashMap<Object, ArrayList<Object>>();
            int size = messageQueue.size();
            for (int i = 0; i < size && (message = messageQueue.poll()) != null; ++i) {
                ArrayList<Object> messageGroup = (ArrayList<Object>)groupedMessages.get(message.getFirst());
                if (messageGroup == null) {
                    messageGroup = new ArrayList<Object>();
                }
                messageGroup.add(message.getSecond());
                groupedMessages.put(message.getFirst(), messageGroup);
            }
            for (Map.Entry collectedMessages : groupedMessages.entrySet()) {
                String channel = (String)collectedMessages.getKey();
                StringBuffer messageBuffer = new StringBuffer("```\n");
                for (String message2 : (List)collectedMessages.getValue()) {
                    if (messageBuffer.length() + message2.length() + 1 < 1990) {
                        messageBuffer.append(message2).append("\n");
                    } else {
                        messageBuffer.append("\n```");
                        DiscordHandler.sendMessageToChannel(channel, messageBuffer.toString());
                        messageBuffer = new StringBuffer("\n```").append(message2);
                    }
                    if (messageBuffer.length() <= 4) continue;
                    messageBuffer.append("\n```");
                    DiscordHandler.sendMessageToChannel(channel, messageBuffer.toString());
                }
            }
        }).async().delay(3L, TimeUnit.SECONDS).interval(2L, TimeUnit.SECONDS).name("MagiBridge - Send Messages to Discord").submit((Object)MagiBridge.getInstance());
    }

    public static void close() {
        if (!initialized) {
            return;
        }
        messageSendingTask.cancel();
        messageQueue.clear();
        initialized = false;
    }

    public static void queueMessageToChannel(String channel, String message) {
        messageQueue.offer((Tuple<String, String>)Tuple.of((Object)channel, (Object)message));
    }

    public static void sendMessageToChannel(String channel, String message) {
        if (!DiscordHandler.isValidChannel(channel)) {
            return;
        }
        message = DiscordHandler.translateEmojis(message, MagiBridge.jda.getTextChannelById(channel).getGuild());
        ArrayList usersMentioned = new ArrayList();
        Arrays.stream(message.split(" ")).filter(word -> word.startsWith("@")).forEach(mention -> usersMentioned.add(mention.substring(1)));
        if (!usersMentioned.isEmpty()) {
            for (String user : usersMentioned) {
                List<User> users = MagiBridge.jda.getUsersByName(user, true);
                if (users.isEmpty()) continue;
                message = message.replaceAll("@" + user, "<@" + users.get(0).getId() + ">");
            }
        }
        if (message.isEmpty()) {
            return;
        }
        MagiBridge.jda.getTextChannelById(channel).sendMessage(message.replaceAll("&([0-9a-fA-FlLkKrR])", "")).queue();
    }

    public static void sendMessageToChannel(String channel, String message, long deleteTime) {
        if (!DiscordHandler.isValidChannel(channel)) {
            return;
        }
        if ((message = DiscordHandler.translateEmojis(message, MagiBridge.jda.getTextChannelById(channel).getGuild())).isEmpty()) {
            return;
        }
        MagiBridge.jda.getTextChannelById(channel).sendMessage(message.replaceAll("&([0-9a-fA-FlLkKrR])", "")).queue(m -> m.delete().queueAfter(deleteTime, TimeUnit.SECONDS));
    }

    private static boolean isValidChannel(String channel) {
        if (MagiBridge.jda == null) {
            return false;
        }
        if (MagiBridge.jda.getStatus() != JDA.Status.CONNECTED) {
            return false;
        }
        if (MagiBridge.jda.getTextChannelById(channel) == null) {
            MagiBridge.getLogger().error("The channel " + channel + " defined in the config isn't a valid Discord Channel ID!");
            MagiBridge.getLogger().error("Replace it with a valid one then reload the plugin!");
            return false;
        }
        return true;
    }

    public static void sendMessageToDiscord(String channel, FormatType format, Map<String, String> placeholders, boolean removeEveryone, long deleteTime, boolean withWebhook, boolean withMentions) {
        if (!DiscordHandler.isValidChannel(channel)) {
            return;
        }
        String rawFormat = format.get();
        String message = ReplacerUtil.replaceEach(rawFormat, placeholders);
        message = message.replaceAll("&([0-9a-fA-FlLkKrR])", "");
        message = DiscordHandler.translateEmojis(message, MagiBridge.jda.getTextChannelById(channel).getGuild());
        if (removeEveryone) {
            message = message.replace("@everyone", "");
            message = message.replace("@here", "");
        }
        ArrayList usersMentioned = new ArrayList();
        Arrays.stream(message.split(" ")).filter(word -> word.startsWith("@")).forEach(usersMentioned::add);
        if (!usersMentioned.isEmpty() && withMentions) {
            for (String mention : usersMentioned) {
                ArrayList users = new ArrayList();
                MagiBridge.jda.getGuilds().forEach(guild -> guild.getMembers().stream().filter(m -> m.getEffectiveName().equalsIgnoreCase(mention)).forEach(users::add));
                List<Role> roles = MagiBridge.jda.getRolesByName(mention, true);
                if (!users.isEmpty()) {
                    message = message.replace(mention, ((Member)users.get(0)).getAsMention().replace("!", ""));
                }
                if (roles.isEmpty()) continue;
                message = message.replace(mention, roles.get(0).getAsMention());
            }
        }
        if (deleteTime > 0L) {
            MagiBridge.jda.getTextChannelById(channel).sendMessage(message).queue(m -> m.delete().queueAfter(deleteTime, TimeUnit.SECONDS));
        } else if (MagiBridge.getConfig().CHANNELS.USE_WEBHOOKS && withWebhook) {
            message = ReplacerUtil.replaceEach(placeholders.get("%message%"), placeholders);
            message = DiscordHandler.translateEmojis(message, MagiBridge.jda.getTextChannelById(channel).getGuild());
            if (removeEveryone) {
                message = message.replace("@everyone", "");
                message = message.replace("@here", "");
            }
            if (message.isEmpty()) {
                return;
            }
            Webhooking.sendWebhookMessage(ReplacerUtil.replaceEach(MagiBridge.getConfig().MESSAGES.WEBHOOK_NAME, placeholders), placeholders.get("%player%"), message, channel);
        } else {
            if (message.isEmpty()) {
                return;
            }
            MagiBridge.jda.getTextChannelById(channel).sendMessage(message).queue();
        }
    }

    public static void sendMessageToDiscord(String channel, FormatType format, Map<String, String> placeholders, boolean removeEveryone, long deleteTime, boolean withMentions) {
        DiscordHandler.sendMessageToDiscord(channel, format, placeholders, removeEveryone, deleteTime, true, withMentions);
    }

    public static void sendMessageToDiscord(String channel, FormatType format, Map<String, String> placeholders, boolean removeEveryone, long deleteTime) {
        DiscordHandler.sendMessageToDiscord(channel, format, placeholders, removeEveryone, deleteTime, true, true);
    }

    public static void dispatchCommand(MessageReceivedEvent e) {
        String[] args = e.getMessage().getContentDisplay().replace(MagiBridge.getConfig().CHANNELS.CONSOLE_COMMAND + " ", "").split(" ");
        if (!DiscordHandler.canUseCommand(e.getMember(), args[0])) {
            DiscordHandler.sendMessageToChannel(e.getChannel().getId(), MagiBridge.getConfig().MESSAGES.CONSOLE_NO_PERMISSION);
            return;
        }
        String cmd = e.getMessage().getContentDisplay().replace(MagiBridge.getConfig().CHANNELS.CONSOLE_COMMAND + " ", "");
        Sponge.getCommandManager().process((CommandSource)new BridgeCommandSource(e.getChannel().getId(), (CommandSource)Sponge.getServer().getConsole()), cmd);
    }

    public static void dispatchList(Message m, MessageChannel c) {
        String msg;
        StringBuilder players = new StringBuilder();
        boolean shouldDelete = MagiBridge.getConfig().CHANNELS.DELETE_LIST;
        ArrayList<Player> cplayers = new ArrayList<Player>();
        Sponge.getServer().getOnlinePlayers().forEach(p -> {
            if (!p.get(Keys.VANISH).orElse(false).booleanValue()) {
                cplayers.add((Player)p);
            }
        });
        if (cplayers.size() == 0) {
            msg = MagiBridge.getConfig().MESSAGES.NO_PLAYERS;
        } else {
            String listformat = MagiBridge.getConfig().MESSAGES.PLAYER_LIST_NAME;
            if (cplayers.size() >= 1) {
                cplayers.sort(Comparator.comparing(CommandSource::getName));
                for (Player player : cplayers) {
                    players.append(listformat.replace("%player%", player.getName()).replace("%topgroup%", GroupUtil.getHighestGroup(player)).replace("%prefix%", player.getOption("prefix").orElse(""))).append(", ");
                }
                players = new StringBuilder(players.substring(0, players.length() - 2));
            }
            msg = "**Players online (" + Sponge.getServer().getOnlinePlayers().size() + "/" + Sponge.getServer().getMaxPlayers() + "):** ```" + players + "```";
        }
        if (shouldDelete) {
            m.delete().queueAfter(10L, TimeUnit.SECONDS);
            DiscordHandler.sendMessageToChannel(c.getId(), msg, 10L);
        } else {
            DiscordHandler.sendMessageToChannel(c.getId(), msg);
        }
    }

    private static boolean canUseCommand(Member m, String command) {
        if (MagiBridge.getConfig().CHANNELS.COMMANDS_ROLE_OVERRIDE == null) {
            return false;
        }
        if (MagiBridge.getConfig().CHANNELS.COMMANDS_ROLE_OVERRIDE.get(command) != null && MagiBridge.getConfig().CHANNELS.COMMANDS_ROLE_OVERRIDE.get(command).equalsIgnoreCase("everyone")) {
            return true;
        }
        if (m.getRoles().stream().anyMatch(r -> r.getName().equalsIgnoreCase(MagiBridge.getConfig().CHANNELS.CONSOLE_REQUIRED_ROLE))) {
            return true;
        }
        return MagiBridge.getConfig().CHANNELS.COMMANDS_ROLE_OVERRIDE.get(command) != null && m.getRoles().stream().anyMatch(role -> role.getName().equalsIgnoreCase(MagiBridge.getConfig().CHANNELS.COMMANDS_ROLE_OVERRIDE.get(command)));
    }

    private static String translateEmojis(String message, Guild guild) {
        for (Emote emote : guild.getEmotes()) {
            message = message.replace(":" + emote.getName() + ":", emote.getAsMention());
        }
        return message;
    }

    static {
        initialized = false;
    }
}

