/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.magitechserver.magibridge.DiscordHandler;
import com.magitechserver.magibridge.config.ConfigManager;
import com.magitechserver.magibridge.config.categories.ConfigCategory;
import com.magitechserver.magibridge.discord.MessageListener;
import com.magitechserver.magibridge.listeners.AdvancementListener;
import com.magitechserver.magibridge.listeners.ChatListener;
import com.magitechserver.magibridge.listeners.DeathListener;
import com.magitechserver.magibridge.listeners.SpongeChatListener;
import com.magitechserver.magibridge.listeners.SpongeLoginListener;
import com.magitechserver.magibridge.listeners.VanillaChatListener;
import com.magitechserver.magibridge.util.CommandHandler;
import com.magitechserver.magibridge.util.FormatType;
import com.magitechserver.magibridge.util.TopicUpdater;
import java.io.File;
import java.util.Set;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.JDABuilder;
import net.dv8tion.jda.core.entities.Game;
import ninja.leaping.configurate.objectmapping.GuiceObjectMapperFactory;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GamePostInitializationEvent;
import org.spongepowered.api.event.game.state.GameStoppingEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.util.Tristate;

@Plugin(id="magibridge", name="MagiBridge", description="A utility Discord <-> Minecraft chat relay plugin", authors={"Eufranio"}, dependencies={@Dependency(id="ultimatechat", optional=true), @Dependency(id="nucleus", optional=true), @Dependency(id="boop", version="[1.5.0,)", optional=true)})
public class MagiBridge {
    public static MagiBridge instance = null;
    public static ConfigCategory Config;
    public static JDA jda;
    @Inject
    @ConfigDir(sharedRoot=false)
    public File configDir;
    @Inject
    public GuiceObjectMapperFactory factory;
    @Inject
    private Logger logger;
    private TopicUpdater updater;

    public static MagiBridge getInstance() {
        return instance;
    }

    public static ConfigCategory getConfig() {
        return Config;
    }

    @Listener
    public void init(GamePostInitializationEvent event) {
        instance = this;
        this.initStuff(false);
        Sponge.getServiceManager().provide(PermissionService.class).ifPresent(svc -> {
            svc.getDefaults().getTransientSubjectData().setPermission((Set)Sets.newHashSet(), "magibridge.chat", Tristate.TRUE);
            svc.getDefaults().getTransientSubjectData().setPermission((Set)Sets.newHashSet(), "magibridge.mention", Tristate.TRUE);
        });
    }

    @Listener
    public void stop(GameStoppingEvent event) {
        this.stopStuff(false);
    }

    @Listener
    public void reload(GameReloadEvent event) {
        this.stopStuff(true);
        this.initStuff(true);
        this.logger.info("Plugin reloaded successfully!");
    }

    public void initStuff(Boolean fake) {
        this.logger.info("MagiBridge is starting!");
        Config = new ConfigManager(instance).loadConfig();
        Task.builder().async().execute(() -> {
            this.initJDA();
            Task.builder().execute(() -> {
                this.registerListeners();
                if (!MagiBridge.Config.MESSAGES.BOT_GAME_STATUS.isEmpty()) {
                    jda.getPresence().setGame(Game.playing(MagiBridge.Config.MESSAGES.BOT_GAME_STATUS));
                }
                if (!fake.booleanValue()) {
                    DiscordHandler.init();
                    DiscordHandler.sendMessageToChannel(MagiBridge.Config.CHANNELS.MAIN_CHANNEL, MagiBridge.Config.MESSAGES.SERVER_STARTING);
                    CommandHandler.registerBroadcastCommand();
                    if (this.updater != null) {
                        if (this.updater.getState() == Thread.State.NEW) {
                            this.updater.start();
                        } else {
                            this.updater.interrupt();
                            this.updater = new TopicUpdater();
                            this.updater.start();
                        }
                    } else {
                        this.updater = new TopicUpdater();
                        this.updater.start();
                    }
                }
            }).submit((Object)instance);
        }).submit((Object)instance);
    }

    public void stopStuff(Boolean fake) {
        if (!fake.booleanValue() && jda != null) {
            DiscordHandler.sendMessageToChannel(MagiBridge.Config.CHANNELS.MAIN_CHANNEL, MagiBridge.Config.MESSAGES.SERVER_STOPPING);
            DiscordHandler.close();
            if (this.updater != null) {
                this.updater.interrupt();
            }
            jda.getTextChannelById(MagiBridge.Config.CHANNELS.MAIN_CHANNEL).getManager().setTopic(FormatType.OFFLINE_TOPIC_FORMAT.get()).queue();
            jda.shutdown();
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < 10000L && jda != null && jda.getStatus() != JDA.Status.SHUTDOWN) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        this.logger.info("Disconnecting from Discord...");
        if (jda != null && jda.getStatus() != JDA.Status.SHUTDOWN && jda.getStatus() != JDA.Status.SHUTTING_DOWN) {
            jda.shutdownNow();
        }
        Sponge.getEventManager().unregisterPluginListeners((Object)this);
        Sponge.getEventManager().registerListeners((Object)this, (Object)this);
        Config = null;
    }

    private boolean initJDA() {
        try {
            jda = new JDABuilder(AccountType.BOT).setToken(MagiBridge.Config.CORE.BOT_TOKEN).build().awaitReady();
            jda.addEventListener(new MessageListener());
        }
        catch (LoginException e) {
            this.logger.error("ERROR STARTING THE PLUGIN:");
            this.logger.error("THE TOKEN IN THE CONFIG IS INVALID!");
            this.logger.error("You probably didn't set the token yet, edit your config!");
            return false;
        }
        catch (Exception e) {
            this.logger.error("Error connecting to discord. This is NOT a plugin error");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void registerListeners() {
        if (MagiBridge.Config.CHANNELS.USE_NUCLEUS) {
            if (Sponge.getPluginManager().getPlugin("nucleus").isPresent()) {
                Sponge.getEventManager().registerListeners((Object)this, (Object)new SpongeChatListener());
                this.logger.info("Hooking into Nucleus");
            } else {
                this.logger.error(" ");
                this.logger.error(" MagiBridge is configured to hook into Nucleus, but it isn't loaded! Please disable using-nucleus or load Nucleus on your server!");
                this.logger.error(" ");
            }
        } else if (MagiBridge.Config.CHANNELS.USE_UCHAT) {
            if (Sponge.getPluginManager().getPlugin("ultimatechat").isPresent()) {
                Sponge.getEventManager().registerListeners((Object)this, (Object)new ChatListener());
                this.logger.info("Hooking into UltimateChat");
            } else {
                this.logger.error(" ");
                this.logger.error(" MagiBridge is configured to hook into UltimateChat, but it isn't loaded! Please disable using-ultimatechat or load UltimateChat on your server!");
                this.logger.error(" ");
            }
        } else {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new VanillaChatListener());
            this.logger.info(" No Chat Hook enabled, hooking into the vanilla chat system");
            this.logger.info(" Some features may not work, and there will be no staff chat. If you want a more complete chat handling, use either Nucleus or UltimateChat.");
        }
        if (MagiBridge.Config.CORE.DEATH_MESSAGES_ENABLED) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new DeathListener());
        }
        if (MagiBridge.Config.CORE.ADVANCEMENT_MESSAGES_ENABLED) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new AdvancementListener());
        }
        Sponge.getEventManager().registerListeners((Object)this, (Object)new SpongeLoginListener());
    }

    public static Logger getLogger() {
        return MagiBridge.instance.logger;
    }
}

