/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge;

import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.config.categories.Messages;
import com.magitechserver.magibridge.util.FormatType;
import com.magitechserver.magibridge.util.ReplacerUtil;
import flavor.pie.boop.BoopableChannel;
import io.github.nucleuspowered.nucleus.api.NucleusAPI;
import io.github.nucleuspowered.nucleus.api.service.NucleusStaffChatService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.core.entities.Message;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class NucleusHandler {
    public static void handle(boolean isStaffChannel, FormatType format, Map<String, String> placeholders, boolean hasAttachment, List<Message.Attachment> attachments) {
        Object messageChannel;
        if (!isStaffChannel) {
            messageChannel = Sponge.getPluginManager().getPlugin("boop").isPresent() && MagiBridge.getConfig().CORE.USE_BOOP ? new BoopableChannel(Sponge.getServer().getBroadcastChannel()) : Sponge.getServer().getBroadcastChannel();
        } else {
            messageChannel = ((NucleusStaffChatService)NucleusAPI.getStaffChatService().get()).getStaffChat();
            format = FormatType.DISCORD_TO_SERVER_STAFF_FORMAT;
        }
        String msg = ReplacerUtil.replaceEach(format.get(), placeholders);
        if (messageChannel != null) {
            Text messageAsText = ReplacerUtil.toText(msg);
            Text prefix = Text.of();
            if (MagiBridge.getConfig().MESSAGES.PREFIX.ENABLED) {
                URL url;
                Messages.PrefixCategory category = MagiBridge.getConfig().MESSAGES.PREFIX;
                try {
                    url = new URL(category.LINK);
                }
                catch (MalformedURLException e) {
                    MagiBridge.getLogger().error("Invalid prefix URL! Fix it on your config!");
                    return;
                }
                prefix = ReplacerUtil.toText(category.TEXT).toBuilder().onHover((HoverAction)TextActions.showText((Text)ReplacerUtil.toText(category.HOVER))).onClick((ClickAction)TextActions.openUrl((URL)url)).build();
            }
            if (hasAttachment) {
                messageChannel.send(Text.of((Object[])new Object[]{prefix, messageAsText, NucleusHandler.attachmentBuilder(attachments)}));
            } else {
                messageChannel.send(Text.of((Object[])new Object[]{prefix, messageAsText}));
            }
        }
    }

    public static Text attachmentBuilder(List<Message.Attachment> attachments) {
        LiteralText.Builder hover = Text.builder((String)"Attachments: ").append(new Text[]{Text.NEW_LINE});
        for (Message.Attachment attachment : attachments) {
            hover.append(new Text[]{Text.of((Object[])new Object[]{attachment.getFileName(), Text.NEW_LINE})});
        }
        hover.append(new Text[]{Text.of((Object[])new Object[]{TextColors.AQUA, "Click to open this attachment!"})});
        URL url = null;
        try {
            url = new URL(attachments.get(0).getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return Text.builder().append(new Text[]{ReplacerUtil.toText(MagiBridge.getConfig().MESSAGES.ATTACHMENT_NAME)}).onHover((HoverAction)TextActions.showText((Text)hover.build())).onClick((ClickAction)(url != null ? TextActions.openUrl((URL)url) : null)).build();
    }

    public static String getNick(Player p) {
        if (!Sponge.getPluginManager().getPlugin("nucleus").isPresent()) {
            return p.getName();
        }
        return NucleusAPI.getNicknameService().map(s -> s.getNickname((User)p).map(Text::toPlain).orElse(null)).orElse(p.getName());
    }
}

