/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge;

import br.net.fabiozumbi12.UltimateChat.Sponge.UCChannel;
import br.net.fabiozumbi12.UltimateChat.Sponge.UChat;
import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.NucleusHandler;
import com.magitechserver.magibridge.config.categories.Messages;
import com.magitechserver.magibridge.util.FormatType;
import com.magitechserver.magibridge.util.ReplacerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.core.entities.Message;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;

public class UCHandler {
    public static UCChannel getChannelByCaseInsensitiveName(String name) {
        for (UCChannel channel : UChat.get().getAPI().getChannels()) {
            if (!channel.getName().equalsIgnoreCase(name)) continue;
            return channel;
        }
        return null;
    }

    public static void handle(String channel, FormatType format, Map<String, String> placeholders, boolean hasAttachment, List<Message.Attachment> attachments) {
        UCChannel uc;
        String rawFormat = format.get();
        if (MagiBridge.getConfig().CHANNELS.UCHAT.UCHAT_OVERRIDES.get(channel) != null) {
            rawFormat = MagiBridge.getConfig().CHANNELS.UCHAT.UCHAT_OVERRIDES.get(channel);
        }
        if ((uc = UCHandler.getChannelByCaseInsensitiveName(channel)) != null) {
            Text prefix = Text.of();
            if (MagiBridge.getConfig().MESSAGES.PREFIX.ENABLED) {
                URL url;
                Messages.PrefixCategory category = MagiBridge.getConfig().MESSAGES.PREFIX;
                try {
                    url = new URL(category.LINK);
                }
                catch (MalformedURLException e) {
                    MagiBridge.getLogger().error("Invalid prefix URL!");
                    return;
                }
                prefix = ReplacerUtil.toText(category.TEXT).toBuilder().onHover((HoverAction)TextActions.showText((Text)ReplacerUtil.toText(category.HOVER))).onClick((ClickAction)TextActions.openUrl((URL)url)).build();
            }
            Text message = ReplacerUtil.toText(ReplacerUtil.replaceEach(rawFormat, placeholders));
            Text attachment = Text.of();
            if (hasAttachment) {
                attachment = NucleusHandler.attachmentBuilder(attachments);
            }
            uc.sendMessage(Sponge.getServer().getConsole(), Text.of((Object[])new Object[]{prefix, message, attachment}), true);
        }
    }
}

