/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.config;

import com.google.common.reflect.TypeToken;
import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.config.categories.ConfigCategory;
import java.io.File;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;

public class ConfigManager {
    public ConfigCategory root;
    private String HEADER = " MagiBridge, by Eufranio\n\n You can use the following placeholders on the DISCORD -> MC formats:\n     %user% -> user who sent the message in the Discord channel\n     %message% -> message that was sent to the channel\n     %toprole% -> name of the highest role/rank of the user in the Discord server\n     %toprolecolor% -> color of the user's role, according to the replacer at the bottom of this config\n\n You can use the following placeholder on the MC -> DISCORD formats:\n     %player% -> player who sent the message in the chat channel\n     %prefix% -> prefix of the player that sent the message. Usually set via permission plugins\n     %topgroup% -> name of the highest group of the player who sent the message\n     %nick% -> nickname of the player. If no nick is assigned to the player, his name will be used instead\n     %message% -> message that the player sent";
    private MagiBridge instance;

    public ConfigManager(MagiBridge instance) {
        this.instance = instance;
        if (!instance.configDir.exists()) {
            instance.configDir.mkdirs();
        }
    }

    public ConfigCategory get() {
        return this.root;
    }

    public ConfigCategory loadConfig() {
        try {
            File file = new File(this.instance.configDir, "MagiBridge.conf");
            if (!file.exists()) {
                file.createNewFile();
            }
            HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(file)).build();
            CommentedConfigurationNode config = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults().setObjectMapperFactory((ObjectMapperFactory)this.instance.factory).setShouldCopyDefaults(true).setHeader(this.HEADER));
            this.root = (ConfigCategory)config.getValue(TypeToken.of(ConfigCategory.class), (Object)new ConfigCategory());
            loader.save((ConfigurationNode)config);
            return this.root;
        }
        catch (Exception e) {
            MagiBridge.getLogger().error("Could not load config.", (Throwable)e);
            return this.root;
        }
    }
}

