/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.discord;

import com.magitechserver.magibridge.DiscordHandler;
import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.NucleusHandler;
import com.magitechserver.magibridge.UCHandler;
import com.magitechserver.magibridge.VanillaHandler;
import com.magitechserver.magibridge.events.MBMessageEvent;
import com.magitechserver.magibridge.util.FormatType;
import com.magitechserver.magibridge.util.ReplacerUtil;
import com.vdurmont.emoji.EmojiParser;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import net.dv8tion.jda.core.hooks.ListenerAdapter;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.scheduler.Task;

public class MessageListener
extends ListenerAdapter {
    @Override
    public void onMessageReceived(MessageReceivedEvent e) {
        Task.builder().execute(task -> this.process(e)).submit((Object)MagiBridge.getInstance());
    }

    private void process(MessageReceivedEvent e) {
        FormatType format;
        boolean hasAttachment;
        Role firstRole;
        MBMessageEvent messageEvent = new MBMessageEvent(e.getGuild(), Sponge.getCauseStackManager().getCurrentCause(), e.getMessage());
        Sponge.getEventManager().post((Event)messageEvent);
        if (messageEvent.isCancelled()) {
            return;
        }
        String channelID = e.getChannel().getId();
        String message = this.processMessage(e);
        if (!this.isValidMessage(e)) {
            return;
        }
        if (message.isEmpty() && e.getMessage().getAttachments().isEmpty()) {
            return;
        }
        if (!this.isListenableChannel(channelID)) {
            return;
        }
        boolean canUseColors = MagiBridge.getConfig().CHANNELS.COLOR_REQUIRED_ROLE.equalsIgnoreCase("everyone") || e.getMember().getRoles().stream().anyMatch(r -> r.getName().equalsIgnoreCase(MagiBridge.getConfig().CHANNELS.COLOR_REQUIRED_ROLE));
        String name = e.getMember().getEffectiveName();
        String toprole = e.getMember().getRoles().size() >= 1 ? e.getMember().getRoles().get(0).getName() : MagiBridge.getConfig().MESSAGES.NO_ROLE_PLACEHOLDER;
        Map<String, String> colors = MagiBridge.getConfig().COLORS.COLORS;
        String toprolecolor = "99AAB5";
        if (e.getMember().getRoles().size() >= 1 && (firstRole = e.getMember().getRoles().get(0)).getColor() != null) {
            String hex = Integer.toHexString(firstRole.getColor().getRGB()).toUpperCase();
            if (hex.length() == 8) {
                hex = hex.substring(2);
            }
            if (colors.containsKey(hex)) {
                toprolecolor = colors.get(hex);
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%user%", name);
        placeholders.put("%message%", canUseColors ? message : message.replaceAll("&([0-9a-fA-FlLkKrR])", "").replaceAll("\u00a7([0-9a-fA-FlLkKrR])", ""));
        placeholders.put("%toprole%", toprole);
        placeholders.put("%toprolecolor%", toprolecolor);
        boolean bl = hasAttachment = e.getMessage().getAttachments().size() >= 1;
        if (message.startsWith(MagiBridge.getConfig().CHANNELS.CONSOLE_COMMAND) && this.isListenableChannel(channelID)) {
            DiscordHandler.dispatchCommand(e);
            return;
        }
        if (message.equalsIgnoreCase(MagiBridge.getConfig().CHANNELS.LIST_COMMAND) && this.isListenableChannel(channelID)) {
            DiscordHandler.dispatchList(e.getMessage(), e.getChannel());
            return;
        }
        if (MagiBridge.getConfig().CHANNELS.USE_UCHAT && !MagiBridge.getConfig().CHANNELS.USE_NUCLEUS) {
            String chatChannel = MagiBridge.getConfig().CHANNELS.UCHAT.UCHAT_CHANNELS.get(channelID);
            FormatType format2 = FormatType.DISCORD_TO_SERVER_FORMAT;
            if (chatChannel != null) {
                UCHandler.handle(chatChannel, format2, placeholders, hasAttachment, e.getMessage().getAttachments());
            }
        }
        if (MagiBridge.getConfig().CHANNELS.USE_NUCLEUS && !MagiBridge.getConfig().CHANNELS.USE_UCHAT) {
            format = FormatType.DISCORD_TO_SERVER_FORMAT;
            boolean isStaffChannel = channelID.equals(MagiBridge.getConfig().CHANNELS.NUCLEUS.STAFF_CHANNEL);
            NucleusHandler.handle(isStaffChannel, format, placeholders, hasAttachment, e.getMessage().getAttachments());
        }
        if (!MagiBridge.getConfig().CHANNELS.USE_NUCLEUS && !MagiBridge.getConfig().CHANNELS.USE_UCHAT) {
            format = FormatType.DISCORD_TO_SERVER_FORMAT;
            boolean isStaffChannel = channelID.equals(MagiBridge.getConfig().CHANNELS.NUCLEUS.STAFF_CHANNEL);
            VanillaHandler.handle(isStaffChannel, format, placeholders);
        }
    }

    private boolean isListenableChannel(String channel) {
        if (MagiBridge.getConfig().CHANNELS.USE_UCHAT && MagiBridge.getConfig().CHANNELS.UCHAT.UCHAT_CHANNELS.containsKey(channel)) {
            return true;
        }
        if (MagiBridge.getConfig().CHANNELS.USE_NUCLEUS && (MagiBridge.getConfig().CHANNELS.NUCLEUS.GLOBAL_CHANNEL.equals(channel) || MagiBridge.getConfig().CHANNELS.NUCLEUS.STAFF_CHANNEL.equals(channel))) {
            return true;
        }
        return MagiBridge.getConfig().CHANNELS.MAIN_CHANNEL.equals(channel);
    }

    private String processMessage(MessageReceivedEvent e) {
        String message = e.getMessage().getContentStripped();
        if (e.getAuthor().getId().equals(e.getJDA().getSelfUser().getId()) || e.getAuthor().isFake()) {
            return "";
        }
        if (message == null && e.getMessage().getAttachments().size() == 0 || message.trim().isEmpty() && e.getMessage().getAttachments().size() == 0) {
            return "";
        }
        if (MagiBridge.getConfig().CORE.CUT_MESSAGES && message.length() > 120) {
            message = message.substring(0, 120);
        }
        if (message.startsWith("```")) {
            message = message.substring(0, message.length() - 3).substring(3);
        }
        if (message.startsWith("`")) {
            message = message.substring(0, message.length() - 1).substring(1);
        }
        return ReplacerUtil.replaceEach(EmojiParser.parseToAliases(message), MagiBridge.getConfig().REPLACER.REPLACER);
    }

    private boolean isValidMessage(MessageReceivedEvent e) {
        String message = e.getMessage().getContentStripped();
        if (e.getAuthor().getId().equals(e.getJDA().getSelfUser().getId()) || e.getAuthor().isFake()) {
            return false;
        }
        return (message != null || e.getMessage().getAttachments().size() != 0) && (!message.trim().isEmpty() || e.getMessage().getAttachments().size() != 0);
    }
}

