/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.listeners;

import br.net.fabiozumbi12.UltimateChat.Sponge.API.SendChannelMessageEvent;
import com.magitechserver.magibridge.DiscordHandler;
import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.NucleusHandler;
import com.magitechserver.magibridge.util.FormatType;
import com.magitechserver.magibridge.util.GroupUtil;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;

public class ChatListener {
    @Listener
    public void onMessage(SendChannelMessageEvent e) {
        Player p;
        if (!e.getSender().hasPermission("magibridge.chat")) {
            return;
        }
        if (e.getChannel() == null) {
            return;
        }
        String channel = this.getKey(e.getChannel().getName().toLowerCase());
        if (channel == null) {
            return;
        }
        Player player = p = e.getSender() instanceof Player ? (Player)e.getSender() : null;
        if (p != null && MagiBridge.getConfig().CORE.HIDE_VANISHED_CHAT && p.get(Keys.VANISH).orElse(false).booleanValue()) {
            return;
        }
        FormatType format = FormatType.SERVER_TO_DISCORD_FORMAT;
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%prefix%", e.getSender().getOption("prefix").orElse(""));
        placeholders.put("%player%", e.getSender().getName());
        placeholders.put("%message%", e.getMessage().toPlain());
        placeholders.put("%topgroup%", p != null ? GroupUtil.getHighestGroup(p) : "");
        if (p != null && Sponge.getPluginManager().getPlugin("nucleus").isPresent()) {
            placeholders.put("%nick%", NucleusHandler.getNick(p));
        }
        boolean removeEveryone = !e.getSender().hasPermission("magibridge.everyone");
        DiscordHandler.sendMessageToDiscord(channel, format, placeholders, removeEveryone, 0L, e.getSender().hasPermission("magibridge.mention"));
    }

    private String getKey(String value) {
        for (Map.Entry<String, String> values : MagiBridge.getConfig().CHANNELS.UCHAT.UCHAT_CHANNELS.entrySet()) {
            if (!value.equals(values.getValue().toLowerCase())) continue;
            return values.getKey();
        }
        return null;
    }
}

