/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.util;

import com.magitechserver.magibridge.DiscordHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.Tristate;

public class BridgeCommandSource
implements CommandSource {
    private CommandSource actualSource;
    private String channel;

    public BridgeCommandSource(String channel, CommandSource actualSource) {
        this.channel = channel;
        this.actualSource = actualSource;
    }

    public void sendMessage(Text message) {
        String plain = message.toPlain();
        if ("".equals(plain) || plain.trim().isEmpty()) {
            return;
        }
        DiscordHandler.queueMessageToChannel(this.channel, plain);
    }

    public boolean isSubjectDataPersisted() {
        return this.actualSource.isSubjectDataPersisted();
    }

    public SubjectReference asSubjectReference() {
        return this.actualSource.asSubjectReference();
    }

    public void sendMessages(Iterable<Text> messages) {
        messages.forEach(this::sendMessage);
    }

    public void sendMessages(Text ... messages) {
        Arrays.stream(messages).forEach(this::sendMessage);
    }

    public String getName() {
        return this.actualSource.getName();
    }

    public MessageChannel getMessageChannel() {
        return this.actualSource.getMessageChannel();
    }

    public void setMessageChannel(MessageChannel channel) {
        this.actualSource.setMessageChannel(channel);
    }

    public Optional<CommandSource> getCommandSource() {
        return this.actualSource.getCommandSource();
    }

    public SubjectCollection getContainingCollection() {
        return this.actualSource.getContainingCollection();
    }

    public SubjectData getSubjectData() {
        return this.actualSource.getSubjectData();
    }

    public SubjectData getTransientSubjectData() {
        return this.actualSource.getTransientSubjectData();
    }

    public boolean hasPermission(Set<Context> contexts, String permission) {
        return this.actualSource.hasPermission(contexts, permission);
    }

    public boolean hasPermission(String permission) {
        return this.actualSource.hasPermission(permission);
    }

    public Tristate getPermissionValue(Set<Context> contexts, String permission) {
        return this.actualSource.getPermissionValue(contexts, permission);
    }

    public boolean isChildOf(SubjectReference parent) {
        return this.actualSource.isChildOf(parent);
    }

    public boolean isChildOf(Set<Context> contexts, SubjectReference parent) {
        return this.actualSource.isChildOf(contexts, parent);
    }

    public List<SubjectReference> getParents() {
        return this.actualSource.getParents();
    }

    public List<SubjectReference> getParents(Set<Context> contexts) {
        return this.actualSource.getParents(contexts);
    }

    public Optional<String> getOption(Set<Context> contexts, String key) {
        return this.actualSource.getOption(contexts, key);
    }

    public String getIdentifier() {
        return this.actualSource.getIdentifier();
    }

    public Set<Context> getActiveContexts() {
        return this.actualSource.getActiveContexts();
    }
}

