/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.util;

import com.magitechserver.magibridge.MagiBridge;
import net.dv8tion.jda.core.entities.TextChannel;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class CommandHandler {
    public static void registerBroadcastCommand() {
        CommandSpec cs = CommandSpec.builder().description((Text)Text.of((String)"Broadcasts a message to the specified Discord channel name")).permission("magibridge.admin.broadcast").arguments(new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"channel"))), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"message"))}).executor(new CommandExecutor(){

            public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
                if (args.getOne("channel").isPresent() && args.getOne("message").isPresent()) {
                    String channel = (String)args.getOne("channel").get();
                    String message = (String)args.getOne("message").get();
                    for (TextChannel discordChannel : MagiBridge.jda.getTextChannels()) {
                        if (!discordChannel.getName().equals(channel)) continue;
                        for (TextChannel ch : MagiBridge.jda.getTextChannelsByName(channel, true)) {
                            ch.sendMessage(message).queue();
                        }
                    }
                    src.sendMessage((Text)Text.builder((String)"Message sent!").color(TextColors.GREEN).build());
                    return CommandResult.success();
                }
                src.sendMessage((Text)Text.builder((String)"Could not send message! Are you sure the channel exists?").color(TextColors.RED).build());
                return CommandResult.empty();
            }
        }).build();
        Sponge.getCommandManager().register((Object)MagiBridge.getInstance(), (CommandCallable)cs, new String[]{"mbroadcast", "mb", "mbc"});
    }
}

