/*
 * Decompiled with CFR 0.152.
 */
package com.magitechserver.magibridge.util;

import com.magitechserver.magibridge.MagiBridge;
import com.magitechserver.magibridge.util.FormatType;
import java.lang.management.ManagementFactory;
import net.dv8tion.jda.core.JDA;
import org.spongepowered.api.Sponge;

public class TopicUpdater
extends Thread {
    public TopicUpdater() {
        this.setName("MagiBridge Topic Updater");
    }

    @Override
    public void run() {
        while (true) {
            if (MagiBridge.getConfig().CORE.ENABLE_UPDATER && MagiBridge.jda.getStatus() == JDA.Status.CONNECTED) {
                String topic = FormatType.TOPIC_FORMAT.get().replace("%players%", Integer.valueOf(Sponge.getServer().getOnlinePlayers().size()).toString()).replace("%maxplayers%", Integer.valueOf(Sponge.getServer().getMaxPlayers()).toString()).replace("%tps%", Long.valueOf(Math.round(Sponge.getServer().getTicksPerSecond())).toString()).replace("%daysonline%", Long.valueOf(ManagementFactory.getRuntimeMXBean().getUptime() / 86400000L).toString()).replace("%hoursonline%", Long.valueOf(ManagementFactory.getRuntimeMXBean().getUptime() / 3600000L % 24L).toString()).replace("%minutesonline%", Long.valueOf(ManagementFactory.getRuntimeMXBean().getUptime() / 60000L % 60L).toString());
                try {
                    if (MagiBridge.jda.getTextChannelById(MagiBridge.getConfig().CHANNELS.MAIN_CHANNEL) == null) {
                        MagiBridge.getLogger().error("The main-discord-channel is INVALID, replace it with a valid one and restart the server!");
                        continue;
                    }
                    MagiBridge.jda.getTextChannelById(MagiBridge.getConfig().CHANNELS.MAIN_CHANNEL).getManager().setTopic(topic).queue();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
            int interval = MagiBridge.getConfig().CORE.UPDATER_INTERVAL * 1000;
            try {
                Thread.sleep(interval < 10000 ? 10000L : (long)interval);
                continue;
            }
            catch (InterruptedException e) {
                MagiBridge.getLogger().error("The topic updater was interrupted!");
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

