/*
 * Decompiled with CFR 0.152.
 */
package magibridge.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Collection;
import magibridge.org.apache.http.Header;
import magibridge.org.apache.http.HttpException;
import magibridge.org.apache.http.HttpRequest;
import magibridge.org.apache.http.HttpRequestInterceptor;
import magibridge.org.apache.http.annotation.Immutable;
import magibridge.org.apache.http.protocol.HttpContext;
import magibridge.org.apache.http.util.Args;

@Immutable
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

