/*
 * Decompiled with CFR 0.152.
 */
package magibridge.org.apache.http.client.protocol;

import java.io.IOException;
import magibridge.org.apache.http.HttpEntity;
import magibridge.org.apache.http.HttpEntityEnclosingRequest;
import magibridge.org.apache.http.HttpException;
import magibridge.org.apache.http.HttpRequest;
import magibridge.org.apache.http.HttpRequestInterceptor;
import magibridge.org.apache.http.HttpVersion;
import magibridge.org.apache.http.ProtocolVersion;
import magibridge.org.apache.http.annotation.Immutable;
import magibridge.org.apache.http.client.config.RequestConfig;
import magibridge.org.apache.http.client.protocol.HttpClientContext;
import magibridge.org.apache.http.protocol.HttpContext;
import magibridge.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

