/*
 * Decompiled with CFR 0.152.
 */
package magibridge.org.apache.http.impl.nio.codecs;

import java.io.IOException;
import magibridge.org.apache.http.Header;
import magibridge.org.apache.http.HeaderIterator;
import magibridge.org.apache.http.HttpException;
import magibridge.org.apache.http.HttpMessage;
import magibridge.org.apache.http.annotation.NotThreadSafe;
import magibridge.org.apache.http.message.BasicLineFormatter;
import magibridge.org.apache.http.message.LineFormatter;
import magibridge.org.apache.http.nio.NHttpMessageWriter;
import magibridge.org.apache.http.nio.reactor.SessionOutputBuffer;
import magibridge.org.apache.http.params.HttpParams;
import magibridge.org.apache.http.util.Args;
import magibridge.org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AbstractMessageWriter<T extends HttpMessage>
implements NHttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(64);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(64);
    }

    @Override
    public void reset() {
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

