/*
 * Decompiled with CFR 0.152.
 */
package magibridge.org.apache.http.nio.protocol;

import java.io.IOException;
import magibridge.org.apache.http.ContentTooLongException;
import magibridge.org.apache.http.HttpEntity;
import magibridge.org.apache.http.HttpEntityEnclosingRequest;
import magibridge.org.apache.http.HttpRequest;
import magibridge.org.apache.http.entity.ContentType;
import magibridge.org.apache.http.nio.ContentDecoder;
import magibridge.org.apache.http.nio.IOControl;
import magibridge.org.apache.http.nio.entity.ContentBufferEntity;
import magibridge.org.apache.http.nio.protocol.AbstractAsyncRequestConsumer;
import magibridge.org.apache.http.nio.util.HeapByteBufferAllocator;
import magibridge.org.apache.http.nio.util.SimpleInputBuffer;
import magibridge.org.apache.http.protocol.HttpContext;
import magibridge.org.apache.http.util.Asserts;

public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private volatile HttpRequest request;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onRequestReceived(HttpRequest request) throws IOException {
        this.request = request;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        ((HttpEntityEnclosingRequest)this.request).setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.buf = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

