/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.bot.sharding;

import com.neovisionaries.ws.client.WebSocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.annotations.DeprecatedSince;
import net.dv8tion.jda.annotations.ReplaceWith;
import net.dv8tion.jda.bot.sharding.DefaultShardManager;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.bot.sharding.ThreadPoolProvider;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.SessionController;
import net.dv8tion.jda.core.utils.cache.CacheFlag;
import okhttp3.OkHttpClient;

public class DefaultShardManagerBuilder {
    protected final List<Object> listeners = new ArrayList<Object>();
    protected final List<IntFunction<Object>> listenerProviders = new ArrayList<IntFunction<Object>>();
    protected SessionController sessionController = null;
    protected EnumSet<CacheFlag> cacheFlags = EnumSet.allOf(CacheFlag.class);
    protected boolean enableContext = true;
    protected boolean enableBulkDeleteSplitting = true;
    protected boolean enableShutdownHook = true;
    protected boolean enableVoice = true;
    protected boolean autoReconnect = true;
    protected boolean retryOnTimeout = true;
    protected boolean useShutdownNow = false;
    protected boolean enableCompression = true;
    protected int shardsTotal = -1;
    protected int maxReconnectDelay = 900;
    protected int corePoolSize = 5;
    protected String token = null;
    protected IntFunction<Boolean> idleProvider = null;
    protected IntFunction<OnlineStatus> statusProvider = null;
    protected IntFunction<? extends Game> gameProvider = null;
    protected IntFunction<? extends ConcurrentMap<String, String>> contextProvider = null;
    protected IntFunction<? extends IEventManager> eventManagerProvider = null;
    protected ThreadPoolProvider<? extends ScheduledExecutorService> rateLimitPoolProvider = null;
    protected ThreadPoolProvider<? extends ScheduledExecutorService> gatewayPoolProvider = null;
    protected ThreadPoolProvider<? extends ExecutorService> callbackPoolProvider = null;
    protected Collection<Integer> shards = null;
    protected OkHttpClient.Builder httpClientBuilder = null;
    protected OkHttpClient httpClient = null;
    protected WebSocketFactory wsFactory = null;
    protected IAudioSendFactory audioSendFactory = null;
    protected ThreadFactory threadFactory = null;

    public DefaultShardManagerBuilder setEnabledCacheFlags(EnumSet<CacheFlag> flags) {
        this.cacheFlags = flags == null ? EnumSet.noneOf(CacheFlag.class) : EnumSet.copyOf(flags);
        return this;
    }

    public DefaultShardManagerBuilder setDisabledCacheFlags(EnumSet<CacheFlag> flags) {
        return this.setEnabledCacheFlags(EnumSet.complementOf(flags));
    }

    public DefaultShardManagerBuilder setSessionController(SessionController controller) {
        this.sessionController = controller;
        return this;
    }

    public DefaultShardManagerBuilder setContextMap(IntFunction<? extends ConcurrentMap<String, String>> provider) {
        this.contextProvider = provider;
        if (provider != null) {
            this.enableContext = true;
        }
        return this;
    }

    public DefaultShardManagerBuilder setContextEnabled(boolean enable) {
        this.enableContext = enable;
        return this;
    }

    public DefaultShardManagerBuilder setCompressionEnabled(boolean enable) {
        this.enableCompression = enable;
        return this;
    }

    public DefaultShardManagerBuilder addEventListeners(Object ... listeners) {
        return this.addEventListeners(Arrays.asList(listeners));
    }

    public DefaultShardManagerBuilder addEventListeners(Collection<Object> listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.addAll(listeners);
        return this;
    }

    public DefaultShardManagerBuilder removeEventListeners(Object ... listeners) {
        return this.removeEventListeners(Arrays.asList(listeners));
    }

    public DefaultShardManagerBuilder removeEventListeners(Collection<Object> listeners) {
        Checks.noneNull(listeners, "listeners");
        this.listeners.removeAll(listeners);
        return this;
    }

    public DefaultShardManagerBuilder addEventListenerProvider(IntFunction<Object> listenerProvider) {
        return this.addEventListenerProviders(Collections.singleton(listenerProvider));
    }

    public DefaultShardManagerBuilder addEventListenerProviders(Collection<IntFunction<Object>> listenerProviders) {
        Checks.noneNull(listenerProviders, "listener providers");
        this.listenerProviders.addAll(listenerProviders);
        return this;
    }

    public DefaultShardManagerBuilder removeEventListenerProvider(IntFunction<Object> listenerProvider) {
        return this.removeEventListenerProviders(Collections.singleton(listenerProvider));
    }

    public DefaultShardManagerBuilder removeEventListenerProviders(Collection<IntFunction<Object>> listenerProviders) {
        Checks.noneNull(listenerProviders, "listener providers");
        this.listenerProviders.removeAll(listenerProviders);
        return this;
    }

    public DefaultShardManagerBuilder setAudioEnabled(boolean enabled) {
        this.enableVoice = enabled;
        return this;
    }

    public DefaultShardManagerBuilder setAudioSendFactory(IAudioSendFactory factory) {
        this.audioSendFactory = factory;
        return this;
    }

    public DefaultShardManagerBuilder setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public DefaultShardManagerBuilder setBulkDeleteSplittingEnabled(boolean enabled) {
        this.enableBulkDeleteSplitting = enabled;
        return this;
    }

    public DefaultShardManagerBuilder setCorePoolSize(int size) {
        Checks.positive(size, "Core pool size");
        this.corePoolSize = size;
        return this;
    }

    public DefaultShardManagerBuilder setEnableShutdownHook(boolean enable) {
        this.enableShutdownHook = enable;
        return this;
    }

    @Deprecated
    @DeprecatedSince(value="3.8.1")
    @ReplaceWith(value="setEventManagerProvider((id) -> manager)")
    public DefaultShardManagerBuilder setEventManager(IEventManager manager) {
        Checks.notNull(manager, "manager");
        return this.setEventManagerProvider(id -> manager);
    }

    public DefaultShardManagerBuilder setEventManagerProvider(IntFunction<? extends IEventManager> eventManagerProvider) {
        Checks.notNull(eventManagerProvider, "eventManagerProvider");
        this.eventManagerProvider = eventManagerProvider;
        return this;
    }

    public DefaultShardManagerBuilder setGame(Game game) {
        return this.setGameProvider(id -> game);
    }

    public DefaultShardManagerBuilder setGameProvider(IntFunction<? extends Game> gameProvider) {
        this.gameProvider = gameProvider;
        return this;
    }

    public DefaultShardManagerBuilder setIdle(boolean idle) {
        return this.setIdleProvider(id -> idle);
    }

    public DefaultShardManagerBuilder setIdleProvider(IntFunction<Boolean> idleProvider) {
        this.idleProvider = idleProvider;
        return this;
    }

    public DefaultShardManagerBuilder setStatus(OnlineStatus status) {
        Checks.notNull((Object)status, "status");
        Checks.check(status != OnlineStatus.UNKNOWN, "OnlineStatus cannot be unknown!");
        return this.setStatusProvider(id -> status);
    }

    public DefaultShardManagerBuilder setStatusProvider(IntFunction<OnlineStatus> statusProvider) {
        this.statusProvider = statusProvider;
        return this;
    }

    public DefaultShardManagerBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public DefaultShardManagerBuilder setHttpClientBuilder(OkHttpClient.Builder builder) {
        this.httpClientBuilder = builder;
        return this;
    }

    public DefaultShardManagerBuilder setHttpClient(OkHttpClient client) {
        this.httpClient = client;
        return this;
    }

    public DefaultShardManagerBuilder setRateLimitPool(ScheduledExecutorService pool) {
        return this.setRateLimitPool(pool, pool == null);
    }

    public DefaultShardManagerBuilder setRateLimitPool(ScheduledExecutorService pool, boolean automaticShutdown) {
        return this.setRateLimitPoolProvider((ThreadPoolProvider<? extends ScheduledExecutorService>)(pool == null ? null : new ThreadPoolProviderImpl<ScheduledExecutorService>(pool, automaticShutdown)));
    }

    public DefaultShardManagerBuilder setRateLimitPoolProvider(ThreadPoolProvider<? extends ScheduledExecutorService> provider) {
        this.rateLimitPoolProvider = provider;
        return this;
    }

    public DefaultShardManagerBuilder setGatewayPool(ScheduledExecutorService pool) {
        return this.setGatewayPool(pool, pool == null);
    }

    public DefaultShardManagerBuilder setGatewayPool(ScheduledExecutorService pool, boolean automaticShutdown) {
        return this.setGatewayPoolProvider((ThreadPoolProvider<? extends ScheduledExecutorService>)(pool == null ? null : new ThreadPoolProviderImpl<ScheduledExecutorService>(pool, automaticShutdown)));
    }

    public DefaultShardManagerBuilder setGatewayPoolProvider(ThreadPoolProvider<? extends ScheduledExecutorService> provider) {
        this.gatewayPoolProvider = provider;
        return this;
    }

    public DefaultShardManagerBuilder setCallbackPool(ExecutorService executor) {
        return this.setCallbackPool(executor, executor == null);
    }

    public DefaultShardManagerBuilder setCallbackPool(ExecutorService executor, boolean automaticShutdown) {
        return this.setCallbackPoolProvider((ThreadPoolProvider<? extends ExecutorService>)(executor == null ? null : new ThreadPoolProviderImpl<ExecutorService>(executor, automaticShutdown)));
    }

    public DefaultShardManagerBuilder setCallbackPoolProvider(ThreadPoolProvider<? extends ExecutorService> provider) {
        this.callbackPoolProvider = provider;
        return this;
    }

    public DefaultShardManagerBuilder setMaxReconnectDelay(int maxReconnectDelay) {
        Checks.check(maxReconnectDelay >= 32, "Max reconnect delay must be 32 seconds or greater. You provided %d.", (Object)maxReconnectDelay);
        this.maxReconnectDelay = maxReconnectDelay;
        return this;
    }

    public DefaultShardManagerBuilder setRequestTimeoutRetry(boolean retryOnTimeout) {
        this.retryOnTimeout = retryOnTimeout;
        return this;
    }

    public DefaultShardManagerBuilder setShards(int ... shardIds) {
        Checks.notNull(shardIds, "shardIds");
        for (int id : shardIds) {
            Checks.notNegative(id, "minShardId");
            Checks.check(id < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        }
        this.shards = Arrays.stream(shardIds).boxed().collect(Collectors.toSet());
        return this;
    }

    public DefaultShardManagerBuilder setShards(int minShardId, int maxShardId) {
        Checks.notNegative(minShardId, "minShardId");
        Checks.check(maxShardId < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        Checks.check(minShardId <= maxShardId, "minShardId must be lower than or equal to maxShardId");
        ArrayList<Integer> shards = new ArrayList<Integer>(maxShardId - minShardId + 1);
        for (int i = minShardId; i <= maxShardId; ++i) {
            shards.add(i);
        }
        this.shards = shards;
        return this;
    }

    public DefaultShardManagerBuilder setShards(Collection<Integer> shardIds) {
        Checks.notNull(shardIds, "shardIds");
        for (Integer id : shardIds) {
            Checks.notNegative(id, "minShardId");
            Checks.check(id < this.shardsTotal, "maxShardId must be lower than shardsTotal");
        }
        this.shards = new ArrayList<Integer>(shardIds);
        return this;
    }

    public DefaultShardManagerBuilder setShardsTotal(int shardsTotal) {
        Checks.check(shardsTotal == -1 || shardsTotal > 0, "shardsTotal must either be -1 or greater than 0");
        this.shardsTotal = shardsTotal;
        return this;
    }

    public DefaultShardManagerBuilder setToken(String token) {
        Checks.notBlank(token, "token");
        this.token = token;
        return this;
    }

    public DefaultShardManagerBuilder setUseShutdownNow(boolean useShutdownNow) {
        this.useShutdownNow = useShutdownNow;
        return this;
    }

    public DefaultShardManagerBuilder setWebsocketFactory(WebSocketFactory factory) {
        this.wsFactory = factory;
        return this;
    }

    public ShardManager build() throws LoginException, IllegalArgumentException {
        DefaultShardManager manager = new DefaultShardManager(this.shardsTotal, this.shards, this.sessionController, this.listeners, this.listenerProviders, this.token, this.eventManagerProvider, this.audioSendFactory, this.gameProvider, this.statusProvider, this.httpClientBuilder, this.httpClient, this.rateLimitPoolProvider, this.gatewayPoolProvider, this.callbackPoolProvider, this.wsFactory, this.threadFactory, this.maxReconnectDelay, this.corePoolSize, this.enableVoice, this.enableShutdownHook, this.enableBulkDeleteSplitting, this.autoReconnect, this.idleProvider, this.retryOnTimeout, this.useShutdownNow, this.enableContext, this.contextProvider, this.cacheFlags, this.enableCompression);
        manager.login();
        return manager;
    }

    private static class ThreadPoolProviderImpl<T extends ExecutorService>
    implements ThreadPoolProvider<T> {
        private final boolean autoShutdown;
        private final T pool;

        public ThreadPoolProviderImpl(T pool, boolean autoShutdown) {
            this.autoShutdown = autoShutdown;
            this.pool = pool;
        }

        @Override
        public T provide(int shardId) {
            return this.pool;
        }

        @Override
        public boolean shouldShutdownAutomatically(int shardId) {
            return this.autoShutdown;
        }
    }
}

